/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.generator;

import cloud.agileframework.common.util.array.ArrayUtil;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class RandomStringUtil
extends RandomStringUtils {
    private static final String[] LETTERS_OF_LOWERS = new String[]{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "a", "s", "d", "f", "g", "h", "j", "k", "l", "z", "x", "c", "v", "b", "n", "m"};
    private static final String[] LETTERS_OF_UPPERS = new String[]{"Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "A", "S", "D", "F", "G", "H", "J", "K", "L", "Z", "X", "C", "V", "B", "N", "M"};
    private static final String[] SYMBOLS = new String[]{"!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "_", "+", "{", "}", "|", "}", "[", "]", "\\", ":", "\"", ";", "'", "<", ">", ",", ".", "?", "/", "~", "`"};
    private static final String[] NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    private static final int DIGIT = 32;

    public static String getRandom(int digit, int group, String delimiter, String pre, String suffix, Random random) {
        pre = StringUtils.isEmpty((CharSequence)pre) ? "" : pre;
        suffix = StringUtils.isEmpty((CharSequence)suffix) ? "" : suffix;
        int count = digit - pre.length() - suffix.length();
        if (count < 0) {
            return null;
        }
        StringBuilder result = new StringBuilder(pre);
        Object[] temp = null;
        switch (random) {
            case NUMBER: {
                temp = NUMBERS;
                break;
            }
            case LETTER: {
                temp = ArrayUtils.addAll((Object[])LETTERS_OF_LOWERS, (Object[])LETTERS_OF_UPPERS);
                break;
            }
            case LETTER_LOWER: {
                temp = LETTERS_OF_LOWERS;
                break;
            }
            case LETTER_UPPER: {
                temp = LETTERS_OF_UPPERS;
                break;
            }
            case MIX_1: {
                temp = ArrayUtil.addAll(LETTERS_OF_LOWERS, LETTERS_OF_UPPERS, NUMBERS);
                break;
            }
            case MIX_2: {
                temp = ArrayUtil.addAll(LETTERS_OF_LOWERS, LETTERS_OF_UPPERS, SYMBOLS, NUMBERS);
                break;
            }
            case ROUTINE: {
                return RandomStringUtil.routine(Boolean.TRUE);
            }
            case ROUTINE_NO_LINE: {
                return RandomStringUtil.routine(Boolean.FALSE);
            }
        }
        if (!ArrayUtil.isEmpty((Object[])temp) && temp.length > 0) {
            for (int i = 0; i < count; ++i) {
                if (group > 0 && i > 0 && i % group == 0) {
                    result.append(delimiter);
                }
                result.append(temp[(int)(Math.random() * (double)(temp.length - 1))]);
            }
        }
        result.append(suffix);
        return result.toString();
    }

    public static String getRandom(int digit, int group, String delimiter, Random random) {
        return RandomStringUtil.getRandom(digit, group, delimiter, null, null, random);
    }

    public static String getRandom(int digit, int group, String delimiter, String pre, Random random) {
        return RandomStringUtil.getRandom(digit, group, delimiter, pre, null, random);
    }

    public static String getRandom(int digit, String pre, String suffix, Random random) {
        return RandomStringUtil.getRandom(digit, 0, null, pre, suffix, random);
    }

    public static String getRandom(int digit, String pre, Random random) {
        return RandomStringUtil.getRandom(digit, 0, null, pre, null, random);
    }

    public static String getRandom(int digit, Random random) {
        return RandomStringUtil.getRandom(digit, 0, null, null, null, random);
    }

    public static String getRandom(Random random) {
        return RandomStringUtil.getRandom(32, 0, null, null, null, random);
    }

    public static String routine(boolean haveLine) {
        return haveLine ? UUID.randomUUID().toString() : UUID.randomUUID().toString().replace("-", "");
    }

    public static enum Random {
        NUMBER,
        LETTER,
        LETTER_LOWER,
        LETTER_UPPER,
        MIX_1,
        MIX_2,
        ROUTINE,
        ROUTINE_NO_LINE;

    }
}

