/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file.poi;

import cloud.agileframework.common.util.file.poi.CellInfo;
import com.google.common.collect.Lists;
import java.util.List;

public class SheetData {
    private String name;
    private List<CellInfo> cells;
    private List<Object> data;

    public SheetData() {
    }

    public SheetData(String name, List<CellInfo> cells, List<Object> data) {
        this.name = name;
        this.cells = cells;
        this.data = data;
    }

    private SheetData(Builder builder) {
        this.name = builder.name;
        this.cells = builder.cells;
        this.data = builder.data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        if (this.name == null) {
            return "\u6570\u636e";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    public List<CellInfo> getCells() {
        return this.cells;
    }

    public void setCells(List<CellInfo> cells) {
        this.cells = cells;
    }

    public SheetData addCell(CellInfo cell) {
        if (this.cells == null) {
            this.cells = Lists.newCopyOnWriteArrayList();
        }
        this.cells.add(cell);
        return this;
    }

    public static class Builder {
        private String name;
        private List<CellInfo> cells;
        private List<Object> data;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setCells(List<CellInfo> cells) {
            this.cells = cells;
            return this;
        }

        public Builder setData(List<Object> data) {
            this.data = data;
            return this;
        }

        public SheetData build() {
            return new SheetData(this);
        }
    }
}

