/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file.poi;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.CollectionsUtil;
import cloud.agileframework.common.util.file.poi.CellInfo;
import cloud.agileframework.common.util.file.poi.ExcelFormatException;
import cloud.agileframework.common.util.file.poi.SheetData;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIUtil {
    private static final String SORT_FIELD_NAME = "sort";
    public static final DataFormatter DATA_FORMATTER = new DataFormatter();

    public static Workbook creatExcel(VERSION version, SheetData ... sheetData) {
        HSSFWorkbook excel = null;
        switch (version) {
            case V2003: {
                excel = new HSSFWorkbook();
                break;
            }
            case V2007: {
                excel = new XSSFWorkbook();
                break;
            }
            case V2008: {
                excel = new SXSSFWorkbook();
                break;
            }
        }
        for (SheetData sheetDatum : sheetData) {
            POIUtil.creatSheet((Workbook)excel, sheetDatum);
        }
        return excel;
    }

    private static void creatSheet(Workbook excel, SheetData sheetData) {
        Sheet sheet = excel.createSheet(sheetData.getName());
        if (sheet instanceof SXSSFSheet) {
            ((SXSSFSheet)sheet).trackAllColumnsForAutoSizing();
        }
        int currentRowIndex = 0;
        List<CellInfo> headerColumns = sheetData.getCells();
        List<Object> data = sheetData.getData();
        if (!CollectionUtils.isEmpty(headerColumns)) {
            CollectionsUtil.sort(headerColumns, SORT_FIELD_NAME);
            Row row = sheet.createRow(currentRowIndex++);
            for (int i = 0; i < headerColumns.size(); ++i) {
                row.createCell(i).setCellValue(headerColumns.get(i).getName());
            }
            if (data == null) {
                return;
            }
            for (Object datum : data) {
                POIUtil.createRow(sheet, datum, currentRowIndex++, headerColumns);
            }
        } else {
            if (data == null) {
                return;
            }
            for (Object datum : data) {
                POIUtil.createRow(sheet, datum, currentRowIndex++);
            }
        }
    }

    private static void createRow(Sheet sheet, Object rowData, int rowIndex) {
        Row row = sheet.createRow(rowIndex);
        int currentColumnIndex = 0;
        if (rowData == null) {
            return;
        }
        Map<String, Object> data = ObjectUtil.to(rowData, new TypeReference<Map<String, Object>>(){});
        for (Object cell : data.values()) {
            row.createCell(currentColumnIndex++).setCellValue(ObjectUtil.to(cell, new TypeReference<String>(){}));
        }
    }

    private static void createRow(Sheet sheet, Object rowData, int rowIndex, List<CellInfo> headerColumns) {
        Row row = sheet.createRow(rowIndex);
        int currentColumnIndex = 0;
        for (CellInfo cell : headerColumns) {
            Object currentCellData = null;
            if (rowData instanceof Map) {
                currentCellData = ((Map)rowData).get(cell.getKey());
            } else if (rowData instanceof List) {
                Object o = ((List)rowData).get(currentColumnIndex);
                if (o instanceof CellInfo) {
                    currentCellData = ((CellInfo)o).getName();
                } else if (o instanceof String) {
                    currentCellData = o;
                }
            } else if (rowData != null) {
                try {
                    Field field = rowData.getClass().getDeclaredField(cell.getKey());
                    field.setAccessible(true);
                    currentCellData = field.get(rowData);
                }
                catch (IllegalAccessException | NoSuchFieldException field) {
                    // empty catch block
                }
            }
            Object value = cell.getSerialize().apply(currentCellData);
            if (value instanceof Date) {
                row.createCell(currentColumnIndex++).setCellValue((Date)value);
                continue;
            }
            if (value instanceof Double) {
                row.createCell(currentColumnIndex++).setCellValue(((Double)value).doubleValue());
                continue;
            }
            if (value instanceof String) {
                row.createCell(currentColumnIndex++).setCellValue((String)value);
                continue;
            }
            if (value instanceof Boolean) {
                row.createCell(currentColumnIndex++).setCellValue(((Boolean)value).booleanValue());
                continue;
            }
            row.createCell(currentColumnIndex++).setCellValue("");
        }
    }

    public static <T> List<T> readExcel(Class<T> clazz, File file) throws IOException {
        return POIUtil.readExcel(new TypeReference(clazz), file, null);
    }

    public static List<Map<String, Object>> readExcel(File file, List<CellInfo> columns) throws IOException {
        return POIUtil.readExcel(new TypeReference<Map<String, Object>>(){}, file, columns);
    }

    public static <T> List<T> readExcel(TypeReference<T> typeReference, File file, List<CellInfo> columns) throws IOException {
        Workbook excel = POIUtil.readFile(file);
        return POIUtil.readExcel(typeReference, columns, excel);
    }

    public static <T> List<T> readExcel(TypeReference<T> typeReference, List<CellInfo> columns, Workbook excel) throws ExcelFormatException {
        if (excel == null) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        Iterator sheets = excel.sheetIterator();
        while (sheets.hasNext()) {
            list.addAll(POIUtil.readSheet(typeReference, columns, (Sheet)sheets.next(), excel));
        }
        return list;
    }

    public static List<Map<String, Object>> readSheet(List<CellInfo> columns, Sheet sheet, Workbook workbook) throws ExcelFormatException {
        return POIUtil.readSheet(new TypeReference<Map<String, Object>>(){}, columns, sheet, workbook);
    }

    public static <T> List<T> readSheet(Class<T> clazz, List<CellInfo> columns, Sheet sheet, Workbook workbook) throws ExcelFormatException {
        return POIUtil.readSheet(new TypeReference(clazz), columns, sheet, workbook);
    }

    public static void readColumnInfo(List<CellInfo> columns, Sheet sheet) throws ExcelFormatException {
        Map<String, CellInfo> columnMapping = columns.stream().collect(Collectors.toMap(a -> a.getName().trim(), a -> a));
        if (columnMapping.isEmpty()) {
            return;
        }
        Iterator rows = sheet.rowIterator();
        if (!rows.hasNext()) {
            return;
        }
        Row row = (Row)rows.next();
        Iterator cells = row.cellIterator();
        int cellIndex = 0;
        while (cells.hasNext()) {
            Cell cell = (Cell)cells.next();
            String cellName = cell.getStringCellValue().trim();
            if (StringUtils.isBlank((CharSequence)cellName)) {
                ++cellIndex;
                continue;
            }
            CellInfo cellInfo = columnMapping.get(cellName);
            if (cellInfo != null) {
                cellInfo.setSort(cellIndex);
            }
            ++cellIndex;
        }
        List unknownColumns = columns.stream().filter(a -> a.getSort() == -1).collect(Collectors.toList());
        for (CellInfo cellInfo : unknownColumns) {
            if (!cellInfo.isRequire()) continue;
            throw new ExcelFormatException();
        }
        Collections.sort(columns);
    }

    public static <T> List<T> readSheet(TypeReference<T> typeReference, List<CellInfo> columns, Sheet sheet, Workbook workbook) throws ExcelFormatException {
        ArrayList list = Lists.newArrayList();
        POIUtil.readColumnInfo(columns, sheet);
        if (columns.stream().allMatch(cellInfo -> cellInfo.getSort() == -1)) {
            return list;
        }
        Iterator rows = sheet.rowIterator();
        int rowNum = 0;
        while (rows.hasNext()) {
            if (rowNum != 0) {
                Row row = (Row)rows.next();
                T result = POIUtil.readRow(typeReference, columns, row, workbook);
                if (result == null) continue;
                list.add(result);
            }
            ++rowNum;
        }
        return list;
    }

    public static <T> T readRow(TypeReference<T> typeReference, List<CellInfo> columnInfo, Row row, Workbook workbook) {
        LinkedHashMap rowData = new LinkedHashMap();
        Iterator cells = row.cellIterator();
        while (cells.hasNext()) {
            Cell cell = (Cell)cells.next();
            int dataCellIndex = cell.getColumnIndex();
            Object value = POIUtil.getValue(cell, workbook);
            CellInfo cellInfo = columnInfo.stream().filter(a -> dataCellIndex == a.getSort()).findFirst().orElse(null);
            if (cellInfo == null) continue;
            Object v = ObjectUtil.to(cellInfo.getDeserialize().apply(value), new TypeReference(cellInfo.getType()));
            rowData.put(cellInfo.getKey(), v);
        }
        return ObjectUtil.to(rowData, typeReference);
    }

    public static Object getValue(Cell cell, Workbook workbook) {
        Object result = null;
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        switch (cell.getCellType()) {
            case STRING: {
                String value = cell.getStringCellValue();
                if (StringUtils.isBlank((CharSequence)value)) break;
                result = value.trim();
                break;
            }
            case ERROR: {
                result = cell.getErrorCellValue();
                break;
            }
            case BOOLEAN: {
                result = cell.getBooleanCellValue();
                break;
            }
            case FORMULA: 
            case NUMERIC: {
                result = DATA_FORMATTER.formatCellValue(cell, evaluator);
                break;
            }
        }
        return result;
    }

    public static Workbook readFile(File file) throws IOException {
        return POIUtil.readFile(file.getName(), Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static Workbook readFile(String fileName, InputStream inputStream) throws IOException {
        String[] s = fileName.split("[.]");
        String suffix = null;
        if (s.length > 1) {
            suffix = s[s.length - 1];
        }
        String xls = "xls";
        Object result = "xls".equals(suffix) ? new HSSFWorkbook(inputStream) : new XSSFWorkbook(inputStream);
        return result;
    }

    public static void removeRow(Sheet sheet, int rowIndex) {
        Row removingRow;
        int lastRowNum = sheet.getLastRowNum();
        if (rowIndex >= 0 && rowIndex < lastRowNum) {
            sheet.shiftRows(rowIndex + 1, lastRowNum, -1);
        }
        if (rowIndex == lastRowNum && (removingRow = sheet.getRow(rowIndex)) != null) {
            sheet.removeRow(removingRow);
        }
    }

    public static void addCellValue(Workbook workbook, Cell cell, String value, Font font) {
        RichTextString text = workbook.getCreationHelper().createRichTextString(value);
        text.applyFont(font);
        cell.setCellValue(text);
    }

    public static void addComment(Workbook workbook, Cell cell, String value) {
        Sheet sheet = cell.getSheet();
        cell.removeCellComment();
        ClientAnchor anchor = workbook.getCreationHelper().createClientAnchor();
        RichTextString text = workbook.getCreationHelper().createRichTextString(value);
        anchor.setDx1(0);
        anchor.setDx2(0);
        anchor.setDy1(0);
        anchor.setDy2(0);
        anchor.setCol1(cell.getColumnIndex());
        anchor.setRow1(cell.getRowIndex());
        anchor.setCol2(cell.getColumnIndex() + 2);
        anchor.setRow2(cell.getRowIndex() + 2);
        Drawing drawing = sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(text);
        cell.setCellComment(comment);
    }

    public static enum VERSION {
        V2003,
        V2007,
        V2008;

    }
}

