/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file.poi;

import java.util.function.UnaryOperator;

public class CellInfo
implements Comparable<CellInfo> {
    private int sort;
    private String key;
    private String name;
    private Class<?> type;
    private boolean require;
    private UnaryOperator<Object> deserialize;
    private UnaryOperator<Object> serialize;

    private CellInfo(Builder builder) {
        this.sort = builder.sort;
        this.key = builder.key;
        this.name = builder.name;
        this.type = builder.type;
        this.require = builder.require;
        this.serialize = builder.serialize;
        this.deserialize = builder.deserialize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getSort() {
        return this.sort;
    }

    public void setSort(int sort) {
        this.sort = sort;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isRequire() {
        return this.require;
    }

    public void setRequire(boolean require) {
        this.require = require;
    }

    public UnaryOperator<Object> getDeserialize() {
        return this.deserialize;
    }

    public void setDeserialize(UnaryOperator<Object> deserialize) {
        this.deserialize = deserialize;
    }

    public UnaryOperator<Object> getSerialize() {
        return this.serialize;
    }

    public void setSerialize(UnaryOperator<Object> serialize) {
        this.serialize = serialize;
    }

    @Override
    public int compareTo(CellInfo o) {
        return this.getSort() - o.getSort();
    }

    public static class Builder {
        private int sort = -1;
        private String key;
        private String name;
        private Class<?> type = Object.class;
        private boolean require = true;
        private UnaryOperator<Object> deserialize = a -> a;
        private UnaryOperator<Object> serialize = a -> a;

        public Builder sort(int sort) {
            this.sort = sort;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Class<?> type) {
            this.type = type;
            return this;
        }

        public Builder require(boolean require) {
            this.require = require;
            return this;
        }

        public Builder deserialize(UnaryOperator<Object> deserialize) {
            this.deserialize = deserialize;
            return this;
        }

        public Builder serialize(UnaryOperator<Object> serialize) {
            this.serialize = serialize;
            return this;
        }

        public CellInfo build() {
            return new CellInfo(this);
        }
    }
}

