/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Map;

public class ResponseFile {
    private String fileName;
    private String contentType;
    private InputStream inputStream;
    private Map<String, String> head = Maps.newHashMap();
    private boolean isDownload;

    public ResponseFile(String fileName, Map<String, String> head, InputStream inputStream, boolean isDownload) {
        this.fileName = fileName;
        this.inputStream = inputStream;
        this.isDownload = isDownload;
        this.head = head;
    }

    public ResponseFile(String fileName, String contentType, InputStream inputStream, boolean isDownload) {
        this.fileName = fileName;
        this.contentType = contentType;
        this.inputStream = inputStream;
        this.isDownload = isDownload;
    }

    public ResponseFile(String fileName, String contentType, InputStream inputStream) {
        this(fileName, contentType, inputStream, true);
    }

    public ResponseFile(String fileName, String contentType, File file) throws FileNotFoundException {
        this(fileName, contentType, new FileInputStream(file));
    }

    public ResponseFile(String fileName, File file) throws FileNotFoundException {
        this(fileName, null, new FileInputStream(file));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean isDownload() {
        return this.isDownload;
    }

    public void setDownload(boolean download) {
        this.isDownload = download;
    }

    public Map<String, String> getHead() {
        return this.head;
    }

    public void setHead(Map<String, String> head) {
        this.head.putAll(head);
    }

    public void setHead(String key, String value) {
        this.head.put(key, value);
    }
}

