/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file;

import cloud.agileframework.common.util.array.ArrayUtil;
import cloud.agileframework.common.util.file.ResponseFile;
import cloud.agileframework.common.util.file.poi.ExcelFile;
import cloud.agileframework.common.util.string.StringUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;

public class FileUtil
extends FileUtils {
    private static final Map<String, Object> FILE_FORMAT_MAP = new HashMap<String, Object>(54);

    public static String getFormat(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            return FileUtil.getFormat(in, file.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFormat(InputStream inputStream, String fileName) {
        String result = null;
        try {
            String extension = StringUtil.getFilenameExtension(fileName);
            if (!StringUtil.isEmpty((CharSequence)extension)) {
                return extension;
            }
            int length = 20;
            byte[] header = new byte[20];
            int i = inputStream.read(header);
            if (i <= 0) {
                result = null;
            } else {
                String headerHex = StringUtil.coverToHex(header);
                if (StringUtil.isEmpty((CharSequence)headerHex)) {
                    result = null;
                } else {
                    for (Map.Entry<String, Object> map : FILE_FORMAT_MAP.entrySet()) {
                        if (!headerHex.contains(map.getKey())) continue;
                        Object value = map.getValue();
                        if (value.getClass().isArray()) {
                            String[] values = (String[])value;
                            result = ArrayUtil.toString((Object)values);
                            continue;
                        }
                        result = map.getValue().toString();
                    }
                }
            }
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static void downloadFile(String fileName, InputStream stream, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileUtil.setContentLength(stream, response);
        FileUtil.setContentDisposition(fileName, response);
        ServletOutputStream outputStream = response.getOutputStream();
        FileUtil.inWriteOut(stream, (OutputStream)response.getOutputStream());
        outputStream.close();
    }

    public static void downloadFile(String fileName, File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileUtil.downloadFile(fileName, new FileInputStream(file), request, response);
    }

    private static void setContentLength(InputStream stream, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Length", String.valueOf(stream.available()));
    }

    private static void setContentDisposition(String fileName, HttpServletResponse response) throws UnsupportedEncodingException {
        response.setHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8") + "; filename*=UTF-8''" + URLEncoder.encode(fileName, "UTF-8") + ";");
    }

    public static void downloadFile(File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileUtil.downloadFile(file.getName(), file, request, response);
    }

    public static void downloadFile(ExcelFile excelFile, HttpServletRequest request, HttpServletResponse response) throws IOException {
        FileUtil.setContentDisposition(excelFile.getFileName(), response);
        response.setContentType("application.properties/vnd.ms-excel");
        excelFile.getWorkbook().write((OutputStream)response.getOutputStream());
    }

    public static void downloadFile(Object value, HttpServletRequest request, HttpServletResponse response, String tempPath) throws IOException {
        if (value == null) {
            return;
        }
        Object v = null;
        if (List.class.isAssignableFrom(value.getClass())) {
            int size = ((List)value).size();
            if (size > 1) {
                FileUtil.downloadZip((List)value, request, response, tempPath);
                return;
            }
            if (size == 1) {
                v = ((List)value).get(0);
            }
        } else {
            v = value;
        }
        if (v == null) {
            return;
        }
        if (v instanceof ExcelFile) {
            FileUtil.downloadFile((ExcelFile)v, request, response);
        } else if (ResponseFile.class.isAssignableFrom(v.getClass())) {
            String contentType;
            ResponseFile temp = (ResponseFile)v;
            Map<String, String> head = temp.getHead();
            if (!head.isEmpty()) {
                for (Map.Entry<String, String> entry : head.entrySet()) {
                    response.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((contentType = temp.getContentType()) == null) {
                contentType = "application/octet-stream;charset=UTF-8";
            }
            response.setContentType(contentType);
            if (!temp.isDownload()) {
                response.setCharacterEncoding(Charset.defaultCharset().name());
                FileUtil.inWriteOut(temp.getInputStream(), (OutputStream)response.getOutputStream());
                return;
            }
            FileUtil.downloadFile(temp.getFileName(), temp.getInputStream(), request, response);
        } else if (File.class.isAssignableFrom(v.getClass())) {
            response.setContentType(new MimetypesFileTypeMap().getContentType((File)v));
            FileUtil.downloadFile((File)v, request, response);
        }
    }

    public static void downloadZip(List<?> fileList, HttpServletRequest request, HttpServletResponse response, String tempPath) throws IOException {
        File zip = FileUtil.createFile(tempPath, "download.zip");
        if (zip != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileUtil.createZipFile(fileList, new FileOutputStream(zip));
            FileInputStream in = new FileInputStream(zip);
            FileUtil.inWriteOut(in, out);
            response.setContentType("application/octet-stream;charset=UTF-8");
            FileUtil.downloadFile("download.zip", new ByteArrayInputStream(out.toByteArray()), request, response);
            out.close();
            boolean isDelete = zip.delete();
            if (!isDelete) {
                throw new RuntimeException("zip cache delete fail");
            }
        }
    }

    public static void createZip(List<?> fileList, String dir, String zipFileName) throws IOException {
        File zip;
        if (!zipFileName.toLowerCase().endsWith(".zip")) {
            zipFileName = zipFileName + ".zip";
        }
        if ((zip = FileUtil.createFile(dir, zipFileName)) == null) {
            throw new IOException("file create fail");
        }
        FileUtil.createZipFile(fileList, new FileOutputStream(zip));
    }

    public static File createFile(String path, String fileName) throws IOException {
        File file;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
            if (!dir.exists()) {
                return null;
            }
        }
        if (!(file = new File(dir.getPath() + File.separator + fileName)).exists()) {
            file.createNewFile();
            if (!file.exists()) {
                return null;
            }
        }
        return file;
    }

    private static void createZipFile(List<?> fileList, OutputStream outputStream) throws IOException {
        ZipOutputStream out = new ZipOutputStream(outputStream);
        FileUtil.zipFile(fileList, out);
    }

    private static void zipFile(List<?> fileList, ZipOutputStream out) throws IOException {
        if (fileList != null && !fileList.isEmpty()) {
            for (Object fileObject : fileList) {
                if (fileObject instanceof String) {
                    String fileAllName = (String)fileObject;
                    URL url = new URL(fileAllName);
                    URLConnection connection = url.openConnection();
                    InputStream fileInputStream = connection.getInputStream();
                    String fileName = File.separatorChar + fileAllName.substring(fileAllName.lastIndexOf("/") + 1);
                    out.putNextEntry(new ZipEntry(fileName));
                    FileUtil.inWriteOut(fileInputStream, out);
                    continue;
                }
                if (fileObject instanceof ExcelFile) {
                    out.putNextEntry(new ZipEntry(((ExcelFile)fileObject).getFileName()));
                    ((ExcelFile)fileObject).getWorkbook().write((OutputStream)out);
                    continue;
                }
                if (ResponseFile.class.isAssignableFrom(fileObject.getClass())) {
                    out.putNextEntry(new ZipEntry(((ResponseFile)fileObject).getFileName()));
                    FileUtil.inWriteOut(((ResponseFile)fileObject).getInputStream(), out);
                    continue;
                }
                if (!File.class.isAssignableFrom(fileObject.getClass())) continue;
                out.putNextEntry(new ZipEntry(((File)fileObject).getName()));
                FileUtil.inWriteOut(new FileInputStream((File)fileObject), out);
            }
        }
        out.flush();
        out.close();
    }

    public static void inWriteOut(InputStream inputStream, OutputStream outputStream) throws IOException {
        int r;
        int length = 1024;
        byte[] buffer = new byte[1024];
        while ((r = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, r);
        }
        inputStream.close();
        outputStream.flush();
    }

    public static boolean isFile(Object value) {
        if (value == null) {
            return false;
        }
        return value instanceof ExcelFile || ResponseFile.class.isAssignableFrom(value.getClass()) || File.class.isAssignableFrom(value.getClass());
    }

    public static void write(File file, String text) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(text);
        writer.close();
    }

    public static boolean isIllegalDirName(String dirName) {
        return dirName.matches("(.*)([\\\\/.~:*?\"<>|])(.*)");
    }

    public static String parseFilePath(String str) {
        String url = str.replaceAll("[\\\\/]+", Matcher.quoteReplacement(File.separator));
        if (!url.endsWith(File.separator)) {
            url = url + File.separator;
        }
        return url;
    }

    public static String parseClassPath(String str) {
        String prefix = "/";
        String url = str.replaceAll("[\\\\/]+", prefix);
        if (!url.startsWith(prefix)) {
            url = prefix + url;
        }
        return url;
    }

    static {
        FILE_FORMAT_MAP.put("FFD8FFE", "JPG");
        FILE_FORMAT_MAP.put("89504E47", "PNG");
        FILE_FORMAT_MAP.put("47494638", "GIF");
        FILE_FORMAT_MAP.put("49492A00", "TIF");
        FILE_FORMAT_MAP.put("424D", "BMP");
        FILE_FORMAT_MAP.put("41433130", "DWG");
        FILE_FORMAT_MAP.put("68746D", "HTML");
        FILE_FORMAT_MAP.put("0D0A3C", "HTM");
        FILE_FORMAT_MAP.put("48544D4C207B0D0A0942", "CSS");
        FILE_FORMAT_MAP.put("696B2E71623D696B2E71", "JS");
        FILE_FORMAT_MAP.put("7B5C727466", "RTF");
        FILE_FORMAT_MAP.put("38425053", "PSD");
        FILE_FORMAT_MAP.put("44656C69766572792D646174653A", "EML");
        FILE_FORMAT_MAP.put("D0CF11E0", new String[]{"DOC", "XLS"});
        FILE_FORMAT_MAP.put("5374616E64617264204A", "MDB");
        FILE_FORMAT_MAP.put("252150532D41646F6265", "PS");
        FILE_FORMAT_MAP.put("255044462D312E", "PDF");
        FILE_FORMAT_MAP.put("2E524D46", "RMVB");
        FILE_FORMAT_MAP.put("464C5601050000000900", "FLV");
        FILE_FORMAT_MAP.put("00000020667479706D70", "MP4");
        FILE_FORMAT_MAP.put("49443303000000002176", "MP3");
        FILE_FORMAT_MAP.put("000001BA", "MPG");
        FILE_FORMAT_MAP.put("000001B3", "MPG");
        FILE_FORMAT_MAP.put("3026B2758E66CF11", "WMV");
        FILE_FORMAT_MAP.put("57415645", "WAV");
        FILE_FORMAT_MAP.put("41564920", "AVI");
        FILE_FORMAT_MAP.put("4D546864", "MID");
        FILE_FORMAT_MAP.put("504B0304", "ZIP");
        FILE_FORMAT_MAP.put("52617221", "RAR");
        FILE_FORMAT_MAP.put("235468697320636F6E66", "INI");
        FILE_FORMAT_MAP.put("504B03040A0000000000", "JAR");
        FILE_FORMAT_MAP.put("4D5A9000030000000400", "EXE");
        FILE_FORMAT_MAP.put("3C25402070616765206C", "JSP");
        FILE_FORMAT_MAP.put("4D616E69666573742D56", "MF");
        FILE_FORMAT_MAP.put("3C3F786D6C", "XML");
        FILE_FORMAT_MAP.put("494E5345525420494E54", "SQL");
        FILE_FORMAT_MAP.put("7061636B61", "JAVA");
        FILE_FORMAT_MAP.put("0D0A726F", "BAT");
        FILE_FORMAT_MAP.put("1F8B0800000000000000", "GZ");
        FILE_FORMAT_MAP.put("6C6F67346A2E726F6F74", "PROPERTIES");
        FILE_FORMAT_MAP.put("CAFEBABE", "CLASS");
        FILE_FORMAT_MAP.put("49545346030000006000", "CHM");
        FILE_FORMAT_MAP.put("04000000010000001300", "MXP");
        FILE_FORMAT_MAP.put("504B0304140006000800", "DOCX");
        FILE_FORMAT_MAP.put("D0CF11E0A1B11AE10000", new String[]{"WPS", "VSD"});
        FILE_FORMAT_MAP.put("6431303A637265617465", "TORRENT");
        FILE_FORMAT_MAP.put("3C68746D6C20786D6C6E", "HTM");
        FILE_FORMAT_MAP.put("46726F6D3A3CD3C920CD", "MHT");
        FILE_FORMAT_MAP.put("6D6F6F76", "MOV");
        FILE_FORMAT_MAP.put("FF575043", "WPD");
        FILE_FORMAT_MAP.put("CFAD12FEC5FD746F", "DBX");
        FILE_FORMAT_MAP.put("2142444E", "PST");
        FILE_FORMAT_MAP.put("AC9EBD8F", "QDF");
        FILE_FORMAT_MAP.put("E3828596", "PWL");
        FILE_FORMAT_MAP.put("2E7261FD", "RAM");
    }
}

