/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.command;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandUtil {
    private static final Logger log = LoggerFactory.getLogger(CommandUtil.class);

    public static boolean extractProcess(Process p) throws IOException {
        InputStreamReader input = new InputStreamReader(p.getInputStream());
        InputStreamReader errors = new InputStreamReader(p.getErrorStream());
        for (String line : IOUtils.readLines((Reader)input)) {
            if (line.startsWith("[ERROR]")) {
                log.error(line);
                continue;
            }
            if (line.startsWith("[WARNING]")) {
                log.warn(line);
                continue;
            }
            log.info(line);
        }
        for (String line : IOUtils.readLines((Reader)errors)) {
            if (line.startsWith("[ERROR]")) {
                log.error(line);
                continue;
            }
            if (line.startsWith("[WARNING]")) {
                log.warn(line);
                continue;
            }
            log.info(line);
        }
        p.getOutputStream().close();
        try {
            if (p.waitFor() != 0) {
                log.warn("The command did not complete successfully");
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }
}

