/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.collection;

import java.io.Serializable;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;

public class TreeBase<I extends Serializable, A extends TreeBase<I, A>>
implements Comparable<TreeBase<I, A>>,
Serializable {
    private I id;
    private I parentId;
    private Integer sort;
    private SortedSet<A> children;

    public TreeBase() {
        this.children = new ConcurrentSkipListSet<A>();
    }

    public static <C extends Serializable> C rootParentId() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TreeBase)) {
            return false;
        }
        TreeBase treeBase = (TreeBase)o;
        return Objects.equals(this.getId(), treeBase.getId()) && Objects.equals(this.getParentId(), treeBase.getParentId()) && Objects.equals(this.getSort(), treeBase.getSort());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getParentId(), this.getSort());
    }

    @Override
    public int compareTo(TreeBase<I, A> o) {
        if (Objects.equals(this, o)) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        int a = o.getSort() == null ? 0 : o.getSort();
        int b = this.sort == null ? 0 : this.sort;
        int i = b - a;
        return i == 0 ? 1 : i;
    }

    public void setChildren(SortedSet<A> children) {
        if (children == null) {
            return;
        }
        this.children = children;
    }

    public I getId() {
        return this.id;
    }

    public void setId(I id) {
        this.id = id;
    }

    public I getParentId() {
        return this.parentId;
    }

    public void setParentId(I parentId) {
        this.parentId = parentId;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public SortedSet<A> getChildren() {
        return this.children;
    }

    private static <I extends Serializable, A extends TreeBase<I, A>> SortedSet<A> $default$children() {
        return new ConcurrentSkipListSet();
    }

    protected TreeBase(TreeBaseBuilder<I, A, ?, ?> b) {
        this.id = ((TreeBaseBuilder)b).id;
        this.parentId = ((TreeBaseBuilder)b).parentId;
        this.sort = ((TreeBaseBuilder)b).sort;
        this.children = ((TreeBaseBuilder)b).children$set ? ((TreeBaseBuilder)b).children$value : TreeBase.$default$children();
    }

    public static <I extends Serializable, A extends TreeBase<I, A>> TreeBaseBuilder<I, A, ?, ?> builder() {
        return new TreeBaseBuilderImpl();
    }

    public TreeBaseBuilder<I, A, ?, ?> toBuilder() {
        return new TreeBaseBuilderImpl().$fillValuesFrom(this);
    }

    private static final class TreeBaseBuilderImpl<I extends Serializable, A extends TreeBase<I, A>>
    extends TreeBaseBuilder<I, A, TreeBase<I, A>, TreeBaseBuilderImpl<I, A>> {
        private TreeBaseBuilderImpl() {
        }

        @Override
        protected TreeBaseBuilderImpl<I, A> self() {
            return this;
        }

        @Override
        public TreeBase<I, A> build() {
            return new TreeBase(this);
        }
    }

    public static abstract class TreeBaseBuilder<I extends Serializable, A extends TreeBase<I, A>, C extends TreeBase<I, A>, B extends TreeBaseBuilder<I, A, C, B>> {
        private I id;
        private I parentId;
        private Integer sort;
        private boolean children$set;
        private SortedSet<A> children$value;

        protected B $fillValuesFrom(C instance) {
            TreeBaseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <I extends Serializable, A extends TreeBase<I, A>> void $fillValuesFromInstanceIntoBuilder(TreeBase<I, A> instance, TreeBaseBuilder<I, A, ?, ?> b) {
            b.id(((TreeBase)instance).id);
            b.parentId(((TreeBase)instance).parentId);
            b.sort(((TreeBase)instance).sort);
            b.children(((TreeBase)instance).children);
        }

        protected abstract B self();

        public abstract C build();

        public B id(I id) {
            this.id = id;
            return this.self();
        }

        public B parentId(I parentId) {
            this.parentId = parentId;
            return this.self();
        }

        public B sort(Integer sort) {
            this.sort = sort;
            return this.self();
        }

        public B children(SortedSet<A> children) {
            this.children$value = children;
            this.children$set = true;
            return this.self();
        }

        public String toString() {
            return "TreeBase.TreeBaseBuilder(id=" + this.id + ", parentId=" + this.parentId + ", sort=" + this.sort + ", children$value=" + this.children$value + ")";
        }
    }
}

