/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.array;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class ArrayUtil
extends ArrayUtils {
    public static Object last(Object[] array) {
        return array[array.length - 1];
    }

    public static <T> List<T> asList(T ... array) {
        return Arrays.asList(array);
    }

    public static <T> T[] addAll(T[] array1, T[] ... array2) {
        Class<?> type1 = array1.getClass().getComponentType();
        int length = array1.length;
        for (T[] array : array2) {
            length += array.length;
        }
        Object[] joinedArray = (Object[])Array.newInstance(type1, length);
        try {
            System.arraycopy(array1, 0, joinedArray, 0, array1.length);
            int index = array1.length;
            for (T[] array : array2) {
                System.arraycopy(array, 0, joinedArray, index, array.length);
                index += array.length;
            }
            return joinedArray;
        }
        catch (ArrayStoreException var6) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), var6);
            }
            throw var6;
        }
    }
}

