/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.string;

import cloud.agileframework.common.util.array.ArrayUtil;
import cloud.agileframework.common.util.json.JSONUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtil
extends StringUtils {
    public static String vagueMatches(String source, Collection<String> targets) {
        if (targets.contains(source)) {
            return source;
        }
        String underlineSource = StringUtil.toUnderline(source).toLowerCase();
        if (targets.contains(underlineSource)) {
            return underlineSource;
        }
        String camelSource = StringUtil.toCamel(source);
        if (targets.contains(camelSource)) {
            return camelSource;
        }
        String fuzzyMatching = StringUtil.camelToMatchesRegex(source);
        return targets.parallelStream().filter(target -> target.equalsIgnoreCase(source) || PatternUtil.matches(fuzzyMatching, target, 2) || target.equalsIgnoreCase(camelSource) || target.equalsIgnoreCase(underlineSource)).findFirst().orElse(null);
    }

    public static String toSeparator(String text, String separator) {
        String regex = "[A-Z]";
        if (!PatternUtil.find(regex, text)) {
            return text;
        }
        StringBuilder cacheStr = new StringBuilder(text);
        Matcher matcher = PatternUtil.getMatcher(text, Pattern.compile(regex));
        int i = 0;
        while (matcher.find()) {
            int position = matcher.start() + i;
            if (position < 1 || separator.equals(cacheStr.substring(position - 1, position))) continue;
            cacheStr.replace(position, position + 1, separator + cacheStr.substring(position, position + 1).toLowerCase());
            ++i;
        }
        return cacheStr.toString();
    }

    public static String toUnderline(String text) {
        return StringUtil.toSeparator(text, "_");
    }

    public static String toCamel(String text) {
        int position;
        String regex = "((?=[\\x21-\\x7e]+)[^A-Za-z0-9])";
        if (!PatternUtil.find(regex, text)) {
            return text;
        }
        StringBuilder cacheStr = new StringBuilder(text);
        Matcher matcher = Pattern.compile(regex).matcher(text);
        int i = 0;
        while (matcher.find() && (position = matcher.end() - i++) + 1 <= cacheStr.length()) {
            cacheStr.replace(position - 1, position + 1, cacheStr.substring(position, position + 1).toUpperCase());
        }
        return cacheStr.toString();
    }

    public static String camelToMatchesRegex(String text) {
        StringBuilder result = new StringBuilder();
        String[] steps = StringUtil.toUnderline(text).split("_");
        for (int i = 0; i < steps.length; ++i) {
            String step = steps[i];
            String first = step.substring(0, 1);
            result.append(String.format("[%s]", first.toLowerCase() + first.toUpperCase())).append(step.substring(1));
            if (i == steps.length - 1) continue;
            result.append("[\\W_]?");
        }
        return result.toString();
    }

    public static String toUpperName(String text) {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return "";
        }
        String camelString = StringUtil.toCamel(text);
        return camelString.substring(0, 1).toUpperCase() + camelString.substring(1);
    }

    public static String toLowerName(String text) {
        if (StringUtil.isEmpty((CharSequence)text)) {
            return "";
        }
        String camelString = StringUtil.toCamel(text);
        return camelString.substring(0, 1).toLowerCase() + camelString.substring(1);
    }

    public static String parsingPlaceholder(String openToken, String closeToken, String text, Map args) {
        return StringUtil.parsingPlaceholder(openToken, closeToken, ":-", text, args, null);
    }

    public static String parsingPlaceholder(String openToken, String closeToken, String equalToken, String text, Map args) {
        return StringUtil.parsingPlaceholder(openToken, closeToken, equalToken, text, args, null);
    }

    public static String parsingPlaceholder(String openToken, String closeToken, String equalToken, String text, Object args, String replaceNull) {
        if (args == null) {
            if (replaceNull != null) {
                args = new HashMap(0);
            } else {
                return text;
            }
        }
        if (text == null || text.isEmpty()) {
            return "";
        }
        char[] src = text.toCharArray();
        int offset = 0;
        int start = text.indexOf(openToken, offset);
        if (start == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder expression = null;
        while (start > -1) {
            if (start > 0 && src[start - 1] == '\\') {
                builder.append(src, offset, start - offset - 1).append(openToken);
                offset = start + openToken.length();
            } else {
                if (expression == null) {
                    expression = new StringBuilder();
                } else {
                    expression.setLength(0);
                }
                builder.append(src, offset, start - offset);
                offset = start + openToken.length();
                int end = text.indexOf(closeToken, offset);
                while (end > -1) {
                    if (end > offset && src[end - 1] == '\\') {
                        expression.append(src, offset, end - offset - 1).append(closeToken);
                        offset = end + closeToken.length();
                        end = text.indexOf(closeToken, offset);
                        continue;
                    }
                    expression.append(src, offset, end - offset);
                    break;
                }
                if (end == -1) {
                    builder.append(src, start, src.length - start);
                    offset = src.length;
                } else {
                    String key = expression.toString();
                    String[] keyObj = key.split(equalToken);
                    Object o = keyObj.length > 0 ? JSONUtil.pathGet(keyObj[0].trim(), args) : JSONUtil.pathGet(key.trim(), args);
                    String value = o == null || ObjectUtils.isEmpty((Object)o) ? (key.contains(equalToken) ? keyObj[1].trim() : (replaceNull != null ? replaceNull : openToken + key + closeToken)) : String.valueOf(o);
                    builder.append(value);
                    offset = end + closeToken.length();
                }
            }
            start = text.indexOf(openToken, offset);
        }
        if (offset < src.length) {
            builder.append(src, offset, src.length - offset);
        }
        return builder.toString();
    }

    public static String removeExtension(String str) {
        if (!StringUtil.isEmpty((CharSequence)str) && str.contains(".")) {
            return str.substring(0, str.lastIndexOf("."));
        }
        return str;
    }

    public static String getSplitAtomic(String source, String regex, int index) {
        String[] atomics;
        if (source != null && (atomics = source.split(regex)).length > index) {
            return atomics[index];
        }
        return null;
    }

    public static String getSplitLastAtomic(String source, String regex) {
        String[] atomics;
        if (source != null && (atomics = source.split(regex)).length > 0) {
            return atomics[atomics.length - 1];
        }
        return null;
    }

    public static String getSplitByStrLastAtomic(String source, String regex) {
        String[] atomics;
        if (source != null && (atomics = StringUtils.split((String)source, (String)regex)).length > 0) {
            return atomics[atomics.length - 1];
        }
        return null;
    }

    public static Map<String, String> getGroupByStartEnd(String el, String startChar, String endChar, String equalChar) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int index = el.indexOf(startChar);
        if (index == -1) {
            return map;
        }
        String last = el;
        while (index > -1 && index < el.length()) {
            int first = last.indexOf(startChar);
            last = last.substring(first + startChar.length());
            index += first + startChar.length();
            int end = last.indexOf(endChar);
            if (end == -1) {
                return map;
            }
            String mapV = last.substring(0, end);
            int consume = end + endChar.length();
            index += consume;
            last = last.substring(consume);
            String[] mapVs = mapV.split(equalChar);
            map.put(mapVs[0], mapVs.length > 1 ? mapVs[1] : null);
        }
        return map;
    }

    public static Map<String, String> getParamFromMapping(String url, String mapUrl) {
        String left = "{";
        String right = "}";
        String equal = ":";
        int minLength = 2;
        if (StringUtil.isEmpty((CharSequence)mapUrl) || mapUrl.length() <= 2) {
            return null;
        }
        if (!mapUrl.contains("{") || !mapUrl.contains("}")) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (mapUrl.contains(":")) {
            Map<String, String> map = StringUtil.getGroupByStartEnd(mapUrl, "{", "}", ":");
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value = PatternUtil.getMatchedString(entry.getValue(), url, 0);
                if (StringUtil.isBlank((CharSequence)value)) {
                    return null;
                }
                result.put(entry.getKey(), value);
                int start = url.indexOf(value);
                url = url.substring(start + value.length());
            }
        } else {
            result.put(mapUrl.substring(1, mapUrl.length() - 1), url);
        }
        return result;
    }

    public static boolean compareTo(String resource, String target) {
        return resource.length() > target.length();
    }

    public static String coverToHex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        if (ArrayUtil.isEmpty((byte[])bytes)) {
            return null;
        }
        int length = 255;
        int two = 2;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                result.append(0);
            }
            result.append(hv);
        }
        return result.toString().toUpperCase();
    }

    public static String exceptionToString(Throwable e) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            e.printStackTrace(pw);
        }
        return writer.toString();
    }

    public static String getFilenameExtension(String path) {
        if (path == null) {
            return null;
        }
        int extIndex = path.lastIndexOf(46);
        if (extIndex == -1) {
            return null;
        }
        int folderIndex = path.lastIndexOf("/");
        if (folderIndex > extIndex) {
            return null;
        }
        return path.substring(extIndex + 1);
    }
}

