/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.object;

import cloud.agileframework.common.annotation.Alias;
import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.FieldInfo;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.date.DateUtil;
import cloud.agileframework.common.util.map.MapUtil;
import cloud.agileframework.common.util.number.NumberUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;

public class ObjectUtil
extends ObjectUtils {
    private static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static <T> T to(Object from, TypeReference<T> toClass) {
        return ObjectUtil.to(from, toClass, false);
    }

    public static <T> T to(Object from, TypeReference<T> toClass, boolean alias) {
        Object result;
        if (from == null) {
            return null;
        }
        if (toClass.isAssignableFrom(WildcardTypeImpl.class)) {
            try {
                result = from;
            }
            catch (Exception e) {
                result = null;
            }
        } else if (toClass.isEnum()) {
            result = ObjectUtil.toEnum(from, toClass);
        } else if (toClass.isArray()) {
            result = ObjectUtil.toArray(from, toClass);
        } else if (toClass.isExtendsFrom(Collection.class)) {
            result = ObjectUtil.toCollection(from, toClass);
        } else if (toClass.isExtendsFrom(Map.class)) {
            result = ObjectUtil.toMap(from, toClass);
        } else if (toClass.isWrapOrPrimitive() || toClass.getWrapperClass() == String.class) {
            result = ObjectUtil.to(from, toClass.getWrapperClass());
        } else if (toClass.isExtendsFrom(Date.class)) {
            GregorianCalendar calendar;
            result = from instanceof Date ? from : ((calendar = DateUtil.parse(from.toString())) != null ? calendar.getTime() : null);
        } else if (toClass.getType() == from.getClass()) {
            result = from;
        } else {
            Constructor<T> construct2;
            try {
                result = ObjectUtil.toPOJO(from, (Class)toClass.getType(), alias);
            }
            catch (Exception e) {
                result = null;
            }
            if (result == null) {
                try {
                    construct2 = toClass.getConstruct(from.getClass());
                    result = construct2.newInstance(from);
                }
                catch (Exception construct2) {
                    // empty catch block
                }
            }
            if (result == null && ClassUtil.isPrimitive(from.getClass())) {
                try {
                    construct2 = toClass.getConstruct(String.class);
                    result = construct2.newInstance(ObjectUtil.toString(from));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return (T)result;
    }

    public static String toString(Object from) {
        String result = from.getClass().isArray() ? ArrayUtils.toString((Object)from) : (Collection.class.isAssignableFrom(from.getClass()) ? ArrayUtils.toString((Object)((Collection)from).toArray()) : (Map.class.isAssignableFrom(from.getClass()) ? from.toString() : (from.getClass().isEnum() ? ((Enum)from).name() : from.toString())));
        return result;
    }

    private static <T> T toEnum(Object from, TypeReference<T> toClass) {
        if (toClass.isEnum()) {
            try {
                Enum[] v;
                List<String> nameList;
                String targetName;
                Class enumClass = toClass.getWrapperClass();
                String sourceName = from.getClass().isEnum() ? ((Enum)from).name() : from.toString();
                Method values = enumClass.getMethod("values", new Class[0]);
                if (!values.isAccessible()) {
                    values.setAccessible(true);
                }
                if ((targetName = StringUtil.vagueMatches(sourceName, nameList = Stream.of(v = (Enum[])values.invoke(null, new Object[0])).map(Enum::name).collect(Collectors.toList()))) != null) {
                    Method valueOf = enumClass.getMethod("valueOf", String.class);
                    if (!valueOf.isAccessible()) {
                        valueOf.setAccessible(true);
                    }
                    return (T)valueOf.invoke(null, targetName);
                }
                HashMap map = Maps.newHashMapWithExpectedSize((int)v.length);
                nameList = Stream.of(v).map(node -> map.put(node.toString(), node)).filter(Objects::nonNull).map(Enum::toString).collect(Collectors.toList());
                targetName = StringUtil.vagueMatches(sourceName, nameList);
                return (T)map.get(targetName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static <T> T toArray(Object from, TypeReference<T> toClass) {
        Object array = null;
        Class<?> innerClass = toClass.getWrapperClass().getComponentType();
        if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class)) {
            array = Array.newInstance(innerClass, ((Collection)from).size());
            int i = 0;
            for (Object node : (Collection)from) {
                Array.set(array, i++, ObjectUtil.to(node, new TypeReference<Object>(innerClass){}));
            }
        } else if (from.getClass().isArray()) {
            int length = Array.getLength(from);
            array = Array.newInstance(innerClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ObjectUtil.to(Array.get(from, i), new TypeReference<Object>(innerClass){}));
            }
        } else if (from instanceof String) {
            try {
                JSONArray jsonArray = JSON.parseArray((String)((String)from));
                return ObjectUtil.to((Object)jsonArray, toClass);
            }
            catch (Exception e) {
                String[] strings = ((String)from).split(",");
                return ObjectUtil.toArray(strings, toClass);
            }
        }
        return (T)array;
    }

    private static <T> T toMap(Object from, TypeReference<T> toClass) {
        if (toClass.isExtendsFrom(Map.class)) {
            if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class) || from.getClass().isArray()) {
                return null;
            }
            Map map = MapUtil.parse(from);
            return (T)MapUtil.toMap(map, toClass);
        }
        return null;
    }

    private static <T> T toCollection(Object from, TypeReference<T> toClass) {
        if (toClass.isExtendsFrom(Collection.class)) {
            if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class) || from.getClass().isArray()) {
                Object nodeType = toClass.getParameterizedType(0);
                if (nodeType == null) {
                    nodeType = Object.class;
                }
                AbstractCollection collection = toClass.getWrapperClass().isInterface() ? (toClass.isExtendsFrom(Queue.class) ? new ArrayDeque() : (toClass.isExtendsFrom(Set.class) ? new HashSet() : new ArrayList())) : (ArrayDeque)ClassUtil.newInstance(toClass.getWrapperClass());
                if (collection != null) {
                    if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class)) {
                        for (Object o : (Collection)from) {
                            collection.add(ObjectUtil.to(o, new TypeReference((Type)nodeType)));
                        }
                    } else if (from.getClass().isArray()) {
                        for (Object o : (Object[])from) {
                            collection.add(ObjectUtil.to(o, new TypeReference((Type)nodeType)));
                        }
                    }
                }
                return (T)collection;
            }
            if (from instanceof String) {
                try {
                    JSONArray array = JSON.parseArray((String)((String)from));
                    return ObjectUtil.to((Object)array, toClass);
                }
                catch (Exception e) {
                    String[] strings = ((String)from).split(",");
                    return ObjectUtil.toCollection(strings, toClass);
                }
            }
        }
        return null;
    }

    private static <T> T toPOJO(Object from, Class<? extends T> toClass, boolean alias) {
        if (from == null) {
            return null;
        }
        Class<?> sourceClass = from.getClass();
        if (toClass.isAssignableFrom(sourceClass)) {
            return (T)from;
        }
        if (Map.class.isAssignableFrom(sourceClass)) {
            Map map = (Map)from;
            Object object = ClassUtil.newInstance(toClass);
            if (object != null) {
                ClassUtil.getAllField(toClass).parallelStream().forEach(field -> {
                    String key = StringUtil.vagueMatches(field.getName(), map.keySet());
                    if (key != null) {
                        try {
                            Object value = map.get(key);
                            ObjectUtil.setValue(object, field, value);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                });
                if (ObjectUtil.isChange(object)) {
                    return object;
                }
            }
        } else if (from instanceof String) {
            try {
                Object json = JSON.parse((String)((String)from));
                if (json instanceof JSON) {
                    return ObjectUtil.toPOJO(json, toClass, alias);
                }
            }
            catch (Exception json) {}
        } else {
            if (sourceClass.isPrimitive() || Iterable.class.isAssignableFrom(sourceClass)) {
                return null;
            }
            T object = ClassUtil.newInstance(toClass);
            ObjectUtil.copyProperties(from, object, alias);
            if (ObjectUtil.isChange(object)) {
                return object;
            }
        }
        return null;
    }

    private static <T> T to(Object from, Class<T> toClass) {
        if (from == null) {
            return null;
        }
        Object temp = null;
        if (from.getClass().isArray() && Array.getLength(from) > 0) {
            from = Array.get(from, 0);
        }
        if (Collection.class.isAssignableFrom(from.getClass()) && !((Collection)from).isEmpty()) {
            from = ((Collection)from).iterator().next();
        }
        String valueStr = from.toString();
        if (NumberUtil.isNumber(toClass)) {
            Number number = NumberUtils.createNumber((String)valueStr);
            if (toClass == Short.class || toClass == Short.TYPE) {
                temp = number.shortValue();
            } else if (toClass == Integer.class || toClass == Integer.TYPE) {
                temp = number.intValue();
            } else if (toClass == Long.class || toClass == Long.TYPE) {
                temp = number.longValue();
            } else if (toClass == Float.class || toClass == Float.TYPE) {
                temp = Float.valueOf(number.floatValue());
            } else if (toClass == Double.class || toClass == Double.TYPE) {
                temp = number.doubleValue();
            } else if (toClass == Byte.class || toClass == Byte.TYPE) {
                temp = number.byteValue();
            }
        } else if (toClass == Boolean.class || toClass == Boolean.TYPE) {
            temp = NumberUtils.isParsable((String)valueStr) ? Boolean.valueOf(NumberUtils.createNumber((String)valueStr).intValue() > 0) : Boolean.valueOf(Boolean.parseBoolean(valueStr));
        } else if (toClass == Byte.class || toClass == Byte.TYPE) {
            temp = Byte.parseByte(valueStr);
        } else if (toClass == Character.class || toClass == Character.TYPE) {
            char[] array = valueStr.toCharArray();
            temp = array.length > 0 ? Character.valueOf(array[0]) : null;
        } else if (toClass == String.class) {
            temp = valueStr;
        }
        return (T)temp;
    }

    public static boolean isChange(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        try {
            Object newObject = clazz.newInstance();
            Set haveValueFields = ClassUtil.getAllField(clazz).parallelStream().filter(field -> {
                try {
                    if (SERIAL_VERSION_UID.equals(field.getName())) {
                        return false;
                    }
                    Object currentValue = field.get(object);
                    Object initValue = field.get(newObject);
                    return currentValue != null && !Objects.deepEquals(currentValue, initValue);
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return !haveValueFields.isEmpty();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return true;
        }
    }

    public static void setValue(Object object, Field field, Object value) {
        Class<?> objectClass = object.getClass();
        Class<?> typeTpye = field.getType();
        if (value != null) {
            FieldInfo fieldInfo = ClassInfo.getCache(objectClass).getFieldInfo(field);
            if (fieldInfo.isNoSetters() == null) {
                String fieldName = field.getName();
                String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Set<Method> allMethod = ClassUtil.getAllMethod(objectClass);
                List list = allMethod.stream().filter(method -> setMethodName.equals(method.getName()) && method.getParameterCount() == 1).sorted((a, b) -> {
                    int result = b.getName().compareTo(a.getName());
                    if (result == 0) {
                        int aI = typeTpye == a.getParameterTypes()[0] ? 1 : 0;
                        int bI = typeTpye == b.getParameterTypes()[0] ? 1 : 0;
                        result = bI - aI;
                    }
                    return result;
                }).map(method -> {
                    fieldInfo.putSetter((Method)method);
                    return method;
                }).collect(Collectors.toList());
                fieldInfo.setNoSetters(list.isEmpty());
            }
            if (Boolean.FALSE.equals(fieldInfo.isNoSetters())) {
                List<Method> setters = fieldInfo.setters();
                Object initValue = null;
                try {
                    initValue = field.get(object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (Method setter : setters) {
                    try {
                        ObjectUtil.invokeMethodIfParamNotNull(object, setter, value);
                        Object newValue = field.get(object);
                        if (newValue == null || newValue.equals(initValue)) continue;
                        fieldInfo.putSetter(setter);
                        return;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            try {
                ObjectUtil.setValueIfNotNull(object, field, value);
            }
            catch (Exception exception) {}
        } else if (!typeTpye.isPrimitive()) {
            try {
                field.set(object, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void invokeMethodIfParamNotNull(Object object, Method method, Object value) throws InvocationTargetException, IllegalAccessException {
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (parameterTypes.length == 1) {
            Object v = ObjectUtil.to(value, new TypeReference(parameterTypes[0]));
            if (value != null && v == null) {
                throw new RuntimeException();
            }
            method.invoke(object, v);
        }
    }

    public static void setValueIfNotNull(Object object, Field field, Object value) throws IllegalAccessException {
        Object v = ObjectUtil.to(value, new TypeReference(field.getGenericType()));
        if (value != null && v == null) {
            throw new RuntimeException();
        }
        field.set(object, v);
    }

    public static void copyProperties(Object source, Object target, Compare compare) {
        ObjectUtil.copyProperties(source, target, "", "", new String[0], ContainOrExclude.EXCLUDE, compare, false);
    }

    private static Map<Field, Set<Field>> getSameField(Object source, Object target, String prefix, String suffix, Compare compare, boolean isAlias) {
        Map<Object, Object> result = Maps.newConcurrentMap();
        if (ObjectUtils.isEmpty((Object)source) || ObjectUtils.isEmpty((Object)target)) {
            return result;
        }
        result = isAlias ? ObjectUtil.getSameFieldByAlias(source.getClass(), target.getClass(), prefix, suffix) : ObjectUtil.getSameFieldByBlurry(source.getClass(), target.getClass(), prefix, suffix);
        if (result.isEmpty()) {
            return result;
        }
        ObjectUtil.parseCompare(source, target, compare, result);
        return result;
    }

    private static void parseCompare(Object source, Object target, Compare compare, Map<Field, Set<Field>> result) {
        Object targetNew = null;
        try {
            targetNew = target.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object finalTargetNew = targetNew;
        Iterator<Map.Entry<Field, Set<Field>>> resultIt = result.entrySet().iterator();
        while (resultIt.hasNext()) {
            Map.Entry<Field, Set<Field>> e = resultIt.next();
            Field fromField = e.getKey();
            Set<Field> toFields = e.getValue();
            boolean is = false;
            block14: for (Field toField : toFields) {
                Object sourceValue = ObjectUtil.getFieldValue(source, fromField);
                Object targetValue = ObjectUtil.getFieldValue(target, toField);
                switch (compare) {
                    case DIFF_ALL_NOT_NULL: {
                        if (sourceValue == null || targetValue == null || ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case DIFF_TARGET_NULL: {
                        if (sourceValue == null || targetValue != null) break;
                        continue block14;
                    }
                    case DIFF_SOURCE_NULL: {
                        if (sourceValue != null || targetValue == null) break;
                        continue block14;
                    }
                    case DIFF_SOURCE_NOT_NULL: {
                        if (sourceValue == null || ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case DIFF_TARGET_NOT_NULL: {
                        if (targetValue == null || ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case DIFF_SOURCE_NOT_NULL_AND_TARGET_DEFAULT: {
                        if (finalTargetNew == null) {
                            throw new RuntimeException(String.format("\u76ee\u6807\u5bf9\u8c61\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7c7b\u201c%s\u201d\u662f\u5426\u5305\u542b\u7a7a\u53c2\u6784\u9020\u51fd\u6570", target.getClass()));
                        }
                        if (sourceValue == null || ObjectUtil.equals(sourceValue, targetValue) || !ObjectUtil.equals(ObjectUtil.getFieldValue(finalTargetNew, toField), targetValue)) break;
                        continue block14;
                    }
                    case DIFF_TARGET_DEFAULT: {
                        if (finalTargetNew == null) {
                            throw new RuntimeException(String.format("\u76ee\u6807\u5bf9\u8c61\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7c7b\u201c%s\u201d\u662f\u5426\u5305\u542b\u7a7a\u53c2\u6784\u9020\u51fd\u6570", target.getClass()));
                        }
                        if (ObjectUtil.equals(sourceValue, targetValue) || !ObjectUtil.equals(ObjectUtil.getFieldValue(finalTargetNew, toField), targetValue)) break;
                        continue block14;
                    }
                    case DIFF: {
                        if (ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                    case SAME: {
                        if (!ObjectUtil.equals(sourceValue, targetValue)) break;
                        continue block14;
                    }
                }
                is = true;
            }
            if (!is) continue;
            resultIt.remove();
        }
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        return object1 != null && object1.equals(object2);
    }

    public static Map<Field, Set<Field>> getSameFieldByBlurry(Class<?> sourceClass, Class<?> targetClass) {
        return ObjectUtil.getSameFieldByBlurry(sourceClass, targetClass, "", "");
    }

    public static Map<Field, Set<Field>> getSameFieldByBlurry(Class<?> sourceClass, Class<?> targetClass, String prefix, String suffix) {
        String finalSuffix;
        ConcurrentMap result = Maps.newConcurrentMap();
        if (ObjectUtils.isEmpty(sourceClass) || ObjectUtils.isEmpty(targetClass)) {
            return result;
        }
        String finalPrefix = prefix == null ? "" : prefix;
        String string = finalSuffix = suffix == null ? "" : suffix;
        if (sourceClass == targetClass) {
            ClassUtil.getAllField(sourceClass).parallelStream().filter(field -> field.getName().startsWith(finalPrefix) && field.getName().endsWith(finalPrefix)).forEach(field -> {
                Set cfr_ignored_0 = result.put(field, Sets.newHashSet((Object[])new Field[]{field}));
            });
        } else {
            ClassUtil.getAllField(targetClass).parallelStream().forEach(toField -> {
                String name = toField.getName();
                Field fromField = ClassUtil.getField(sourceClass, name);
                if (fromField != null && fromField.getName().startsWith(finalPrefix) && fromField.getName().endsWith(finalSuffix)) {
                    Set set = (Set)result.get(fromField);
                    if (set == null) {
                        set = Sets.newHashSet();
                    }
                    set.add(toField);
                    result.put(fromField, set);
                }
            });
        }
        return result;
    }

    public static Map<Field, Set<Field>> getSameFieldByAlias(Class<?> sourceClass, Class<?> targetClass) {
        return ObjectUtil.getSameFieldByAlias(sourceClass, targetClass, "", "");
    }

    public static Map<Field, Set<Field>> getSameFieldByAlias(Class<?> sourceClass, Class<?> targetClass, String prefix, String suffix) {
        ConcurrentMap map = Maps.newConcurrentMap();
        if (ObjectUtils.isEmpty(sourceClass) || ObjectUtils.isEmpty(targetClass)) {
            return map;
        }
        String finalPrefix = prefix == null ? "" : prefix;
        String finalSuffix = suffix == null ? "" : suffix;
        Map<Field, Set<String>> sourceMap = ObjectUtil.parseFieldAlias(sourceClass);
        Map<Field, Set<String>> targetMap = ObjectUtil.parseFieldAlias(targetClass);
        sourceMap.entrySet().parallelStream().filter(e -> {
            String name = ((Field)e.getKey()).getName();
            return name.startsWith(finalPrefix) && name.endsWith(finalSuffix);
        }).forEach(e -> {
            Set sourceAlias = (Set)e.getValue();
            Set set = targetMap.entrySet().stream().filter(te -> !CollectionUtils.retainAll((Collection)((Collection)te.getValue()), (Collection)sourceAlias).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
            map.put(e.getKey(), set);
        });
        return map;
    }

    public static Map<Field, Set<String>> parseFieldAlias(Class<?> sourceClass) {
        ConcurrentMap sourceMap = Maps.newConcurrentMap();
        Set<ClassUtil.Target<Alias>> sourceAnnotations = ClassUtil.getAllEntityAnnotation(sourceClass, Alias.class);
        ClassUtil.getAllField(sourceClass).forEach(field -> {
            HashSet aliases;
            ClassUtil.Target an = sourceAnnotations.stream().filter(sourceAnnotation -> sourceAnnotation.getMember() == field).findFirst().orElse(null);
            if (an != null) {
                aliases = Sets.newHashSet((Object[])((Alias)an.getAnnotation()).value());
                aliases.add(field.getName());
            } else {
                aliases = Sets.newHashSet((Object[])new String[]{field.getName()});
            }
            sourceMap.put(field, aliases);
        });
        return sourceMap;
    }

    public static void copyProperties(Object source, Object target, String[] arguments, ContainOrExclude containOrExclude) {
        ObjectUtil.copyProperties(source, target, "", "", arguments, containOrExclude, Compare.DIFF, false);
    }

    public static void copyProperties(Object source, Object target, String prefix, String suffix) {
        ObjectUtil.copyProperties(source, target, prefix, suffix, new String[0], ContainOrExclude.EXCLUDE, Compare.DIFF, false);
    }

    public static void copyProperties(Object source, Object target) {
        ObjectUtil.copyProperties(source, target, "", "", new String[0], ContainOrExclude.EXCLUDE, Compare.DIFF, false);
    }

    public static void copyProperties(Object source, Object target, boolean alias) {
        ObjectUtil.copyProperties(source, target, "", "", new String[0], ContainOrExclude.EXCLUDE, Compare.DIFF, alias);
    }

    public static void copyProperties(Object source, Object target, String prefix, String suffix, String[] arguments, ContainOrExclude containOrExclude, Compare compare, boolean isAlias) {
        if (ObjectUtils.isEmpty((Object)source) || ObjectUtils.isEmpty((Object)target)) {
            return;
        }
        Map<Field, Set<Field>> argumentsMap = ObjectUtil.getSameField(source, target, prefix, suffix, compare, isAlias);
        argumentsMap.entrySet().parallelStream().forEach(e -> {
            try {
                Field fromField = (Field)e.getKey();
                switch (containOrExclude) {
                    case EXCLUDE: {
                        if (!ArrayUtils.contains((Object[])arguments, (Object)fromField.getName())) break;
                        return;
                    }
                    case INCLUDE: {
                        if (ArrayUtils.contains((Object[])arguments, (Object)fromField.getName())) break;
                        return;
                    }
                }
                Object value = fromField.get(source);
                Set toFields = (Set)e.getValue();
                for (Field toField : toFields) {
                    Type type = toField.getGenericType();
                    TypeReference typeReference = new TypeReference(type);
                    if (value != null) {
                        value = ObjectUtil.to(value, typeReference);
                    }
                    ObjectUtil.setValue(target, toField, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static Object getFieldValue(Object o, String fieldName) {
        Field field = ClassUtil.getField(o.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        return ObjectUtil.getFieldValue(o, field);
    }

    public static Object getFieldValue(Object o, Field field) {
        if (field == null) {
            return null;
        }
        FieldInfo fieldInfo = ClassInfo.getCache(o.getClass()).getFieldInfo(field);
        if (fieldInfo.isNoGetters() == null) {
            List methods;
            String fieldName = field.getName();
            String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            if (field.getType() == Boolean.TYPE) {
                String getMethodName2 = "is" + StringUtil.toUpperName(field.getName());
                methods = ClassInfo.getCache(o.getClass()).getAllMethod().stream().filter(method -> (method.getName().equals(getMethodName) || method.getName().equals(getMethodName2)) && method.getParameterCount() == 0).map(method -> {
                    fieldInfo.putGetter((Method)method);
                    return method;
                }).collect(Collectors.toList());
            } else {
                methods = ClassInfo.getCache(o.getClass()).getAllMethod().stream().filter(method -> method.getName().equals(getMethodName) && method.getParameterCount() == 0).map(method -> {
                    fieldInfo.putGetter((Method)method);
                    return method;
                }).collect(Collectors.toList());
            }
            if (!methods.isEmpty()) {
                for (Method method2 : methods) {
                    try {
                        Object v = method2.invoke(o, new Object[0]);
                        fieldInfo.putGetter(method2);
                        return v;
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                fieldInfo.setNoGetters(true);
            }
        }
        if (Boolean.FALSE.equals(fieldInfo.isNoGetters())) {
            List<Method> getters = fieldInfo.getters();
            for (Method getter : getters) {
                try {
                    Object v = getter.invoke(o, new Object[0]);
                    fieldInfo.putGetter(getter);
                    return v;
                }
                catch (Exception exception) {
                }
            }
        }
        try {
            return field.get(o);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<?, ?> map) {
        return ObjectUtil.getObjectFromMap(clazz, map, "", "");
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<String, Object> map, String prefix) {
        return ObjectUtil.getObjectFromMap(clazz, map, prefix, "");
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<?, ?> map, String prefix, String suffix) {
        if (Map.class.isAssignableFrom(clazz)) {
            return (T)map;
        }
        if (!ObjectUtils.isEmpty(map)) {
            try {
                Object object = clazz.newInstance();
                Set<Field> fields = ClassUtil.getAllField(clazz);
                fields.parallelStream().forEach(field -> {
                    String key = ObjectUtil.coverFieldNameToMapKey(clazz, field, prefix, suffix, map);
                    if (key != null) {
                        try {
                            Object value = map.get(key);
                            ObjectUtil.setValue(object, field, value);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                });
                if (!ObjectUtil.isAllNullValidity(object)) {
                    return object;
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String coverFieldNameToMapKey(Class<?> clazz, Field field, String prefix, String suffix, Map<?, ?> map) {
        String key;
        block15: {
            key = null;
            try {
                Alias column = ObjectUtil.getAllEntityPropertyAnnotation(clazz, field, Alias.class);
                if (column == null) break block15;
                for (String alias : column.value()) {
                    if (!map.containsKey(alias)) continue;
                    key = alias;
                    break;
                }
            }
            catch (Exception column) {
                // empty catch block
            }
        }
        if (key != null) {
            return key;
        }
        String propertyName = prefix + field.getName() + suffix;
        String propertyRegex = StringUtil.camelToMatchesRegex(propertyName);
        HashSet<String> keys = new HashSet<String>();
        for (Object mapKey : map.keySet()) {
            if (!PatternUtil.matches(propertyRegex, mapKey.toString(), 2)) continue;
            keys.add(mapKey.toString());
        }
        if (keys.size() > 1) {
            if (keys.contains(propertyName)) {
                key = propertyName;
            } else {
                String camelToUnderlineKey = StringUtil.toUnderline(propertyName);
                String camelToUnderlineKeyUpper = camelToUnderlineKey.toUpperCase();
                String camelToUnderlineKeyLower = camelToUnderlineKey.toLowerCase();
                if (keys.contains(camelToUnderlineKey)) {
                    key = camelToUnderlineKey;
                } else if (keys.contains(camelToUnderlineKeyUpper)) {
                    key = camelToUnderlineKeyUpper;
                } else if (keys.contains(camelToUnderlineKeyLower)) {
                    key = camelToUnderlineKeyLower;
                }
            }
        } else if (keys.size() == 1) {
            key = (String)keys.iterator().next();
        }
        return key;
    }

    public static <T extends Annotation> T getAllEntityPropertyAnnotation(Class<?> clazz, Field field, Class<T> annotation) throws NoSuchMethodException {
        Method method;
        T methodAnnotations;
        String getMethodName;
        Method declaredMethod;
        T methodDeclaredAnnotations;
        T fieldAnnotations;
        T result = null;
        T fieldDeclaredAnnotations = field.getDeclaredAnnotation(annotation);
        if (fieldDeclaredAnnotations != null) {
            result = fieldDeclaredAnnotations;
        }
        if ((fieldAnnotations = field.getAnnotation(annotation)) != null) {
            result = fieldAnnotations;
        }
        if ((methodDeclaredAnnotations = (declaredMethod = clazz.getDeclaredMethod(getMethodName = String.format("get%s", StringUtil.toUpperName(field.getName())), new Class[0])).getDeclaredAnnotation(annotation)) != null) {
            result = methodDeclaredAnnotations;
        }
        if ((methodAnnotations = (method = clazz.getMethod(getMethodName, new Class[0])).getAnnotation(annotation)) != null) {
            result = methodAnnotations;
        }
        return result;
    }

    public static boolean isAllNullValidity(Object object) {
        Class<?> clazz = object.getClass();
        try {
            Object newObject = clazz.newInstance();
            Set haveValueFields = ClassUtil.getAllField(clazz).parallelStream().filter(field -> {
                try {
                    if (SERIAL_VERSION_UID.equals(field.getName())) {
                        return false;
                    }
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    Object currentValue = field.get(object);
                    Object initValue = field.get(newObject);
                    return currentValue != null && currentValue != initValue;
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return haveValueFields.isEmpty();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return false;
        }
    }

    public static void setAllFieldNull(Object object) {
        if (object == null) {
            return;
        }
        ClassUtil.getAllField(object.getClass()).parallelStream().forEach(field -> {
            try {
                if (SERIAL_VERSION_UID.equals(field.getName())) {
                    return;
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(object, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static String objectToString(Object o, String ... exclude) {
        Class<?> clazz = o.getClass();
        StringBuilder target = new StringBuilder(clazz.getSimpleName()).append("{");
        Set<Field> fields = ClassUtil.getAllField(clazz);
        int i = 0;
        for (Field field : fields) {
            try {
                if (ArrayUtils.contains((Object[])exclude, (Object)field.getName())) {
                    ++i;
                    continue;
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if (i != 0) {
                    target.append(", ");
                }
                target.append(field.getName()).append("='").append(field.get(o));
                if (i == fields.size() - 1) {
                    target.append('}');
                } else {
                    target.append('\'');
                }
            }
            catch (IllegalAccessException e) {
                continue;
            }
            ++i;
        }
        return target.toString();
    }

    public static Map<String, Object> getUnderlineMapFromObject(Object o) {
        Set<Field> fields = ClassUtil.getAllField(o.getClass());
        HashMap<String, Object> result = new HashMap<String, Object>(fields.size());
        if (!fields.isEmpty()) {
            fields.forEach(field -> {
                String key = StringUtil.toUnderline(field.getName());
                try {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    result.put(key, field.get(o));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            });
        }
        return result;
    }

    public static List<Map<String, Object>> getUnderlineMapFromListObject(Iterable<Object> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (list != null) {
            for (Object o : list) {
                result.add(ObjectUtil.getUnderlineMapFromObject(o));
            }
        }
        return result;
    }

    public static boolean compare(Object source, Object target) {
        return ObjectUtil.isEmpty((Object)source) && ObjectUtil.isEmpty((Object)target) || source.equals(target);
    }

    public static List<Different> getDifferenceProperties(Object source, Object target, String ... excludeProperty) throws IllegalAccessException {
        ArrayList<Different> result = new ArrayList<Different>();
        if ((ClassUtil.compareClass(source, target) == false || ObjectUtil.compare(source, target) || ObjectUtil.isEmpty((Object)source)) != ObjectUtil.isEmpty((Object)target)) {
            return result;
        }
        Object sourceObject = ObjectUtil.isEmpty((Object)source) ? target : source;
        Object targetObject = ObjectUtil.isEmpty((Object)source) ? source : target;
        Class<?> sourceClass = sourceObject.getClass();
        ClassUtil.getAllField(sourceClass).parallelStream().forEach(field -> {
            Object targetValue;
            Object sourceValue;
            if (excludeProperty != null && ArrayUtils.contains((Object[])excludeProperty, (Object)field.getName())) {
                return;
            }
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                sourceValue = field.get(sourceObject);
                targetValue = field.get(targetObject);
            }
            catch (IllegalAccessException e) {
                return;
            }
            if (ObjectUtil.compare(sourceValue, targetValue)) {
                return;
            }
            result.add(new Different(field.getName(), field.getType().getTypeName(), String.valueOf(targetValue), String.valueOf(sourceValue)));
        });
        return result;
    }

    public static boolean compareValue(Object source, Object target, String ... excludeProperty) {
        if (ObjectUtil.isEmpty((Object)source)) {
            return ObjectUtil.isEmpty((Object)target);
        }
        if (ObjectUtil.isEmpty((Object)target)) {
            return false;
        }
        try {
            List<Different> list = ObjectUtil.getDifferenceProperties(source, target, excludeProperty);
            if (!ObjectUtils.isEmpty(list)) {
                return false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return true;
    }

    public static boolean compareOfNotNull(Object source, Object target) {
        Field[] fields;
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            if (SERIAL_VERSION_UID.equals(field.getName())) continue;
            try {
                Object targetValue;
                Object sourceValue;
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((sourceValue = field.get(source)) == null || sourceValue.equals(targetValue = field.get(target))) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static class Different {
        private final String propertyName;
        private final String propertyType;
        private final String newValue;
        private final String oldValue;

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyType() {
            return this.propertyType;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Different)) {
                return false;
            }
            Different other = (Different)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            String this$propertyType = this.getPropertyType();
            String other$propertyType = other.getPropertyType();
            if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
                return false;
            }
            String this$newValue = this.getNewValue();
            String other$newValue = other.getNewValue();
            if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
                return false;
            }
            String this$oldValue = this.getOldValue();
            String other$oldValue = other.getOldValue();
            return !(this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Different;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            String $propertyType = this.getPropertyType();
            result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
            String $newValue = this.getNewValue();
            result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
            String $oldValue = this.getOldValue();
            result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
            return result;
        }

        public String toString() {
            return "ObjectUtil.Different(propertyName=" + this.getPropertyName() + ", propertyType=" + this.getPropertyType() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ")";
        }

        public Different(String propertyName, String propertyType, String newValue, String oldValue) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }
    }

    public static enum ContainOrExclude {
        INCLUDE,
        EXCLUDE;

    }

    public static enum Compare {
        SAME,
        DIFF,
        DIFF_ALL_NOT_NULL,
        DIFF_SOURCE_NULL,
        DIFF_TARGET_NULL,
        DIFF_TARGET_DEFAULT,
        DIFF_SOURCE_NOT_NULL_AND_TARGET_DEFAULT,
        DIFF_SOURCE_NOT_NULL,
        DIFF_TARGET_NOT_NULL;

    }
}

