/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.map;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;

public class MapUtil {
    public static Map<String, Object> keyFilter(Map<String, Object> sourceMap, String prefix, String suffix) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)sourceMap.size());
        if (prefix == null && suffix == null) {
            result.putAll(sourceMap);
            return result;
        }
        MapUtil.getEntryStream(sourceMap, prefix, suffix).forEach(e -> result.put(e.getKey(), e.getValue()));
        return result;
    }

    public static Map<String, Object> keyFilterAndCut(Map<String, Object> sourceMap, String prefix, String suffix) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)sourceMap.size());
        if (prefix == null && suffix == null) {
            result.putAll(sourceMap);
            return result;
        }
        MapUtil.getEntryStream(sourceMap, prefix, suffix).forEach(e -> {
            String key = (String)e.getKey();
            Object value = e.getValue();
            int start = prefix != null ? prefix.length() : 0;
            int end = suffix != null ? key.lastIndexOf(suffix) : key.length();
            result.put(key.substring(start, end), value);
        });
        return result;
    }

    public static Stream<Map.Entry<String, Object>> getEntryStream(Map<String, Object> sourceMap, String prefix, String suffix) {
        return sourceMap.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            if (prefix != null && suffix != null) {
                return key.startsWith(prefix) && key.endsWith(suffix);
            }
            if (prefix != null) {
                return key.startsWith(prefix);
            }
            return key.endsWith(suffix);
        });
    }

    public static <T> T to(Map<String, Object> from, TypeReference<? extends T> clazz) {
        return MapUtil.to(from, clazz, null, null);
    }

    public static <T> T to(Map<String, Object> from, TypeReference<? extends T> toClass, String prefix) {
        return MapUtil.to(from, toClass, prefix, null);
    }

    public static <T> T to(Map<String, Object> from, TypeReference<? extends T> toClass, String prefix, String suffix) {
        return ObjectUtil.to(MapUtil.keyFilterAndCut(from, prefix, suffix), toClass);
    }

    public static <K, V, K1, V1> Map<K, V> toMap(Map<K1, V1> from, TypeReference<Map<K, V>> toClass) {
        Class wrapperClass;
        if (!toClass.hasParameterizedType()) {
            toClass.addParameterizedType((Type)((Object)String.class));
            toClass.addParameterizedType((Type)((Object)Object.class));
        }
        Map result = (wrapperClass = toClass.getWrapperClass()).isInterface() ? (toClass.isExtendsFrom(Dictionary.class) ? new Hashtable() : (toClass.isExtendsFrom(ConcurrentMap.class) ? Maps.newConcurrentMap() : Maps.newHashMapWithExpectedSize((int)from.size()))) : (Hashtable)ClassUtil.newInstance(wrapperClass);
        if (result != null) {
            Type keyClass = toClass.getParameterizedType(0);
            Type valueClass = toClass.getParameterizedType(1);
            for (Map.Entry<K1, V1> entry : from.entrySet()) {
                Object key = ObjectUtil.to(entry.getKey(), new TypeReference<K>(keyClass){});
                Object value = ObjectUtil.to(entry.getValue(), new TypeReference<V>(valueClass){});
                result.put(key, value);
            }
        }
        return result;
    }

    public static Map parse(Object object) {
        if (ClassUtil.isExtendsFrom(object.getClass(), Map.class)) {
            return (Map)object;
        }
        if (object instanceof String) {
            try {
                return JSON.parseObject((String)((String)object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Set<Field> fields = ClassUtil.getAllField(object.getClass());
        HashMap map = Maps.newHashMapWithExpectedSize((int)fields.size());
        fields.forEach(field -> {
            try {
                field.setAccessible(true);
                Object value = field.get(object);
                map.put(field.getName(), value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return map;
    }

    public static Map<String, Object> addPrefix(Map<String, Object> from, String prefix) {
        HashMap toMap = Maps.newHashMapWithExpectedSize((int)from.size());
        from.forEach((key, value) -> toMap.put(prefix + key, value));
        return toMap;
    }

    public static String toUrl(Map<String, Object> map) {
        StringBuilder mapOfString = new StringBuilder("");
        for (Map.Entry<String, Object> entity : map.entrySet()) {
            Object value = entity.getValue();
            if (value.getClass().isArray()) {
                for (Object v : (Object[])value) {
                    mapOfString.append("&").append(entity.getKey());
                    mapOfString.append("=").append(v);
                }
                continue;
            }
            mapOfString.append("&").append(entity.getKey());
            mapOfString.append("=").append(entity.getValue());
        }
        String urlParam = mapOfString.toString();
        return urlParam.startsWith("&") ? urlParam.substring(1) : urlParam;
    }

    public static Map<String, Object> sortByKey(Map<String, Object> map) {
        return MapUtil.sort(map, KeyOrValue.KEY);
    }

    public static Map<String, Object> sortByValue(Map<String, Object> map) {
        return MapUtil.sort(map, KeyOrValue.VALUE);
    }

    private static Map<String, Object> sort(Map<String, Object> map, KeyOrValue keyOrValue) {
        LinkedList<Map.Entry<String, Object>> list = new LinkedList<Map.Entry<String, Object>>(map.entrySet());
        switch (keyOrValue) {
            case KEY: {
                list.sort(Map.Entry.comparingByKey());
                break;
            }
            case VALUE: {
                list.sort(Comparator.comparing(o -> String.valueOf(o.getValue())));
                break;
            }
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : list) {
            linkedHashMap.put((String)entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    public static void main(String[] args) {
        HashMap result = Maps.newHashMap();
        result.put("myname", "1");
        result.put("mycode", "2");
        result.put("mytudou", "3");
        MapUtil.keyFilter(result, "my", "e");
        MapUtil.keyFilterAndCut(result, "my", "e");
        MapUtil.toMap(result, new TypeReference<Map<StringBuilder, Integer>>(){});
    }

    public static enum KeyOrValue {
        KEY,
        VALUE;

    }
}

