/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file.poi;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.CollectionsUtil;
import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.common.util.file.poi.Cell;
import cloud.agileframework.common.util.file.poi.SheetData;
import cloud.agileframework.common.util.object.ObjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIUtil {
    private static final String SORT_FIELD_NAME = "sort";

    public static Workbook creatExcel(VERSION version, SheetData ... sheetData) {
        HSSFWorkbook excel = null;
        switch (version) {
            case V2003: {
                excel = new HSSFWorkbook();
                break;
            }
            case V2007: {
                excel = new XSSFWorkbook();
                break;
            }
            case V2008: {
                excel = new SXSSFWorkbook();
                break;
            }
        }
        for (int i = 0; i < sheetData.length; ++i) {
            POIUtil.creatSheet((Workbook)excel, sheetData[i]);
        }
        return excel;
    }

    private static void creatSheet(Workbook excel, SheetData sheetData) {
        Sheet sheet = excel.createSheet(sheetData.getName());
        int currentRowIndex = 0;
        List<Cell> headerColumns = sheetData.getCells();
        List data = sheetData.getData();
        if (!CollectionUtils.isEmpty(headerColumns)) {
            CollectionsUtil.sort(headerColumns, SORT_FIELD_NAME);
            POIUtil.createRow(sheet, headerColumns, currentRowIndex++, headerColumns);
            if (data == null) {
                return;
            }
            for (Object datum : data) {
                POIUtil.createRow(sheet, datum, currentRowIndex++, headerColumns);
            }
        } else {
            if (data == null) {
                return;
            }
            for (Object datum : data) {
                POIUtil.createRow(sheet, datum, currentRowIndex++);
            }
        }
    }

    private static void createRow(Sheet sheet, Object rowData, int rowIndex) {
        Row row = sheet.createRow(rowIndex);
        int currentColumnIndex = 0;
        if (rowData == null) {
            return;
        }
        if (rowData instanceof Map) {
            for (Object cell : ((Map)rowData).values()) {
                row.createCell(currentColumnIndex++).setCellValue(ObjectUtil.to(cell, new TypeReference<String>(){}));
            }
        } else {
            Field[] fields;
            for (Field field : fields = rowData.getClass().getDeclaredFields()) {
                String currentCellData;
                field.setAccessible(true);
                try {
                    currentCellData = ObjectUtil.to(field.get(rowData), new TypeReference<String>(){});
                }
                catch (Exception e) {
                    currentCellData = null;
                }
                row.createCell(currentColumnIndex++).setCellValue(currentCellData);
            }
        }
    }

    private static void createRow(Sheet sheet, Object rowData, int rowIndex, List<Cell> headerColumns) {
        Row row = sheet.createRow(rowIndex);
        int currentColumnIndex = 0;
        for (Cell cell : headerColumns) {
            String currentCellData = null;
            if (rowData instanceof Map) {
                currentCellData = ObjectUtil.to(((Map)rowData).get(cell.getKey()), new TypeReference<String>(){});
            } else if (rowData instanceof List) {
                Object o = ((List)rowData).get(currentColumnIndex);
                if (o instanceof Cell) {
                    currentCellData = ((Cell)o).getShowName();
                } else if (o instanceof String) {
                    currentCellData = (String)o;
                }
            } else if (rowData != null) {
                try {
                    Field field = rowData.getClass().getDeclaredField(cell.getKey());
                    field.setAccessible(true);
                    currentCellData = ObjectUtil.to(field.get(rowData), new TypeReference<String>(){});
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    currentCellData = null;
                }
            }
            row.createCell(currentColumnIndex++).setCellValue(currentCellData);
        }
    }

    public static <T> List<T> readExcel(File file, Class<T> clazz, String[] columns) {
        try {
            Workbook excel = POIUtil.parsing(file);
            ArrayList list = new ArrayList();
            Iterator sheets = excel.sheetIterator();
            while (sheets.hasNext()) {
                POIUtil.readSheet(list, clazz, columns, (Sheet)sheets.next());
            }
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<LinkedHashMap<String, Object>> readExcel(File file) {
        return POIUtil.readExcel(file, null);
    }

    public static List<LinkedHashMap<String, Object>> readExcel(Object file, String[] columns) {
        try {
            Workbook excel = POIUtil.parsing(file);
            ArrayList<LinkedHashMap<String, Object>> list = new ArrayList<LinkedHashMap<String, Object>>();
            Iterator sheets = excel.sheetIterator();
            while (sheets.hasNext()) {
                POIUtil.readSheet(list, columns, (Sheet)sheets.next());
            }
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void readSheet(List<LinkedHashMap<String, Object>> list, String[] columns, Sheet sheet) {
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            int currentCellIndex = 0;
            LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
            Iterator cells = ((Row)rows.next()).cellIterator();
            while (cells.hasNext()) {
                if (columns != null) {
                    rowData.put(columns[currentCellIndex++], POIUtil.getValue((org.apache.poi.ss.usermodel.Cell)cells.next()));
                    continue;
                }
                rowData.put(String.valueOf(currentCellIndex++), POIUtil.getValue((org.apache.poi.ss.usermodel.Cell)cells.next()));
            }
            list.add(rowData);
        }
    }

    private static Object getValue(org.apache.poi.ss.usermodel.Cell cell) {
        Object value;
        try {
            value = cell.getStringCellValue();
        }
        catch (Exception e) {
            try {
                value = cell.getBooleanCellValue();
            }
            catch (Exception e1) {
                try {
                    value = cell.getNumericCellValue();
                }
                catch (Exception e2) {
                    try {
                        value = cell.getDateCellValue();
                    }
                    catch (Exception e3) {
                        try {
                            value = cell.getErrorCellValue();
                        }
                        catch (Exception e4) {
                            return null;
                        }
                    }
                }
            }
        }
        return value;
    }

    private static <T> void readSheet(List<T> list, Class<T> clazz, String[] columns, Sheet sheet) {
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            T rowData;
            int currentCellIndex = 0;
            try {
                rowData = clazz.newInstance();
            }
            catch (Exception e) {
                return;
            }
            for (String column : columns) {
                try {
                    Field field = rowData.getClass().getDeclaredField(column);
                    field.setAccessible(true);
                    Class<?> type = field.getType();
                    Object value = null;
                    if (type == String.class) {
                        value = ((Row)rows.next()).getCell(currentCellIndex++).getStringCellValue();
                    } else if (type == Date.class) {
                        value = ((Row)rows.next()).getCell(currentCellIndex++).getDateCellValue();
                    } else if (type == Boolean.TYPE) {
                        value = ((Row)rows.next()).getCell(currentCellIndex++).getBooleanCellValue();
                    } else if (type == Double.TYPE) {
                        value = ((Row)rows.next()).getCell(currentCellIndex++).getNumericCellValue();
                    }
                    field.set(rowData, value);
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    // empty catch block
                }
            }
            list.add(rowData);
        }
    }

    private static Workbook parsing(Object file) {
        Object result = null;
        if (file instanceof File) {
            String[] s = ((File)file).getName().split("[.]");
            String suffix = s.length > 1 ? s[s.length - 1] : Objects.requireNonNull(FileUtil.getFormat((File)file)).toLowerCase();
            try {
                String xls = "xls";
                result = "xls".equals(suffix) ? new HSSFWorkbook((InputStream)new FileInputStream((File)file)) : new XSSFWorkbook((InputStream)new FileInputStream((File)file));
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result;
    }

    public static enum VERSION {
        V2003,
        V2007,
        V2008;

    }
}

