/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.file;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class JarUtil {
    private static final String CLASSES_DIR_SPLIT = "/";

    public static void parseConsumer(JarFile jar, String packagePath, Consumer<Set<String>> consumer) {
        consumer.accept(JarUtil.getFile(jar, packagePath));
    }

    public static <A> A parseFunction(JarFile jar, String packagePath, Function<Set<String>, A> function) {
        return function.apply(JarUtil.getFile(jar, packagePath));
    }

    public static Set<String> getFile(String packagePath) {
        return JarUtil.getFile(packagePath, true, new String[]{null});
    }

    public static Set<String> getFile(String packagePath, boolean isInclude, String ... suffixes) {
        HashSet set = Sets.newHashSet();
        try {
            Collections.list(JarUtil.class.getClassLoader().getResources(JarUtil.toEntryName(packagePath))).stream().map(path -> {
                String jar = "jar";
                if ("jar".equalsIgnoreCase(path.getProtocol())) {
                    return path.getPath().substring(0, path.getPath().indexOf("!")).replace("file:", "");
                }
                return null;
            }).filter(Objects::nonNull).forEach(path -> {
                try {
                    JarFile jar = new JarFile(URLDecoder.decode(path, StandardCharsets.UTF_8.name()));
                    if (suffixes == null) {
                        set.addAll(JarUtil.getFile(jar, packagePath));
                    } else {
                        set.addAll(JarUtil.getFile(jar, packagePath, isInclude, suffixes));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            return set;
        }
        catch (IOException e) {
            e.printStackTrace();
            return set;
        }
    }

    public static Set<String> getFile(JarFile jar, String packagePath, boolean isInclude, String ... suffixes) {
        return JarUtil.getFile(jar, packagePath).stream().filter(name -> {
            if (name.endsWith(CLASSES_DIR_SPLIT)) {
                return false;
            }
            boolean isTrue = !isInclude;
            for (String suffix : suffixes) {
                if (!name.endsWith(suffix)) continue;
                isTrue = isInclude;
                break;
            }
            return isTrue;
        }).collect(Collectors.toSet());
    }

    public static Set<String> getFile(JarFile jar, String packagePath) {
        String finalPackagePath = JarUtil.toEntryName(packagePath);
        return Collections.list(jar.entries()).stream().filter(entry -> entry.getName().startsWith(finalPackagePath)).map(entry -> CLASSES_DIR_SPLIT + entry.getName()).collect(Collectors.toSet());
    }

    public static String toEntryName(String packagePath) {
        if ((packagePath = packagePath.replace("\\", CLASSES_DIR_SPLIT).replace(".", CLASSES_DIR_SPLIT)).startsWith(File.separator) || packagePath.startsWith(CLASSES_DIR_SPLIT)) {
            packagePath = packagePath.substring(1);
        }
        if (packagePath.endsWith(File.separator) || packagePath.endsWith(CLASSES_DIR_SPLIT)) {
            packagePath = packagePath.substring(0, packagePath.length() - 1);
        }
        return packagePath;
    }
}

