/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.collection;

import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.collection.CollectionsUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class TreeUtil {
    public static <T> List<T> createTree(List<T> list, String key, String parentKey, String childrenKey, String rootValue) throws IllegalAccessException {
        return TreeUtil.createTree(list, key, parentKey, childrenKey, null, rootValue, ".", new String[0]);
    }

    public static <T> List<T> createTree(List<T> list, String key, String parentKey, String childrenKey, String sortKey, String rootValue, String splitChar, String ... fullFields) throws IllegalAccessException {
        if (!list.isEmpty()) {
            T entity = list.get(0);
            Class<?> tClass = entity.getClass();
            ClassInfo<Class<?>> tClassInfo = ClassInfo.getCache(tClass);
            Field keyField = tClassInfo.getField(key);
            Field parentKeyField = tClassInfo.getField(parentKey);
            Field childrenKeyField = tClassInfo.getField(childrenKey);
            Set<Field> fullFieldSet = Stream.of(fullFields).map(fieldName -> {
                Field fullField;
                try {
                    fullField = ClassUtil.getField(tClass, fieldName);
                }
                catch (Exception e) {
                    return null;
                }
                return fullField;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            Object parent = ClassUtil.newInstance(tClass);
            ObjectUtil.setValue(parent, keyField, rootValue);
            return TreeUtil.createChildren(parent, new ArrayList<T>(list), keyField, parentKeyField, childrenKeyField, sortKey, splitChar, fullFieldSet);
        }
        return new ArrayList();
    }

    private static <T> List<T> createChildren(T parentNode, List<T> list, Field keyField, Field parentKeyField, Field childrenKeyField, String sortKey, String splitChar, Set<Field> fullFieldSet) throws IllegalAccessException {
        CopyOnWriteArrayList children = Lists.newCopyOnWriteArrayList();
        Object parentNodeKeyValue = keyField.get(parentNode);
        Collections.synchronizedCollection(list).parallelStream().forEach(currentNode -> {
            try {
                boolean isChild;
                Object currentNodeParentKeyValue = ObjectUtil.getFieldValue(currentNode, parentKeyField);
                boolean bl = isChild = parentNodeKeyValue == null && currentNodeParentKeyValue == null || parentNodeKeyValue != null && String.valueOf(parentNodeKeyValue).equals(String.valueOf(currentNodeParentKeyValue));
                if (isChild) {
                    children.add(currentNode);
                    for (Field field : fullFieldSet) {
                        Object parentValue = ObjectUtil.getFieldValue(parentNode, field);
                        if (parentValue == null) continue;
                        field.set(currentNode, parentValue + splitChar + ObjectUtil.getFieldValue(currentNode, field));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        list.removeIf(children::equals);
        Collections.synchronizedCollection(children).parallelStream().forEach(currentNode -> {
            try {
                childrenKeyField.set(currentNode, TreeUtil.createChildren(currentNode, new ArrayList(list), keyField, parentKeyField, childrenKeyField, sortKey, splitChar, fullFieldSet));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        if (StringUtils.isBlank((CharSequence)sortKey) || children.isEmpty()) {
            return children;
        }
        CollectionsUtil.sort(children, sortKey);
        return children;
    }
}

