/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.collection;

import cloud.agileframework.common.util.collection.SortInfo;
import cloud.agileframework.common.util.object.ObjectUtil;
import java.util.List;
import java.util.Map;

public class CollectionsUtil {
    private CollectionsUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> void sort(List<T> list, String property) {
        CollectionsUtil.sort(list, SortInfo.builder().property(property).sort(true).build());
    }

    public static <T> void sort(List<T> list, SortInfo ... sortInfos) {
        if (sortInfos == null || sortInfos.length == 0) {
            return;
        }
        list.sort((o1, o2) -> {
            int v = 0;
            try {
                SortInfo sort;
                String property;
                SortInfo[] sortInfoArray = sortInfos;
                int n = sortInfoArray.length;
                for (int i = 0; i < n && (v = CollectionsUtil.compare(o1, o2, property = (sort = sortInfoArray[i]).getProperty(), sort.isSort())) == 0; ++i) {
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return v;
        });
    }

    private static <T> int compare(T o1, T o2, String property, boolean sort) throws IllegalAccessException {
        int result = 0;
        result = Map.class.isAssignableFrom(o1.getClass()) ? String.valueOf(((Map)o1).get(property)).compareTo(String.valueOf(((Map)o2).get(property))) : String.valueOf(ObjectUtil.getFieldValue(o1, property)).compareTo(String.valueOf(ObjectUtil.getFieldValue(o2, property)));
        return sort ? result : -result;
    }
}

