/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.string.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ClassUtil
extends ClassUtils {
    public static Set<Field> getAllField(Class<?> clazz) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllField();
    }

    public static Set<Method> getAllMethod(Class<?> clazz) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllMethod();
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getMethod(methodName, paramTypes);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getField(fieldName);
    }

    public static boolean isWrapOrPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        try {
            return ((Class)clazz.getDeclaredField("TYPE").get(null)).isPrimitive();
        }
        catch (IllegalAccessException | NoSuchFieldException ignored) {
            return false;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        ClassInfo<Class<T>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getConstructor(parameterTypes);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            ClassInfo<Class<T>> classInfo = ClassInfo.getCache(clazz);
            Constructor privateConstructor = classInfo.getPrivateConstructor();
            if (privateConstructor == null) {
                try {
                    Constructor[] constructors;
                    Method method = Class.class.getDeclaredMethod("privateGetDeclaredConstructors", Boolean.TYPE);
                    method.setAccessible(true);
                    for (Constructor constructor : constructors = (Constructor[])method.invoke(clazz, false)) {
                        constructor.setAccessible(true);
                        if (constructor.getParameterCount() != 0) continue;
                        privateConstructor = constructor;
                        classInfo.setPrivateConstructor(privateConstructor);
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException method) {
                    // empty catch block
                }
            }
            if (privateConstructor != null) {
                try {
                    return (T)privateConstructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static boolean isAssignableFrom(Class<?> clazz, Class<?> other) {
        return clazz.isAssignableFrom(other);
    }

    public static boolean isExtendsFrom(Class<?> clazz, Class<?> other) {
        return other.isAssignableFrom(clazz);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static <A extends Annotation> Set<Target<A>> getAllFieldAnnotation(Class<?> clazz, Class<A> annotationClass) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllFieldAnnotation(annotationClass);
    }

    public static <A extends Annotation> Set<Target<A>> getAllMethodAnnotation(Class<?> clazz, Class<A> annotationClass) {
        ClassInfo<Class<?>> classInfo = ClassInfo.getCache(clazz);
        return classInfo.getAllMethodAnnotation(annotationClass);
    }

    public static <A extends Annotation> Set<Target<A>> getAllEntityAnnotation(Class<?> clazz, Class<A> annotation) {
        Set<Target<A>> fieldAnnotation = ClassUtil.getAllFieldAnnotation(clazz, annotation);
        Set<Target<A>> methodAnnotation = ClassUtil.getAllMethodAnnotation(clazz, annotation);
        for (Target<A> target : methodAnnotation) {
            String name = target.getMember().getName();
            if (!name.startsWith("get")) continue;
            int length = 3;
            Field targetField = ClassUtil.getField(clazz, StringUtil.toLowerName(name.substring(3)));
            fieldAnnotation.add(new Target<A>(targetField, target.getAnnotation()));
        }
        return fieldAnnotation;
    }

    public static Boolean compareClass(Object source, Object target) {
        return ObjectUtils.isEmpty((Object)source) ? ObjectUtils.isEmpty((Object)target) : !ObjectUtils.isEmpty((Object)target) && source.getClass() == target.getClass();
    }

    public static class Target<A extends Annotation> {
        private Member member;
        private A annotation;

        public Member getMember() {
            return this.member;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public void setMember(Member member) {
            this.member = member;
        }

        public void setAnnotation(A annotation) {
            this.annotation = annotation;
        }

        public String toString() {
            return "ClassUtil.Target(member=" + this.getMember() + ", annotation=" + this.getAnnotation() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Target)) {
                return false;
            }
            Target other = (Target)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Member this$member = this.getMember();
            Member other$member = other.getMember();
            if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
                return false;
            }
            A this$annotation = this.getAnnotation();
            A other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Target;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Member $member = this.getMember();
            result = result * 59 + ($member == null ? 43 : $member.hashCode());
            A $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public Target(Member member, A annotation) {
            this.member = member;
            this.annotation = annotation;
        }
    }
}

