/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.FieldInfo;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;
import sun.reflect.generics.repository.FieldRepository;
import sun.reflect.generics.repository.MethodRepository;

public class ClassInfo<T> {
    private static final Map<String, ClassInfo<?>> CACHE = Maps.newConcurrentMap();
    private final Class<T> clazz;
    private Map<String, Constructor<T>> constructors;
    private Constructor<T> privateConstructor;
    private Set<Field> allField;
    private Set<Method> allMethod;
    private Map<String, Field> fieldMap;
    private Map<String, Method> methodMap;
    private Map<Class<? extends Annotation>, Set<ClassUtil.Target<?>>> fieldAnnotations;
    private Map<Class<? extends Annotation>, Set<ClassUtil.Target<?>>> methodAnnotations;
    private Map<Field, FieldInfo> fieldInfoCache;
    private final Map<String, Type> typeVariableClassMap = Maps.newConcurrentMap();
    private boolean parsed = false;

    public ClassInfo(Type type) {
        this.clazz = type instanceof ParameterizedTypeImpl ? ((ParameterizedTypeImpl)type).getRawType() : (type instanceof Class ? (Class)type : null);
        this.getTypeParameterName(type);
    }

    private void getTypeParameterName(Type currentType) {
        Type clazz = null;
        if (currentType instanceof ParameterizedTypeImpl) {
            clazz = ((ParameterizedTypeImpl)currentType).getRawType();
        } else if (currentType instanceof Class) {
            clazz = (Class)currentType;
        }
        Class superClass = ((Class)clazz).getSuperclass();
        if (superClass == Object.class) {
            return;
        }
        this.getTypeParameterName(superClass);
        Type supper = ((Class)clazz).getGenericSuperclass();
        if (supper instanceof ParameterizedTypeImpl) {
            TypeVariable<Class<T>>[] superClassTypeParameters = superClass.getTypeParameters();
            Type[] typeParameters = ((ParameterizedTypeImpl)supper).getActualTypeArguments();
            for (int i = 0; i < superClassTypeParameters.length; ++i) {
                TypeVariable key = superClassTypeParameters[i];
                Type value = typeParameters[i];
                if (value instanceof TypeVariableImpl) {
                    value = this.typeVariableClassMap.get(((TypeVariableImpl)value).getName());
                }
                if (value == null) continue;
                this.typeVariableClassMap.put(key.getName(), value);
            }
        }
    }

    public static <A extends Type> ClassInfo<A> getCache(A type) {
        ClassInfo<Object> target = CACHE.get(type.toString());
        if (target == null) {
            target = new ClassInfo((Class)type);
            CACHE.put(type.toString(), target);
        }
        return target;
    }

    public <A extends Annotation> Set<ClassUtil.Target<A>> getAllFieldAnnotation(Class<A> annotationClass) {
        HashSet set = null;
        if (this.fieldAnnotations != null) {
            set = this.fieldAnnotations.get(annotationClass);
        }
        if (set == null) {
            Set<Field> fields = this.getAllField();
            set = Sets.newHashSetWithExpectedSize((int)fields.size());
            for (Field field : fields) {
                A annotation = field.getAnnotation(annotationClass);
                if (annotation == null) continue;
                set.add(new ClassUtil.Target<A>(field, annotation));
            }
            if (this.fieldAnnotations == null) {
                this.fieldAnnotations = Maps.newHashMap();
            }
            this.fieldAnnotations.put(annotationClass, set);
        }
        return set.stream().map(r -> r).collect(Collectors.toSet());
    }

    public <A extends Annotation> Set<ClassUtil.Target<A>> getAllMethodAnnotation(Class<A> annotationClass) {
        HashSet set = null;
        if (this.methodAnnotations != null) {
            set = this.methodAnnotations.get(annotationClass);
        }
        if (set == null) {
            Set<Method> methods = this.getAllMethod();
            set = Sets.newHashSetWithExpectedSize((int)methods.size());
            for (Method method : methods) {
                A annotation = method.getAnnotation(annotationClass);
                if (annotation == null) continue;
                set.add(new ClassUtil.Target<A>(method, annotation));
            }
            if (this.methodAnnotations == null) {
                this.methodAnnotations = Maps.newHashMap();
            }
            this.methodAnnotations.put(annotationClass, set);
        }
        return set.stream().map(r -> r).collect(Collectors.toSet());
    }

    public Constructor<T> getPrivateConstructor() {
        return this.privateConstructor;
    }

    public void setPrivateConstructor(Constructor<T> privateConstructor) {
        this.privateConstructor = privateConstructor;
    }

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) {
        String cacheKey = Arrays.stream(parameterTypes).map(Class::getCanonicalName).collect(Collectors.joining());
        Constructor<T> constructor = null;
        if (this.constructors != null) {
            constructor = this.constructors.get(cacheKey);
        }
        if (constructor == null) {
            try {
                constructor = parameterTypes.length > 0 ? this.clazz.getConstructor(parameterTypes) : this.clazz.getConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (this.constructors == null) {
                this.constructors = Maps.newHashMap();
            }
            this.constructors.put(cacheKey, constructor);
        }
        return constructor;
    }

    public Field getField(String key) {
        Object targetField = null;
        if (this.fieldMap != null) {
            targetField = this.fieldMap.get(key);
        }
        if (targetField == null) {
            Set<Field> fields = this.getAllField();
            HashMap targetFields = Maps.newHashMap();
            String targetFieldName = StringUtil.camelToMatchesRegex(key);
            for (Field field : fields) {
                if (!PatternUtil.matches(targetFieldName, field.getName(), 2)) continue;
                targetFields.put(field.getName(), field);
            }
            targetField = targetFields.containsKey(key) ? (Field)targetFields.get(key) : (targetFields.isEmpty() ? null : (Field)targetFields.values().iterator().next());
            if (targetField != null) {
                if (!((AccessibleObject)targetField).isAccessible()) {
                    ((Field)targetField).setAccessible(true);
                }
                if (this.fieldMap == null) {
                    this.fieldMap = Maps.newHashMap();
                }
                this.fieldMap.put(key, (Field)targetField);
            }
        }
        return targetField;
    }

    public void parsingGeneric(Field targetField) {
        if (targetField == null) {
            return;
        }
        try {
            Method getGenericInfoMethod = Field.class.getDeclaredMethod("getGenericInfo", new Class[0]);
            getGenericInfoMethod.setAccessible(true);
            getGenericInfoMethod.invoke((Object)targetField, new Object[0]);
        }
        catch (Exception getGenericInfoMethod) {
            // empty catch block
        }
        Object genericInfo = ObjectUtil.getFieldValue((Object)targetField, "genericInfo");
        if (genericInfo == null) {
            return;
        }
        Type genericType = targetField.getGenericType();
        if (genericType instanceof TypeVariableImpl) {
            try {
                Type value = this.typeVariableClassMap.get(((TypeVariableImpl)genericType).getName());
                if (value == null) {
                    return;
                }
                Field genericTypeField = ClassUtil.getField(FieldRepository.class, "genericType");
                genericTypeField.setAccessible(true);
                ObjectUtil.setValue(genericInfo, genericTypeField, value);
                Field typeField = ClassUtil.getField(Field.class, "type");
                typeField.setAccessible(true);
                ObjectUtil.setValue(targetField, typeField, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Method getMethod(String methodName, Class<?> ... paramTypes) {
        String cacheKey = methodName + Arrays.stream(paramTypes).map(Class::getCanonicalName).collect(Collectors.joining());
        Method targetMethod = null;
        if (this.methodMap != null) {
            targetMethod = this.methodMap.get(cacheKey);
        }
        if (targetMethod != null) {
            return targetMethod;
        }
        if (paramTypes != null) {
            try {
                targetMethod = this.clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Expected method not found: " + ex);
            }
        } else {
            Method[] methods;
            HashSet<Method> candidates = new HashSet<Method>(1);
            for (Method method : methods = this.clazz.getMethods()) {
                if (!methodName.equals(method.getName())) continue;
                candidates.add(method);
            }
            if (candidates.size() == 1) {
                targetMethod = (Method)candidates.iterator().next();
            } else {
                if (candidates.isEmpty()) {
                    throw new IllegalStateException("Expected method not found: " + this.clazz.getName() + '.' + methodName);
                }
                throw new IllegalStateException("No unique method found: " + this.clazz.getName() + '.' + methodName);
            }
        }
        if (!targetMethod.isAccessible()) {
            targetMethod.setAccessible(true);
        }
        if (this.methodMap == null) {
            this.methodMap = Maps.newHashMap();
        }
        this.methodMap.put(cacheKey, targetMethod);
        return targetMethod;
    }

    public void parsingGeneric(Method targetMethod) {
        try {
            Method getGenericInfoMethod = Method.class.getDeclaredMethod("getGenericInfo", new Class[0]);
            getGenericInfoMethod.setAccessible(true);
            getGenericInfoMethod.invoke((Object)targetMethod, new Object[0]);
        }
        catch (Exception getGenericInfoMethod) {
            // empty catch block
        }
        try {
            this.setParameterTypes(targetMethod);
            this.setReturnType(targetMethod);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setReturnType(Method targetMethod) throws NoSuchFieldException, IllegalAccessException {
        Field genericInfoField = Method.class.getDeclaredField("genericInfo");
        genericInfoField.setAccessible(true);
        Object genericInfo = genericInfoField.get(targetMethod);
        if (genericInfo == null) {
            return;
        }
        Type genericReturnType = targetMethod.getGenericReturnType();
        if (genericReturnType instanceof TypeVariableImpl) {
            Type v = this.typeVariableClassMap.get(genericReturnType.getTypeName());
            Field returnType = MethodRepository.class.getDeclaredField("returnType");
            returnType.setAccessible(true);
            returnType.set(genericInfo, v);
            Field returnTypeField = Method.class.getDeclaredField("returnType");
            returnTypeField.setAccessible(true);
            returnTypeField.set(targetMethod, v);
        }
    }

    private void setParameterTypes(Method targetMethod) throws NoSuchFieldException, IllegalAccessException {
        Field parameterTypes;
        Type[] types = Arrays.stream(targetMethod.getGenericParameterTypes()).map(t -> {
            Type v = this.typeVariableClassMap.get(t.getTypeName());
            return v == null ? t : v;
        }).collect(Collectors.toList()).toArray(new Type[0]);
        if (types.length == 0) {
            return;
        }
        Field genericInfoField = Method.class.getDeclaredField("genericInfo");
        genericInfoField.setAccessible(true);
        Object genericInfo = genericInfoField.get(targetMethod);
        if (genericInfo == null) {
            return;
        }
        try {
            parameterTypes = MethodRepository.class.getSuperclass().getDeclaredField("paramTypes");
        }
        catch (NoSuchFieldException e) {
            parameterTypes = MethodRepository.class.getSuperclass().getDeclaredField("parameterTypes");
        }
        parameterTypes.setAccessible(true);
        parameterTypes.set(genericInfo, types);
        Field methodParameterTypes = Method.class.getDeclaredField("parameterTypes");
        methodParameterTypes.setAccessible(true);
        Class[] classes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (!(types[i] instanceof Class)) {
                return;
            }
            classes[i] = (Class)types[i];
        }
        methodParameterTypes.set(targetMethod, classes);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<Field> getAllField() {
        if (this.allField == null) {
            this.allField = Sets.newConcurrentHashSet();
        }
        if (this.allField.isEmpty()) {
            ClassInfo.extractFieldRecursion(this.clazz, this.allField);
            this.allField.parallelStream().forEach(field -> {
                field.setAccessible(true);
                this.parsingGeneric((Field)field);
            });
        }
        return this.allField;
    }

    private static void extractFieldRecursion(Class<?> clazz, Set<Field> set) {
        Field[] selfFields = clazz.getDeclaredFields();
        Field[] extendFields = clazz.getFields();
        set.addAll(Arrays.asList(selfFields));
        set.addAll(Arrays.asList(extendFields));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == Object.class || superClass == null) {
            return;
        }
        ClassInfo.extractFieldRecursion(superClass, set);
    }

    public synchronized Set<Method> getAllMethod() {
        if (this.allMethod == null) {
            this.allMethod = Sets.newConcurrentHashSet();
        }
        if (this.allMethod.isEmpty()) {
            ClassInfo.extractMethodRecursion(this.clazz, this.allMethod);
        }
        if (!this.parsed) {
            this.allMethod.forEach(method -> {
                method.setAccessible(true);
                this.parsingGeneric((Method)method);
            });
            this.parsed = true;
        }
        return this.allMethod;
    }

    private static void extractMethodRecursion(Class<?> clazz, Set<Method> set) {
        Method[] selfMethods = clazz.getDeclaredMethods();
        Method[] extendMethods = clazz.getMethods();
        set.addAll(Arrays.asList(selfMethods));
        set.addAll(Arrays.asList(extendMethods));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == Object.class || superClass == null) {
            return;
        }
        ClassInfo.extractMethodRecursion(superClass, set);
    }

    public FieldInfo getFieldInfo(Field field) {
        FieldInfo fieldInfo;
        if (this.fieldInfoCache == null) {
            this.fieldInfoCache = Maps.newConcurrentMap();
        }
        if ((fieldInfo = this.fieldInfoCache.get(field)) == null) {
            fieldInfo = new FieldInfo();
            this.fieldInfoCache.put(field, fieldInfo);
        }
        return fieldInfo;
    }
}

