/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.object;

import cloud.agileframework.common.annotation.Alias;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.date.DateUtil;
import cloud.agileframework.common.util.map.MapUtil;
import cloud.agileframework.common.util.number.NumberUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ObjectUtil
extends ObjectUtils {
    private static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static <T> T to(Object from, TypeReference<T> toClass) {
        Object result;
        if (from == null) {
            return null;
        }
        if (toClass.isEnum()) {
            result = ObjectUtil.toEnum(from, toClass);
        } else if (toClass.isArray()) {
            result = ObjectUtil.toArray(from, toClass);
        } else if (toClass.isExtendsFrom(Collection.class)) {
            result = ObjectUtil.toCollection(from, toClass);
        } else if (toClass.isExtendsFrom(Map.class)) {
            result = ObjectUtil.toMap(from, toClass);
        } else if (toClass.isWrapOrPrimitive()) {
            result = ObjectUtil.to(from, toClass.getWrapperClass());
        } else if (toClass.isExtendsFrom(Date.class)) {
            GregorianCalendar calendar;
            result = from instanceof Date ? from : ((calendar = DateUtil.parse(from.toString())) != null ? calendar.getTime() : null);
        } else if (toClass.isAssignableFrom(from.getClass()) || toClass.getWrapperClass() == Object.class) {
            result = from;
        } else {
            Constructor<T> construct2;
            result = ObjectUtil.toPOJO(from, (Class)toClass.getType());
            if (result == null) {
                try {
                    construct2 = toClass.getConstruct(from.getClass());
                    result = construct2.newInstance(from);
                }
                catch (Exception construct2) {
                    // empty catch block
                }
            }
            if (result == null) {
                try {
                    construct2 = toClass.getConstruct(String.class);
                    result = construct2.newInstance(ObjectUtil.toString(from));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static String toString(Object from) {
        String result = from.getClass().isArray() ? ArrayUtils.toString((Object)from) : (Collection.class.isAssignableFrom(from.getClass()) ? ArrayUtils.toString((Object)((Collection)from).toArray()) : (Map.class.isAssignableFrom(from.getClass()) ? from.toString() : (from.getClass().isEnum() ? ((Enum)from).name() : from.toString())));
        return result;
    }

    private static <T> T toEnum(Object from, TypeReference<T> toClass) {
        if (toClass.isEnum()) {
            try {
                Class enumClass = toClass.getWrapperClass();
                Method values = enumClass.getMethod("values", new Class[0]);
                values.setAccessible(true);
                Enum[] v = (Enum[])values.invoke(null, new Object[0]);
                List<String> nameList = Stream.of(v).map(Enum::name).collect(Collectors.toList());
                String targetName = StringUtil.vagueMatches(from.toString(), nameList);
                if (targetName != null) {
                    Method valueOf = enumClass.getMethod("valueOf", String.class);
                    valueOf.setAccessible(true);
                    return (T)valueOf.invoke(null, targetName);
                }
                HashMap map = Maps.newHashMapWithExpectedSize((int)v.length);
                nameList = Stream.of(v).map(node -> map.put(node.toString(), node)).filter(Objects::nonNull).map(Enum::toString).collect(Collectors.toList());
                targetName = StringUtil.vagueMatches(from.toString(), nameList);
                return (T)map.get(targetName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static <T> T toArray(Object from, TypeReference<T> toClass) {
        Object array = null;
        Class<?> innerClass = toClass.getWrapperClass().getComponentType();
        if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class)) {
            array = Array.newInstance(innerClass, ((Collection)from).size());
            int i = 0;
            for (Object node : (Collection)from) {
                Array.set(array, i++, ObjectUtil.to(node, new TypeReference<Object>(innerClass){}));
            }
        } else if (from.getClass().isArray()) {
            int length = Array.getLength(from);
            array = Array.newInstance(innerClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, ObjectUtil.to(Array.get(from, i), new TypeReference<Object>(innerClass){}));
            }
        } else if (from instanceof String) {
            try {
                JSONArray jsonArray = JSON.parseArray((String)((String)from));
                return ObjectUtil.to((Object)jsonArray, toClass);
            }
            catch (Exception e) {
                String[] strings = ((String)from).split(",");
                return ObjectUtil.toArray(strings, toClass);
            }
        }
        return (T)array;
    }

    private static <T> T toMap(Object from, TypeReference<T> toClass) {
        if (toClass.isExtendsFrom(Map.class)) {
            if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class) || from.getClass().isArray()) {
                return null;
            }
            Map map = MapUtil.parse(from);
            return (T)MapUtil.toMap(map, toClass);
        }
        return null;
    }

    private static <T> T toCollection(Object from, TypeReference<T> toClass) {
        if (toClass.isExtendsFrom(Collection.class)) {
            if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class) || from.getClass().isArray()) {
                Object nodeType = toClass.getParameterizedType(0);
                if (nodeType == null) {
                    nodeType = Object.class;
                }
                AbstractCollection collection = toClass.getWrapperClass().isInterface() ? (toClass.isExtendsFrom(Queue.class) ? new ArrayDeque() : (toClass.isExtendsFrom(Set.class) ? new HashSet() : new ArrayList())) : (ArrayDeque)ClassUtil.newInstance(toClass.getWrapperClass());
                if (collection != null) {
                    if (ClassUtil.isExtendsFrom(from.getClass(), Collection.class)) {
                        for (Object o : (Collection)from) {
                            collection.add(ObjectUtil.to(o, new TypeReference((Type)nodeType)));
                        }
                    } else if (from.getClass().isArray()) {
                        for (Object o : (Object[])from) {
                            collection.add(ObjectUtil.to(o, new TypeReference((Type)nodeType)));
                        }
                    }
                }
                return (T)collection;
            }
            if (from instanceof String) {
                try {
                    JSONArray array = JSON.parseArray((String)((String)from));
                    return ObjectUtil.to((Object)array, toClass);
                }
                catch (Exception e) {
                    String[] strings = ((String)from).split(",");
                    return ObjectUtil.toCollection(strings, toClass);
                }
            }
        }
        return null;
    }

    private static <T> T toPOJO(Object from, Class<? extends T> toClass) {
        if (from == null || toClass.isAssignableFrom(from.getClass())) {
            return (T)from;
        }
        Class<?> sourceClass = from.getClass();
        if (sourceClass.isPrimitive() || Iterable.class.isAssignableFrom(sourceClass)) {
            return null;
        }
        if (ClassUtil.isExtendsFrom(sourceClass, Map.class)) {
            Map map = (Map)from;
            Object object = ClassUtil.newInstance(toClass);
            if (object != null) {
                Set<Field> fields = ClassUtil.getAllField(toClass);
                fields.forEach(field -> {
                    String key = StringUtil.vagueMatches(field.getName(), map.keySet());
                    if (key != null) {
                        try {
                            Object value = map.get(key);
                            ObjectUtil.setValue(object, field, value);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                });
                if (!ObjectUtil.isNotChange(object)) {
                    return object;
                }
            }
        } else if (from instanceof String) {
            Object json = JSON.parse((String)((String)from));
            if (json instanceof JSON) {
                return ObjectUtil.toPOJO(json, toClass);
            }
        } else {
            T object = ClassUtil.newInstance(toClass);
            ObjectUtil.copyProperties(from, object);
            if (!ObjectUtil.isNotChange(object)) {
                return object;
            }
        }
        return null;
    }

    private static <T> T to(Object from, Class<T> toClass) {
        if (from == null) {
            return null;
        }
        Object temp = null;
        if (from.getClass().isArray() && Array.getLength(from) > 0) {
            from = Array.get(from, 0);
        }
        if (Collection.class.isAssignableFrom(from.getClass()) && !((Collection)from).isEmpty()) {
            from = ((Collection)from).iterator().next();
        }
        String valueStr = from.toString();
        if (NumberUtil.isNumber(toClass)) {
            Number number = NumberUtils.createNumber((String)valueStr);
            if (toClass == Short.class || toClass == Short.TYPE) {
                temp = number.shortValue();
            } else if (toClass == Integer.class || toClass == Integer.TYPE) {
                temp = number.intValue();
            } else if (toClass == Long.class || toClass == Long.TYPE) {
                temp = number.longValue();
            } else if (toClass == Float.class || toClass == Float.TYPE) {
                temp = Float.valueOf(number.floatValue());
            } else if (toClass == Double.class || toClass == Double.TYPE) {
                temp = number.doubleValue();
            }
        } else if (toClass == Boolean.class || toClass == Boolean.TYPE) {
            temp = NumberUtils.isParsable((String)valueStr) ? Boolean.valueOf(NumberUtils.createNumber((String)valueStr).intValue() > 0) : Boolean.valueOf(Boolean.parseBoolean(valueStr));
        } else if (toClass == Byte.class || toClass == Byte.TYPE) {
            temp = Byte.parseByte(valueStr);
        } else if (toClass == Character.class || toClass == Character.TYPE) {
            char[] array = valueStr.toCharArray();
            temp = array.length > 0 ? Character.valueOf(array[0]) : null;
        } else if (toClass == String.class) {
            temp = valueStr;
        }
        return (T)temp;
    }

    public static boolean isNotChange(Object object) {
        if (object == null) {
            return true;
        }
        Class<?> clazz = object.getClass();
        try {
            Object newObject = clazz.newInstance();
            Set haveValueFields = ClassUtil.getAllField(clazz).stream().filter(field -> {
                field.setAccessible(true);
                try {
                    if (SERIAL_VERSION_UID.equals(field.getName())) {
                        return false;
                    }
                    Object currentValue = field.get(object);
                    Object initValue = field.get(newObject);
                    return currentValue != null && !Objects.deepEquals(currentValue, initValue);
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return haveValueFields.isEmpty();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return false;
        }
    }

    public static void setValue(Object object, Field field, Object value) {
        object = Optional.ofNullable(object).orElseThrow(IllegalArgumentException::new);
        field.setAccessible(true);
        Class<?> objectClass = object.getClass();
        String fieldName = field.getName();
        Optional<Object> optional = Optional.ofNullable(value);
        if (optional.isPresent()) {
            Method setMethod;
            Type fieldType = field.getGenericType();
            String setMethodName = "set" + StringUtil.toUpperName(fieldName);
            Object initValue = null;
            try {
                initValue = field.get(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (ParameterizedType.class.isAssignableFrom(fieldType.getClass())) {
                    Type rawType = ((ParameterizedType)fieldType).getRawType();
                    setMethod = ClassUtil.getMethod(objectClass, setMethodName, (Class)rawType);
                    ObjectUtil.invokeMethodIfParamNotNull(object, setMethod, ObjectUtil.to(value, new TypeReference(fieldType)));
                } else {
                    setMethod = ClassUtil.getMethod(objectClass, setMethodName, (Class)fieldType);
                    ObjectUtil.invokeMethodIfParamNotNull(object, setMethod, value);
                }
            }
            catch (Exception rawType) {
                // empty catch block
            }
            try {
                if (Objects.equals(field.get(object), initValue)) {
                    setMethod = ClassUtil.getMethod(objectClass, setMethodName, value.getClass());
                    ObjectUtil.invokeMethodIfParamNotNull(object, setMethod, value);
                }
            }
            catch (Exception rawType) {
                // empty catch block
            }
            try {
                if (Objects.equals(field.get(object), initValue)) {
                    List list = Arrays.stream(objectClass.getMethods()).filter(method -> setMethodName.equals(method.getName())).collect(Collectors.toList());
                    for (Method method2 : list) {
                        try {
                            ObjectUtil.invokeMethodIfParamNotNull(object, method2, value);
                            if (field.get(object) == initValue) continue;
                            return;
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (Objects.equals(field.get(object), initValue)) {
                    ObjectUtil.setValueIfNotNull(object, field, value);
                }
            }
            catch (Exception exception) {}
        } else if (!field.getType().isPrimitive()) {
            try {
                field.set(object, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void invokeMethodIfParamNotNull(Object object, Method method, Object value) {
        if (object == null || method == null || value == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 1) {
            Optional.ofNullable(ObjectUtil.to(value, new TypeReference(parameterTypes[0]))).ifPresent(v -> {
                try {
                    method.invoke(object, v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public static void setValueIfNotNull(Object object, Field field, Object value) {
        Optional.ofNullable(ObjectUtil.to(value, new TypeReference(field.getGenericType()))).ifPresent(v -> {
            try {
                field.set(object, v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void copyProperties(Object source, Object target, Compare compare) {
        Set<String> fields = ObjectUtil.getSameField(source, target, compare);
        ObjectUtil.copyProperties(source, target, fields.toArray(new String[0]), ContainOrExclude.INCLUDE);
    }

    private static Set<String> getSameField(Object source, Object target, Compare compare) {
        HashSet<String> result = new HashSet<String>();
        if (ObjectUtils.isEmpty((Object)source) || ObjectUtils.isEmpty((Object)target)) {
            return result;
        }
        Set<String> sameField = ObjectUtil.getSameField(source, target);
        if (sameField.isEmpty()) {
            return result;
        }
        Object targetNew = null;
        try {
            targetNew = target.getClass().newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String fieldName : sameField) {
            Object sourceValue = ObjectUtil.getFieldValue(source, fieldName);
            Object targetValue = ObjectUtil.getFieldValue(target, fieldName);
            switch (compare) {
                case DIFF_ALL_NOT_NULL: {
                    if (sourceValue == null || targetValue == null || sourceValue.equals(targetValue)) break;
                    result.add(fieldName);
                    break;
                }
                case DIFF_TARGET_NULL: {
                    if (sourceValue == null || targetValue != null) break;
                    result.add(fieldName);
                    break;
                }
                case DIFF_SOURCE_NULL: {
                    if (sourceValue != null || targetValue == null) break;
                    result.add(fieldName);
                    break;
                }
                case DIFF_SOURCE_NOT_NULL: {
                    if (sourceValue == null || sourceValue.equals(targetValue)) break;
                    result.add(fieldName);
                    break;
                }
                case DIFF_TARGET_NOT_NULL: {
                    if (targetValue == null || targetValue.equals(sourceValue)) break;
                    result.add(fieldName);
                    break;
                }
                case DIFF_SOURCE_NOT_NULL_AND_TARGET_DEFAULT: {
                    if (targetNew == null) {
                        throw new RuntimeException(String.format("\u76ee\u6807\u5bf9\u8c61\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7c7b\u201c%s\u201d\u662f\u5426\u5305\u542b\u7a7a\u53c2\u6784\u9020\u51fd\u6570", target.getClass()));
                    }
                    if (sourceValue != null && targetValue == null) {
                        result.add(fieldName);
                        break;
                    }
                    if (sourceValue == null || sourceValue.equals(targetValue) || !targetValue.equals(ObjectUtil.getFieldValue(targetNew, fieldName))) break;
                    result.add(fieldName);
                    break;
                }
                case DIFF_TARGET_DEFAULT: {
                    if (targetNew == null) {
                        throw new RuntimeException(String.format("\u76ee\u6807\u5bf9\u8c61\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7c7b\u201c%s\u201d\u662f\u5426\u5305\u542b\u7a7a\u53c2\u6784\u9020\u51fd\u6570", target.getClass()));
                    }
                    if (targetValue != null && targetValue.equals(ObjectUtil.getFieldValue(targetNew, fieldName)) && targetValue.equals(sourceValue)) {
                        result.add(fieldName);
                        break;
                    }
                    if (targetValue != null || ObjectUtil.getFieldValue(targetNew, fieldName) != null || sourceValue == null) break;
                    result.add(fieldName);
                    break;
                }
                case DIFF: {
                    boolean is;
                    boolean bl = is = sourceValue == null && targetValue != null || sourceValue != null && targetValue == null || sourceValue != null && !source.equals(targetValue);
                    if (!is) break;
                    result.add(fieldName);
                    break;
                }
                case SAME: {
                    if (sourceValue == null || !sourceValue.equals(targetValue)) break;
                    result.add(fieldName);
                    break;
                }
            }
        }
        return result;
    }

    private static Set<String> getSameField(Object source, Object target) {
        Class<?> sourceClass = source.getClass();
        Class<?> targetClass = target.getClass();
        HashSet<String> result = new HashSet<String>();
        if (sourceClass == targetClass) {
            Set<Field> sourceFields = ClassUtil.getAllField(sourceClass);
            for (Field field : sourceFields) {
                result.add(field.getName());
            }
        } else {
            Set<Field> sourceFields = ClassUtil.getAllField(sourceClass);
            for (Field field : sourceFields) {
                String name = field.getName();
                Field targetField = ClassUtil.getField(targetClass, name);
                if (targetField == null) continue;
                result.add(name);
            }
        }
        return result;
    }

    public static void copyProperties(Object source, Object target, String[] arguments, ContainOrExclude containOrExclude) {
        ObjectUtil.copyProperties(source, target, "", "", arguments, containOrExclude);
    }

    public static void copyProperties(Object source, Object target, String prefix, String suffix) {
        ObjectUtil.copyProperties(source, target, prefix, suffix, new String[0], ContainOrExclude.INCLUDE);
    }

    public static void copyProperties(Object source, Object target) {
        ObjectUtil.copyProperties(source, target, Compare.DIFF);
    }

    public static void copyProperties(Object source, Object target, String prefix, String suffix, String[] arguments, ContainOrExclude containOrExclude) {
        if (ObjectUtils.isEmpty((Object)source) || ObjectUtils.isEmpty((Object)target)) {
            return;
        }
        Set<Field> targetFields = ClassUtil.getAllField(target.getClass());
        block6: for (Field field : targetFields) {
            field.setAccessible(true);
            String propertyName = field.getName();
            propertyName = StringUtils.isBlank((CharSequence)prefix) ? propertyName : prefix + StringUtil.toUpperName(propertyName);
            String string = propertyName = StringUtils.isBlank((CharSequence)suffix) ? propertyName : propertyName + StringUtil.toUpperName(suffix);
            Field sourceProperty = ClassUtil.getField(source.getClass(), propertyName);
            if (sourceProperty == null || arguments == null) continue;
            switch (containOrExclude) {
                case EXCLUDE: {
                    if (!ArrayUtils.contains((Object[])arguments, (Object)sourceProperty.getName())) break;
                    continue block6;
                }
                case INCLUDE: {
                    if (ArrayUtils.contains((Object[])arguments, (Object)sourceProperty.getName())) break;
                    continue block6;
                }
            }
            try {
                sourceProperty.setAccessible(true);
                Object value = sourceProperty.get(source);
                if (value != null) {
                    Type type = field.getGenericType();
                    TypeReference typeReference = new TypeReference(type);
                    value = ObjectUtil.to(value, typeReference);
                }
                field.setAccessible(true);
                ObjectUtil.setValue(target, field, value);
            }
            catch (Exception exception) {}
        }
    }

    public static Object getFieldValue(Object o, String fieldName) {
        Field field = ClassUtil.getField(o.getClass(), fieldName);
        if (field == null) {
            return null;
        }
        return ObjectUtil.getFieldValue(o, field);
    }

    public static Object getFieldValue(Object o, Field field) {
        if (field == null) {
            return null;
        }
        try {
            String getMethodName = "get" + StringUtil.toUpperName(field.getName());
            Method getMethod = o.getClass().getMethod(getMethodName, new Class[0]);
            getMethod.setAccessible(true);
            return getMethod.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            try {
                field.setAccessible(true);
                return field.get(o);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
        }
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<?, ?> map) {
        return ObjectUtil.getObjectFromMap(clazz, map, "", "");
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<String, Object> map, String prefix) {
        return ObjectUtil.getObjectFromMap(clazz, map, prefix, "");
    }

    public static <T> T getObjectFromMap(Class<T> clazz, Map<?, ?> map, String prefix, String suffix) {
        if (Map.class.isAssignableFrom(clazz)) {
            return (T)map;
        }
        if (!ObjectUtils.isEmpty(map)) {
            try {
                Object object = clazz.newInstance();
                Set<Field> fields = ClassUtil.getAllField(clazz);
                fields.forEach(field -> {
                    String key = ObjectUtil.coverFieldNameToMapKey(clazz, field, prefix, suffix, map);
                    if (key != null) {
                        try {
                            Object value = map.get(key);
                            ObjectUtil.setValue(object, field, value);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                });
                if (!ObjectUtil.isAllNullValidity(object)) {
                    return object;
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String coverFieldNameToMapKey(Class<?> clazz, Field field, String prefix, String suffix, Map<?, ?> map) {
        String key = null;
        try {
            Alias column = ObjectUtil.getAllEntityPropertyAnnotation(clazz, field, Alias.class);
            if (column == null) {
                return null;
            }
            for (String alias : column.value()) {
                if (!map.containsKey(alias)) continue;
                key = alias;
                break;
            }
        }
        catch (Exception column) {
            // empty catch block
        }
        if (key != null) {
            return key;
        }
        String propertyName = prefix + field.getName() + suffix;
        String propertyRegex = StringUtil.camelToMatchesRegex(propertyName);
        HashSet<String> keys = new HashSet<String>();
        for (Object mapKey : map.keySet()) {
            if (!PatternUtil.matches(propertyRegex, mapKey.toString(), 2)) continue;
            keys.add(mapKey.toString());
        }
        if (keys.size() > 1) {
            if (keys.contains(propertyName)) {
                key = propertyName;
            } else {
                String camelToUnderlineKey = StringUtil.toUnderline(propertyName);
                String camelToUnderlineKeyUpper = camelToUnderlineKey.toUpperCase();
                String camelToUnderlineKeyLower = camelToUnderlineKey.toLowerCase();
                if (keys.contains(camelToUnderlineKey)) {
                    key = camelToUnderlineKey;
                } else if (keys.contains(camelToUnderlineKeyUpper)) {
                    key = camelToUnderlineKeyUpper;
                } else if (keys.contains(camelToUnderlineKeyLower)) {
                    key = camelToUnderlineKeyLower;
                }
            }
        } else if (keys.size() == 1) {
            key = (String)keys.iterator().next();
        }
        return key;
    }

    public static <T extends Annotation> T getAllEntityPropertyAnnotation(Class<?> clazz, Field field, Class<T> annotation) throws NoSuchMethodException {
        Method method;
        T methodAnnotations;
        String getMethodName;
        Method declaredMethod;
        T methodDeclaredAnnotations;
        T fieldAnnotations;
        T result = null;
        T fieldDeclaredAnnotations = field.getDeclaredAnnotation(annotation);
        if (fieldDeclaredAnnotations != null) {
            result = fieldDeclaredAnnotations;
        }
        if ((fieldAnnotations = field.getAnnotation(annotation)) != null) {
            result = fieldAnnotations;
        }
        if ((methodDeclaredAnnotations = (declaredMethod = clazz.getDeclaredMethod(getMethodName = String.format("get%s", StringUtil.toUpperName(field.getName())), new Class[0])).getDeclaredAnnotation(annotation)) != null) {
            result = methodDeclaredAnnotations;
        }
        if ((methodAnnotations = (method = clazz.getMethod(getMethodName, new Class[0])).getAnnotation(annotation)) != null) {
            result = methodAnnotations;
        }
        return result;
    }

    public static boolean isAllNullValidity(Object object) {
        Class<?> clazz = object.getClass();
        try {
            Object newObject = clazz.newInstance();
            Set haveValueFields = ClassUtil.getAllField(clazz).stream().filter(field -> {
                field.setAccessible(true);
                try {
                    if (SERIAL_VERSION_UID.equals(field.getName())) {
                        return false;
                    }
                    Object currentValue = field.get(object);
                    Object initValue = field.get(newObject);
                    return currentValue != null && currentValue != initValue;
                }
                catch (Exception e) {
                    return false;
                }
            }).collect(Collectors.toSet());
            return haveValueFields.isEmpty();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return false;
        }
    }

    public static String objectToString(Object o, String ... exclude) {
        Class<?> clazz = o.getClass();
        StringBuilder target = new StringBuilder(clazz.getSimpleName()).append("{");
        Set<Field> fields = ClassUtil.getAllField(clazz);
        int i = 0;
        for (Field field : fields) {
            try {
                if (ArrayUtils.contains((Object[])exclude, (Object)field.getName())) {
                    ++i;
                    continue;
                }
                field.setAccessible(true);
                if (i != 0) {
                    target.append(", ");
                }
                target.append(field.getName()).append("='").append(field.get(o));
                if (i == fields.size() - 1) {
                    target.append('}');
                } else {
                    target.append('\'');
                }
            }
            catch (IllegalAccessException e) {
                continue;
            }
            ++i;
        }
        return target.toString();
    }

    public static Map<String, Object> getUnderlineMapFromObject(Object o) {
        Set<Field> fields = ClassUtil.getAllField(o.getClass());
        HashMap<String, Object> result = new HashMap<String, Object>(fields.size());
        if (!fields.isEmpty()) {
            for (Field field : fields) {
                field.setAccessible(true);
                String key = StringUtil.toUnderline(field.getName());
                try {
                    result.put(key, field.get(o));
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return result;
    }

    public static List<Map<String, Object>> getUnderlineMapFromListObject(Iterable<Object> list) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (list != null) {
            for (Object o : list) {
                result.add(ObjectUtil.getUnderlineMapFromObject(o));
            }
        }
        return result;
    }

    public static boolean compare(Object source, Object target) {
        return ObjectUtil.isEmpty((Object)source) && ObjectUtil.isEmpty((Object)target) || source.equals(target);
    }

    public static List<Different> getDifferenceProperties(Object source, Object target, String ... excludeProperty) throws IllegalAccessException {
        ArrayList<Different> result = new ArrayList<Different>();
        if ((ClassUtil.compareClass(source, target) == false || ObjectUtil.compare(source, target) || ObjectUtil.isEmpty((Object)source)) != ObjectUtil.isEmpty((Object)target)) {
            return result;
        }
        Object sourceObject = ObjectUtil.isEmpty((Object)source) ? target : source;
        Object targetObject = ObjectUtil.isEmpty((Object)source) ? source : target;
        Class<?> sourceClass = sourceObject.getClass();
        Set<Field> fields = ClassUtil.getAllField(sourceClass);
        for (Field field : fields) {
            Object targetValue;
            Object sourceValue;
            field.setAccessible(true);
            if (excludeProperty != null && ArrayUtils.contains((Object[])excludeProperty, (Object)field.getName()) || ObjectUtil.compare(sourceValue = field.get(sourceObject), targetValue = field.get(targetObject))) continue;
            result.add(new Different(field.getName(), field.getType().getTypeName(), String.valueOf(targetValue), String.valueOf(sourceValue)));
        }
        return result;
    }

    public static boolean compareValue(Object source, Object target, String ... excludeProperty) {
        if (ObjectUtil.isEmpty((Object)source)) {
            return ObjectUtil.isEmpty((Object)target);
        }
        if (ObjectUtil.isEmpty((Object)target)) {
            return false;
        }
        try {
            List<Different> list = ObjectUtil.getDifferenceProperties(source, target, excludeProperty);
            if (!ObjectUtils.isEmpty(list)) {
                return false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return true;
    }

    public static boolean compareOfNotNull(Object source, Object target) {
        Field[] fields;
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (SERIAL_VERSION_UID.equals(field.getName())) continue;
            try {
                Object targetValue;
                Object sourceValue = field.get(source);
                if (sourceValue == null || sourceValue.equals(targetValue = field.get(target))) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static class Different {
        private final String propertyName;
        private final String propertyType;
        private final String newValue;
        private final String oldValue;

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyType() {
            return this.propertyType;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Different)) {
                return false;
            }
            Different other = (Different)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            String this$propertyType = this.getPropertyType();
            String other$propertyType = other.getPropertyType();
            if (this$propertyType == null ? other$propertyType != null : !this$propertyType.equals(other$propertyType)) {
                return false;
            }
            String this$newValue = this.getNewValue();
            String other$newValue = other.getNewValue();
            if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
                return false;
            }
            String this$oldValue = this.getOldValue();
            String other$oldValue = other.getOldValue();
            return !(this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Different;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            String $propertyType = this.getPropertyType();
            result = result * 59 + ($propertyType == null ? 43 : $propertyType.hashCode());
            String $newValue = this.getNewValue();
            result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
            String $oldValue = this.getOldValue();
            result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
            return result;
        }

        public String toString() {
            return "ObjectUtil.Different(propertyName=" + this.getPropertyName() + ", propertyType=" + this.getPropertyType() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ")";
        }

        public Different(String propertyName, String propertyType, String newValue, String oldValue) {
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }
    }

    public static enum ContainOrExclude {
        INCLUDE,
        EXCLUDE;

    }

    public static enum Compare {
        SAME,
        DIFF,
        DIFF_ALL_NOT_NULL,
        DIFF_SOURCE_NULL,
        DIFF_TARGET_NULL,
        DIFF_TARGET_DEFAULT,
        DIFF_SOURCE_NOT_NULL_AND_TARGET_DEFAULT,
        DIFF_SOURCE_NOT_NULL,
        DIFF_TARGET_NOT_NULL;

    }
}

