/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.date;

import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class DateUtil {
    private static final String DATE_REGEX = "((?<year0>([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3}))(?<split1>[\\D]+)(((?<month0>([13578]|1[02]))(?<split2>[\\D]+)(?<date0>([12][0-9]|3[01]|[1-9])))|((?<month1>([469]|11))(?<split3>[\\D]+)(?<date1>([12][0-9]|30|[1-9])))|((?<month2>2)(?<split4>[\\D]+)(?<date2>([1][0-9]|2[0-8]|[1-9])))))|((?<year1>(([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|1[26]|[2468][048]|[3579][26])00)))(?<split5>[\\D]+)(?<month3>2)(?<split6>[\\D]+)(?<date3>29))";
    private static final String ZERO_FILL_DATE_REGEX = "((?<year0>([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3}))(?<split1>[\\D]*)(((?<month0>(0[13578]|1[02]))(?<split2>[\\D]*)(?<date0>([12][0-9]|3[01]|0[1-9])))|((?<month1>(0[469]|11))(?<split3>[\\D]*)(?<date1>([12][0-9]|30|0[1-9])))|((?<month2>02)(?<split4>[\\D]*)(?<date2>([1][0-9]|2[0-8]|0[1-9])))))|((?<year1>(([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|1[26]|[2468][048]|[3579][26])00)))(?<split5>[\\D]*)(?<month3>02)(?<split6>[\\D]*)(?<date3>29))";
    private static final String ZERO_FILL_TIME_REGEX = "(?<hour>(0[0-9]|1[0-9]|2[0-4]|[0-9]))(((:|\u65f6|\u70b9|-|/)(?<minute>([0-5][0-9]|[0-9]))(((:|\u5206|-|/)(?<second>([0-5][0-9]|[0-9])))?))|((:|\u65f6|\u70b9)))";
    private static final String TIME_REGEX = "(?<hour>(1[0-9]|2[0-3]|[1-9]))(((:|\u65f6|\u70b9|-|/)(?<minute>[1-5][0-9]|[0-9])(((:|\u5206|-|/)(?<second>[1-5][0-9]|[0-9]))?))|(:|\u65f6|\u70b9))";
    private static final String DATE_SIMPLE_REGEX = "(?<year0>([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3}))(?<split1>[\u5e74|/|-]+)(((?<month0>(1[012]|0?[1-9])))?)(?<split2>[\u6708|/|-]+)(((?<date0>([12][0-9]|3[01]|0?[1-9])))?)";
    private static final String TIME_MILLIS_FORMAT = "(1[\\d]{12})|([\\d]{9,12})";
    private static final String PM_FORMAT = "pm|PM|p.m|P.M|\u4e0b\u5348|[Aa]fternoon";
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECOND = "second";
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String DATE = "date";

    public static GregorianCalendar parse(String source) {
        GregorianCalendar gregorianCalendar;
        String[] step = source.split("[\\s]");
        if (step.length == 1) {
            if (PatternUtil.matches(TIME_MILLIS_FORMAT, source)) {
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTimeInMillis(Long.parseLong(source));
            } else {
                gregorianCalendar = DateUtil.parseDate(source);
                if (gregorianCalendar == null) {
                    GregorianCalendar time = DateUtil.parseTime(source);
                    DateUtil.parsePM(time, source);
                    return time;
                }
                List<String> list = PatternUtil.getMatched(ZERO_FILL_DATE_REGEX, source);
                if (ObjectUtil.isEmpty(list)) {
                    list = PatternUtil.getMatched(DATE_REGEX, source);
                }
                if (ObjectUtil.isEmpty(list)) {
                    list = PatternUtil.getMatched(DATE_SIMPLE_REGEX, source);
                }
                for (String node : list) {
                    source = source.replace(node, "");
                }
                GregorianCalendar time = DateUtil.parseTime(source);
                if (time != null) {
                    gregorianCalendar.set(gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), time.get(11), time.get(12), time.get(13));
                }
            }
        } else if (step.length > 1) {
            gregorianCalendar = new GregorianCalendar();
            boolean haveDate = false;
            for (String s : step) {
                GregorianCalendar date;
                if (!haveDate && (date = DateUtil.parseDate(s)) != null) {
                    gregorianCalendar.set(date.get(1), date.get(2), date.get(5));
                    haveDate = true;
                    continue;
                }
                GregorianCalendar time = DateUtil.parseTime(s);
                if (time == null) continue;
                gregorianCalendar.set(11, time.get(11));
                gregorianCalendar.set(12, time.get(12));
                gregorianCalendar.set(13, time.get(13));
            }
        } else {
            return null;
        }
        DateUtil.parsePM(gregorianCalendar, source);
        return gregorianCalendar;
    }

    public static GregorianCalendar parseTime(String source) {
        Map<String, String> list = PatternUtil.getGroups(ZERO_FILL_TIME_REGEX, source);
        if (list == null) {
            list = PatternUtil.getGroups(TIME_REGEX, source);
        }
        if (list != null) {
            int hourOfDay = 0;
            int minute = 0;
            int second = 0;
            for (Map.Entry<String, String> entry : list.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getKey().startsWith(HOUR)) {
                    hourOfDay = Integer.parseInt(entry.getValue());
                    continue;
                }
                if (entry.getKey().startsWith(MINUTE)) {
                    minute = Integer.parseInt(entry.getValue());
                    continue;
                }
                if (!entry.getKey().startsWith(SECOND)) continue;
                second = Integer.parseInt(entry.getValue());
            }
            return new GregorianCalendar(0, 0, 0, hourOfDay, minute, second);
        }
        return null;
    }

    private static void parsePM(GregorianCalendar gregorianCalendar, String source) {
        if (gregorianCalendar == null) {
            return;
        }
        int hourOfDay = gregorianCalendar.get(11);
        if (hourOfDay <= 12 && PatternUtil.find(PM_FORMAT, source)) {
            gregorianCalendar.set(11, hourOfDay + 12);
        }
    }

    public static GregorianCalendar parseDate(String source) {
        Map<String, String> list = PatternUtil.getGroups(ZERO_FILL_DATE_REGEX, source);
        if (list == null) {
            list = PatternUtil.getGroups(DATE_REGEX, source);
        }
        if (list == null) {
            list = PatternUtil.getGroups(DATE_SIMPLE_REGEX, source);
        }
        if (list != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.set(2, 0);
            gregorianCalendar.set(5, 1);
            Stream<Map.Entry> stream = list.entrySet().stream().filter(e -> e.getValue() != null);
            stream.forEach(e -> {
                if (((String)e.getKey()).startsWith(YEAR)) {
                    gregorianCalendar.set(1, Integer.parseInt((String)e.getValue()));
                } else if (((String)e.getKey()).startsWith(MONTH)) {
                    gregorianCalendar.set(2, Integer.parseInt((String)e.getValue()) - 1);
                } else if (((String)e.getKey()).startsWith(DATE)) {
                    gregorianCalendar.set(5, Integer.parseInt((String)e.getValue()));
                }
            });
            return gregorianCalendar;
        }
        return null;
    }
}

