/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.command;

import java.util.stream.Stream;

public enum OSEnum {
    Any("any"),
    Linux("linux"),
    Mac_OS("mac", "os"),
    Mac_OS_X("mac", "OS", "X"),
    Windows("windows"),
    OS2("os/2"),
    Solaris("solaris"),
    SunOS("sunos"),
    MPEiX("mpe/ix"),
    HP_UX("hp-ux"),
    AIX("aix"),
    OS390("os/390"),
    FreeBSD("freebsd"),
    Irix("irix"),
    Digital_Unix("digital", "unix"),
    NetWare_411("netware"),
    OSF1("osf1"),
    OpenVMS("openvms"),
    Others("others");

    private String[] desc;

    private OSEnum(String ... desc) {
        this.desc = desc;
    }

    public static OSEnum currentOS() {
        OSEnum[] oses;
        String osDesc = System.getProperty("os.name").toLowerCase();
        for (OSEnum os : oses = OSEnum.values()) {
            String[] desc = os.getDesc();
            boolean is = Stream.of(desc).anyMatch(osDesc::contains);
            if (!is) continue;
            return os;
        }
        return Others;
    }

    public String[] getDesc() {
        return this.desc;
    }
}

