/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import cloud.agileframework.common.util.array.ArrayUtil;
import cloud.agileframework.common.util.clazz.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class TypeReference<T> {
    private final Type type;
    private Type[] typeArguments;

    public TypeReference() {
        Type genType = this.getClass().getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        this.type = params[0];
        this.typeArguments = ParameterizedType.class.isAssignableFrom(this.type.getClass()) ? ((ParameterizedType)this.type).getActualTypeArguments() : null;
    }

    public TypeReference(Type type) {
        this.type = type;
        this.typeArguments = ParameterizedType.class.isAssignableFrom(type.getClass()) ? ((ParameterizedType)type).getActualTypeArguments() : null;
    }

    public boolean hasParameterizedType() {
        return ParameterizedType.class.isAssignableFrom(this.type.getClass());
    }

    public Type getParameterizedType(int index) {
        if (this.typeArguments != null && this.typeArguments.length > index) {
            return this.typeArguments[index];
        }
        return null;
    }

    public void addParameterizedType(Type type) {
        this.typeArguments = (Type[])ArrayUtil.add((Object[])this.typeArguments, (Object)type);
    }

    public void replaceParameterizedType(int index, Type type) {
        this.typeArguments = (Type[])ArrayUtil.insert((int)index, (Object[])ArrayUtil.remove((Object[])this.typeArguments, (int)index), (Object[])new Type[]{type});
    }

    public boolean isAssignableFrom(Class clazz) {
        Class sourceClass = this.getWrapperClass();
        return sourceClass.isAssignableFrom(clazz);
    }

    public boolean isExtendsFrom(Class<?> clazz) {
        Class sourceClass = this.getWrapperClass();
        return clazz.isAssignableFrom(sourceClass);
    }

    public boolean isEnum() {
        Class sourceClass = this.getWrapperClass();
        return sourceClass.isEnum();
    }

    public boolean isArray() {
        Class sourceClass = this.getWrapperClass();
        return sourceClass.isArray();
    }

    public boolean isWrapOrPrimitive() {
        Class sourceClass = this.getWrapperClass();
        return ClassUtil.isWrapOrPrimitive(sourceClass);
    }

    public Type getType() {
        return this.type;
    }

    public Class getWrapperClass() {
        if (this.type instanceof Class) {
            return (Class)this.type;
        }
        if (this.type instanceof ParameterizedTypeImpl) {
            return ((ParameterizedTypeImpl)this.type).getRawType();
        }
        return Object.class;
    }

    public Constructor<T> getConstruct(Class<?> ... parameterTypes) {
        return ClassUtil.getConstructor(this.getWrapperClass(), parameterTypes);
    }
}

