/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.common.util.clazz;

import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.pattern.PatternUtil;
import cloud.agileframework.common.util.string.StringUtil;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;

public class ClassUtil
extends ClassUtils {
    public static Set<Field> getAllField(Class clazz) {
        HashSet set = Sets.newHashSet();
        ClassUtil.extractFieldRecursion(clazz, set);
        set.forEach(field -> field.setAccessible(true));
        return set;
    }

    private static void extractFieldRecursion(Class clazz, Set<Field> set) {
        Field[] selfFields = clazz.getDeclaredFields();
        Field[] extendFields = clazz.getFields();
        set.addAll(Arrays.asList(selfFields));
        set.addAll(Arrays.asList(extendFields));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ClassUtil.extractFieldRecursion(superClass, set);
        }
    }

    public static Set<Method> getAllMethod(Class clazz) {
        HashSet set = Sets.newHashSet();
        ClassUtil.extractMethodRecursion(clazz, set);
        set.forEach(method -> method.setAccessible(true));
        return set;
    }

    private static void extractMethodRecursion(Class clazz, Set<Method> set) {
        Method[] selfMethods = clazz.getDeclaredMethods();
        Method[] extendMethods = clazz.getMethods();
        set.addAll(Arrays.asList(selfMethods));
        set.addAll(Arrays.asList(extendMethods));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            ClassUtil.extractMethodRecursion(superClass, set);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        if (paramTypes != null) {
            try {
                return clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Expected method not found: " + ex);
            }
        }
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return (Method)candidates.iterator().next();
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Expected method not found: " + clazz.getName() + '.' + methodName);
        }
        throw new IllegalStateException("No unique method found: " + clazz.getName() + '.' + methodName);
    }

    public static Field getField(Class clazz, String fieldName) {
        Set<Field> fields = ClassUtil.getAllField(clazz);
        HashMap<String, Field> targetFields = new HashMap<String, Field>(1);
        String targetFieldName = StringUtil.camelToMatchesRegex(fieldName);
        for (Field field : fields) {
            if (!PatternUtil.matches(targetFieldName, field.getName(), 2)) continue;
            field.setAccessible(true);
            targetFields.put(field.getName(), field);
        }
        if (targetFields.size() == 0) {
            return null;
        }
        if (targetFields.containsKey(fieldName)) {
            return (Field)targetFields.get(fieldName);
        }
        return (Field)targetFields.values().iterator().next();
    }

    public static boolean isWrapOrPrimitive(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        try {
            if (((Class)clazz.getDeclaredField("TYPE").get(null)).isPrimitive()) {
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return false;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<T> constructor = null;
        try {
            constructor = parameterTypes.length > 0 ? clazz.getConstructor(parameterTypes) : clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return constructor;
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            try {
                Method method = Class.class.getDeclaredMethod("privateGetDeclaredConstructors", Boolean.TYPE);
                method.setAccessible(true);
                Constructor[] constructors = (Constructor[])method.invoke(clazz, false);
                if (constructors.length > 0) {
                    Constructor privateConstructor = constructors[0];
                    privateConstructor.setAccessible(true);
                    return privateConstructor.newInstance(new Object[0]);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public static boolean isAssignableFrom(Class<?> clazz, Class<?> other) {
        return clazz.isAssignableFrom(other);
    }

    public static boolean isExtendsFrom(Class<?> clazz, Class<?> other) {
        return other.isAssignableFrom(clazz);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static Method getMethod(Class clazz, String fieldName) {
        Set<Method> methods = ClassUtil.getAllMethod(clazz);
        for (Method method : methods) {
            if (!method.getName().equals(fieldName)) continue;
            return method;
        }
        return null;
    }

    public static <A extends Annotation> Set<Target<A>> getAllFieldAnnotation(Class<?> clazz, Class<A> annotationClass) {
        Set<Field> fields = ClassUtil.getAllField(clazz);
        HashSet<Target<A>> set = new HashSet<Target<A>>();
        for (Field field : fields) {
            A annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            set.add(new Target<A>(field, annotation));
        }
        return set;
    }

    public static <A extends Annotation> Set<Target<A>> getAllMethodAnnotation(Class<?> clazz, Class<A> annotationClass) {
        Set<Method> fields = ClassUtil.getAllMethod(clazz);
        HashSet<Target<A>> set = new HashSet<Target<A>>();
        for (Method method : fields) {
            A annotation = method.getAnnotation(annotationClass);
            if (annotation == null) continue;
            set.add(new Target<A>(method, annotation));
        }
        return set;
    }

    public static <A extends Annotation> Set<Target<A>> getAllEntityAnnotation(Class<?> clazz, Class<A> annotation) {
        Set<Target<A>> fieldAnnotation = ClassUtil.getAllFieldAnnotation(clazz, annotation);
        Set<Target<A>> methodAnnotation = ClassUtil.getAllMethodAnnotation(clazz, annotation);
        for (Target<A> target : methodAnnotation) {
            String name = target.getMember().getName();
            if (!name.startsWith("get")) continue;
            int length = 3;
            Field targetField = ClassUtil.getField(clazz, StringUtil.toLowerName(name.substring(3)));
            fieldAnnotation.add(new Target<A>(targetField, target.getAnnotation()));
        }
        return fieldAnnotation;
    }

    public static Boolean compareClass(Object source, Object target) {
        return ObjectUtil.isEmpty((Object)source) ? ObjectUtil.isEmpty((Object)target) : !ObjectUtil.isEmpty((Object)target) && source.getClass() == target.getClass();
    }

    public static class Target<A extends Annotation> {
        private Member member;
        private A annotation;

        public Member getMember() {
            return this.member;
        }

        public A getAnnotation() {
            return this.annotation;
        }

        public void setMember(Member member) {
            this.member = member;
        }

        public void setAnnotation(A annotation) {
            this.annotation = annotation;
        }

        public String toString() {
            return "ClassUtil.Target(member=" + this.getMember() + ", annotation=" + this.getAnnotation() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Target)) {
                return false;
            }
            Target other = (Target)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Member this$member = this.getMember();
            Member other$member = other.getMember();
            if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
                return false;
            }
            A this$annotation = this.getAnnotation();
            A other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Target;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Member $member = this.getMember();
            result = result * 59 + ($member == null ? 43 : $member.hashCode());
            A $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        public Target(Member member, A annotation) {
            this.member = member;
            this.annotation = annotation;
        }
    }
}

