/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.task.controller;

import cloud.agileframework.task.Task;
import cloud.agileframework.task.TaskManager;
import cloud.agileframework.task.TaskService;
import cloud.agileframework.task.controller.CustomTask;
import cloud.agileframework.task.exception.NotFoundTaskException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Controller
public class TaskController {
    private final Logger logger = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private TaskManager taskManager;
    @Autowired
    private TaskService taskService;

    public void hello(String id) {
        this.logger.info("Hello World!");
        System.out.println(id);
    }

    @PostMapping(value={"/task"})
    public void add(@RequestBody CustomTask task, HttpServletResponse response) throws NoSuchMethodException, NotFoundTaskException, IOException {
        this.taskManager.updateTask(task);
        this.response(true, null, response);
    }

    @DeleteMapping(value={"/task/{taskCode}"})
    public void add(@PathVariable Long taskCode, HttpServletResponse response) throws NotFoundTaskException, IOException {
        this.taskManager.removeTask(taskCode);
        this.response(true, null, response);
    }

    @PutMapping(value={"/task"})
    public void update(@RequestBody CustomTask task, HttpServletResponse response) throws NoSuchMethodException, NotFoundTaskException, IOException {
        this.taskManager.updateTask(task);
        this.response(true, null, response);
    }

    @GetMapping(value={"/task/{taskCode}"})
    public void query(@PathVariable Long taskCode, HttpServletResponse response) throws IOException {
        Optional<Task> taskOptional = this.taskService.getTask().stream().filter(task -> task.getCode().equals(taskCode)).findFirst();
        if (taskOptional.isPresent()) {
            this.response(true, taskOptional.get(), response);
        } else {
            this.response(false, null, response);
        }
    }

    @GetMapping(value={"/task"})
    public void query(HttpServletResponse response) throws IOException {
        this.response(true, this.taskService.getTask(), response);
    }

    @PutMapping(value={"/task/{taskCode}/{status}"})
    public void enable(@PathVariable Long taskCode, @PathVariable boolean status, HttpServletResponse response) throws IOException, NotFoundTaskException {
        if (status) {
            this.taskManager.startTask(taskCode);
        } else {
            this.taskManager.stopTask(taskCode);
        }
        this.response(true, null, response);
    }

    private void response(boolean isSuccess, Object context, HttpServletResponse response) throws IOException {
        JSONObject json = new JSONObject();
        if (isSuccess) {
            response.setStatus(HttpStatus.OK.value());
            json.put((Object)"status", (Object)"success");
        } else {
            response.setStatus(HttpStatus.BAD_REQUEST.value());
            json.put((Object)"status", (Object)"fail");
        }
        json.put((Object)"context", context);
        response.getWriter().print(json.toJSONString(new JSONWriter.Feature[0]));
    }
}

