/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.task;

import cloud.agileframework.task.FixedDelayActuator;
import cloud.agileframework.task.FixedRateActuator;
import cloud.agileframework.task.InstantActuator;
import cloud.agileframework.task.Task;
import cloud.agileframework.task.TaskActuatorInterface;
import cloud.agileframework.task.TaskInfo;
import cloud.agileframework.task.TaskJob;
import cloud.agileframework.task.TaskProxy;
import cloud.agileframework.task.TaskService;
import cloud.agileframework.task.TriggerActuator;
import cloud.agileframework.task.exception.NotFoundTaskException;
import cloud.agileframework.task.factory.TaskThreadFactory;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.data.util.ProxyUtils;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Order(value=-2147483647)
public class TaskManager
implements ApplicationRunner {
    public static final String FIXED_DELAY = "fixedDelay:";
    public static final String FIXED_RATE = "fixedRate:";
    private final Logger logger = LoggerFactory.getLogger(TaskManager.class);
    private static final String NO_SUCH_TARGETS_ERROR = "\u4efb\u52a1:[{}]\u4efb\u52a1\u672a\u7ed1\u5b9a\u4efb\u4f55\u6267\u884c\u65b9\u6cd5\u6570\u636e\uff0c\u65e0\u6cd5\u52a0\u8f7d\u8be5\u4efb\u52a1";
    private static final String NO_SUCH_CRON_ERROR = "\u4efb\u52a1:[{}]\u5b9a\u65f6\u4efb\u52a1\u672a\u914d\u7f6e\u65f6\u95f4\u8868\u8fbe\u5f0f\uff0c\u65e0\u6cd5\u52a0\u8f7d\u8be5\u4efb\u52a1";
    private static final String INIT_TASK = "\u4efb\u52a1:[{}][\u5b8c\u6210\u521d\u59cb\u5316][\u4e0b\u6b21\u6267\u884c\u65f6\u95f4{}]";
    private static final String INIT_TASKS = "\u68c0\u6d4b\u51fa\u5b9a\u65f6\u4efb\u52a1%s\u6761";
    private static final Map<Long, TaskInfo> TASK_INFO_MAP = new HashMap<Long, TaskInfo>();
    private static final Map<String, Method> API_BASE_MAP = new HashMap<String, Method>();
    private final ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
    private final ApplicationContext applicationContext;
    private final TaskService taskService;
    private final TaskProxy taskProxy;

    public TaskManager(ApplicationContext applicationContext, TaskService taskService, TaskProxy taskProxy) {
        this.applicationContext = applicationContext;
        this.taskService = taskService;
        this.taskProxy = taskProxy;
        this.threadPoolTaskScheduler.setThreadFactory((ThreadFactory)new TaskThreadFactory("\u5b9a\u65f6\u4efb\u52a1"));
        this.threadPoolTaskScheduler.initialize();
        this.threadPoolTaskScheduler.setPoolSize(10);
    }

    public void run(ApplicationArguments args) {
        this.threadPoolTaskScheduler.execute(() -> {
            this.initMethodCache();
            List<? extends Task> list = this.taskService.getTask();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format(INIT_TASKS, list.size()));
            }
            for (Task task : list) {
                if (ObjectUtils.isEmpty((Object)task.getMethod())) {
                    this.logger.error(NO_SUCH_TARGETS_ERROR, (Object)task.getCode());
                    continue;
                }
                try {
                    this.updateTask(task);
                }
                catch (NotFoundTaskException | NoSuchMethodException e) {
                    this.logger.error("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
                }
            }
        });
    }

    private void initMethodCache() {
        String[] beans;
        for (String beanName : beans = this.applicationContext.getBeanDefinitionNames()) {
            Method[] methods;
            Object bean = this.applicationContext.getBean(beanName);
            Class clazz = ProxyUtils.getUserClass((Object)bean);
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (method.getParameterCount() > 1) continue;
                API_BASE_MAP.put(method.toGenericString(), method);
            }
        }
    }

    public static Method getApi(String generic) throws NoSuchMethodException {
        Method method = API_BASE_MAP.get(generic);
        if (method == null) {
            throw new NoSuchMethodException(generic);
        }
        return method;
    }

    public void updateTask(Task task) throws NotFoundTaskException, NoSuchMethodException {
        String cronString;
        if (API_BASE_MAP.isEmpty()) {
            this.initMethodCache();
        }
        if (ObjectUtils.isEmpty((Object)task.getMethod())) {
            this.logger.error(NO_SUCH_TARGETS_ERROR, (Object)task.getCode());
            return;
        }
        if (TASK_INFO_MAP.get(task.getCode()) != null) {
            this.removeTask(task.getCode());
        }
        if (StringUtils.isEmpty((Object)(cronString = task.getCron()))) {
            this.logger.error(NO_SUCH_CRON_ERROR, (Object)task.getCode());
            return;
        }
        String[] crones = cronString.split(";");
        ArrayList<TaskActuatorInterface> actuators = new ArrayList<TaskActuatorInterface>();
        TaskJob job = new TaskJob(this.taskService, this.taskProxy, task);
        for (String cron : crones) {
            Instant instant;
            cron = cron.trim();
            ScheduledFuture scheduledFuture = null;
            if (NumberUtils.isCreatable((String)cron)) {
                long executeTime = NumberUtils.toLong((String)cron);
                if (executeTime <= System.currentTimeMillis()) continue;
                instant = Instant.ofEpochMilli(executeTime);
                if (task.getEnable() != null && task.getEnable().booleanValue()) {
                    scheduledFuture = this.threadPoolTaskScheduler.schedule((Runnable)job, instant);
                }
                actuators.add(new InstantActuator(scheduledFuture, instant, this.threadPoolTaskScheduler));
                continue;
            }
            if (cron.startsWith(FIXED_RATE)) {
                cron = cron.substring(FIXED_RATE.length());
                long executeTime = NumberUtils.toLong((String)cron);
                instant = Instant.ofEpochMilli(executeTime);
                if (task.getEnable() != null && task.getEnable().booleanValue()) {
                    scheduledFuture = this.threadPoolTaskScheduler.scheduleAtFixedRate((Runnable)job, executeTime);
                }
                actuators.add(new FixedRateActuator(scheduledFuture, instant, this.threadPoolTaskScheduler));
                continue;
            }
            if (cron.startsWith(FIXED_DELAY)) {
                cron = cron.substring(FIXED_DELAY.length());
                long executeTime = NumberUtils.toLong((String)cron);
                instant = Instant.ofEpochMilli(executeTime);
                if (task.getEnable() != null && task.getEnable().booleanValue()) {
                    scheduledFuture = this.threadPoolTaskScheduler.scheduleWithFixedDelay((Runnable)job, executeTime);
                }
                actuators.add(new FixedDelayActuator(scheduledFuture, instant, this.threadPoolTaskScheduler));
                continue;
            }
            CronTrigger trigger = new CronTrigger(cron);
            if (task.getEnable() != null && task.getEnable().booleanValue()) {
                scheduledFuture = this.threadPoolTaskScheduler.schedule((Runnable)job, (Trigger)trigger);
            }
            actuators.add(new TriggerActuator(scheduledFuture, (Trigger)trigger, this.threadPoolTaskScheduler));
        }
        TaskInfo taskInfo = new TaskInfo(actuators, job);
        TASK_INFO_MAP.put(task.getCode(), taskInfo);
        this.taskService.saveOrUpdate(task);
        if (taskInfo.nextExecutionTime() != null && this.logger.isDebugEnabled()) {
            this.logger.debug(INIT_TASK, (Object)task.getCode(), (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(taskInfo.nextExecutionTime()));
        }
    }

    public static Date nextExecutionTimeByTaskCode(Long taskCode) {
        TaskInfo taskInfo = TASK_INFO_MAP.get(taskCode);
        if (taskInfo != null) {
            return taskInfo.nextExecutionTime();
        }
        return null;
    }

    public static void reStart(Long taskCode) {
        TaskInfo taskInfo = TASK_INFO_MAP.get(taskCode);
        if (taskInfo != null) {
            taskInfo.start();
        }
    }

    public void removeTask(Long taskCode) throws NotFoundTaskException {
        if (TASK_INFO_MAP.containsKey(taskCode)) {
            this.stopTask(taskCode);
            TASK_INFO_MAP.remove(taskCode);
        }
        this.taskService.remove(taskCode);
    }

    public void stopTask(Long taskCode) throws NotFoundTaskException {
        TaskInfo taskInfo = TASK_INFO_MAP.get(taskCode);
        if (ObjectUtils.isEmpty((Object)taskInfo)) {
            throw new NotFoundTaskException(String.format("\u672a\u627e\u5230\u5b9a\u65f6\u4efb\u52a1[%s]", taskCode));
        }
        taskInfo.stop();
        this.taskService.unLock(taskInfo.getCode());
        this.taskService.enable(taskCode, false);
    }

    public void startTask(long taskCode) throws NotFoundTaskException {
        TaskInfo taskInfo = TASK_INFO_MAP.get(taskCode);
        if (ObjectUtils.isEmpty((Object)taskInfo)) {
            throw new NotFoundTaskException(String.format("\u672a\u627e\u5230\u4e3b\u952e\u4e3a%s\u7684\u5b9a\u65f6\u4efb\u52a1", taskCode));
        }
        taskInfo.start();
        this.taskService.enable(taskCode, true);
    }

    public void removeTaskByMethod(Method method) throws NotFoundTaskException {
        List tasks = this.taskService.getTask().stream().filter(n -> method.equals(n.getMethod())).collect(Collectors.toList());
        if (tasks.isEmpty()) {
            return;
        }
        for (Task task : tasks) {
            this.removeTask(task.getCode());
        }
    }
}

