/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.task;

import cloud.agileframework.task.RunDetail;
import cloud.agileframework.task.Task;
import cloud.agileframework.task.TaskManager;
import cloud.agileframework.task.TaskProxy;
import cloud.agileframework.task.TaskService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskJob
implements Runnable {
    static final String START_TASK = "\u4efb\u52a1:[{}][\u5f00\u59cb\u6267\u884c]";
    static final String NO_API_TASK = "\u4efb\u52a1:[%s][\u975e\u6cd5\u4efb\u52a1\uff0c\u672a\u7ed1\u5b9a\u4efb\u4f55api\u4fe1\u606f\uff0c\u4efb\u52a1\u7ed3\u675f]";
    static final String NO_SUCH_METHOD_TASK = "\u4efb\u52a1:[%s][\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u6267\u884c\u65b9\u6cd5%s]";
    static final String ILLEGAL_API_TASK = "\u4efb\u52a1:[%s][\u975e\u6cd5\u4efb\u52a1\uff0c\u5165\u53c2\u5927\u4e8e1\u4e2a\uff0c\u4efb\u52a1\u7ed3\u675f]";
    static final String EXCEPTION_API_TASK = "\u4efb\u52a1:[%s][\u4efb\u52a1\u5f02\u5e38]";
    static final String RUN_TASK_API = "\u4efb\u52a1:[{}][\u6267\u884c]";
    static final String EXCEPTION_RUN_TASK_API = "\u4efb\u52a1:[%s][\u4efb\u52a1\u5f02\u5e38]";
    static final String END_TASK = "\u4efb\u52a1:[{}][\u4efb\u52a1\u5b8c\u6210]";
    static final String NEXT_TASK = "\u4efb\u52a1:[{}][\u4e0b\u6b21\u6267\u884c\u65f6\u95f4{}]";
    static final String LAST_TASK = "\u4efb\u52a1:[{}][\u672c\u6b21\u4e3a\u6700\u540e\u4e00\u6b21\u6267\u884c]";
    private final Logger logger = LoggerFactory.getLogger(TaskJob.class);
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final TaskService taskService;
    private final Task task;
    private final TaskProxy taskProxy;

    public TaskJob(TaskService taskService, TaskProxy taskProxy, Task task) {
        this.taskService = taskService;
        this.taskProxy = taskProxy;
        this.task = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TaskJob taskJob = this;
        synchronized (taskJob) {
            try {
                TaskManager.reStart(this.task.getCode());
                Date nextTime = TaskManager.nextExecutionTimeByTaskCode(this.getTask().getCode());
                if (this.getTask().getSync() != null && this.getTask().getSync().booleanValue()) {
                    if (this.taskService.setNxLock(this.getTask().getCode(), nextTime)) {
                        this.invoke();
                    }
                } else {
                    this.invoke();
                }
                if (nextTime == null) {
                    this.logger.info(LAST_TASK, (Object)this.getTask().getCode());
                } else {
                    this.logger.info(NEXT_TASK, (Object)this.getTask().getCode(), (Object)this.simpleDateFormat.format(nextTime));
                }
            }
            catch (Exception e) {
                this.logger.error(String.format("\u4efb\u52a1:[%s][\u4efb\u52a1\u5f02\u5e38]", this.getTask().getCode()), (Throwable)e);
            }
        }
    }

    public void invoke() {
        RunDetail runDetail = new RunDetail();
        runDetail.setTaskCode(this.task.getCode());
        runDetail.setStartTime(new Date());
        runDetail.setEnding(true);
        this.start(runDetail);
        this.running(runDetail);
        this.end(runDetail);
    }

    void exception(Throwable e, RunDetail runDetail) {
        runDetail.addLog(TaskJob.exceptionToString(e));
        runDetail.setEnding(false);
        if (this.logger.isErrorEnabled()) {
            this.logger.error(String.format("\u4efb\u52a1:[%s][\u4efb\u52a1\u5f02\u5e38]", runDetail.getTaskCode()), e);
        }
    }

    public static String exceptionToString(Throwable e) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            e.printStackTrace(pw);
        }
        return writer.toString();
    }

    void start(RunDetail runDetail) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(START_TASK, (Object)runDetail.getTaskCode());
        }
        if (this.taskService != null) {
            this.taskService.running(runDetail.getTaskCode());
        }
    }

    void end(RunDetail runDetail) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(END_TASK, (Object)runDetail.getTaskCode());
        }
        if (this.taskService != null) {
            runDetail.setEndTime(new Date());
            this.taskService.logging(runDetail);
            this.taskService.suspend(this.task.getCode());
        }
    }

    private void running(RunDetail runDetail) {
        Method method = this.task.getMethod();
        if (method == null) {
            String log = String.format(NO_SUCH_METHOD_TASK, this.task.getCode(), method);
            runDetail.addLog(log);
            this.logger.error(log);
            return;
        }
        String code = method.toGenericString();
        if (method.getParameterCount() > 1) {
            String log = String.format(ILLEGAL_API_TASK, code);
            runDetail.addLog(log);
            this.logger.error(String.format(log, code));
            return;
        }
        Optional.ofNullable(this.taskProxy).ifPresent(proxy -> {
            try {
                this.logger.debug(RUN_TASK_API, (Object)code);
                proxy.invoke(method, this.task.getArgument(), this.getTask());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.logger.error(String.format("\u4efb\u52a1:[%s][\u4efb\u52a1\u5f02\u5e38]", code), (Throwable)e);
                this.exception(e, runDetail);
            }
        });
    }

    public Task getTask() {
        return this.task;
    }
}

