/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.task;

import cloud.agileframework.task.TaskActuatorInterface;
import cloud.agileframework.task.TaskJob;
import java.util.Date;
import java.util.List;

public class TaskInfo {
    private final long code;
    private List<TaskActuatorInterface> actuators;
    private final TaskJob job;

    public TaskInfo(List<TaskActuatorInterface> actuators, TaskJob job) {
        this.code = job.getTask().getCode();
        this.actuators = actuators;
        this.job = job;
    }

    public void stop() {
        this.actuators.forEach(TaskActuatorInterface::cancel);
    }

    public synchronized void start() {
        this.actuators.forEach(n -> n.reStart(this.job));
        this.nextExecutionTime();
    }

    public long getCode() {
        return this.code;
    }

    public List<TaskActuatorInterface> getActuators() {
        return this.actuators;
    }

    public void setActuators(List<TaskActuatorInterface> actuators) {
        this.actuators = actuators;
    }

    public TaskJob getJob() {
        return this.job;
    }

    public Date nextExecutionTime() {
        Date nextExecutionTime = null;
        for (TaskActuatorInterface actuator : this.getActuators()) {
            Date nextTime = actuator.nextExecutionTime();
            if (nextTime == null || nextTime.getTime() <= System.currentTimeMillis()) continue;
            if (nextExecutionTime == null || nextTime.getTime() < nextExecutionTime.getTime()) {
                nextExecutionTime = actuator.nextExecutionTime();
                continue;
            }
            if (nextTime.getTime() != nextExecutionTime.getTime()) continue;
            actuator.cancel();
        }
        return nextExecutionTime;
    }
}

