/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.mybatis.config;

import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.mybatis.page.CustomConfiguration;
import cloud.agileframework.mybatis.page.MybatisInterceptor;
import com.alibaba.druid.DbType;
import com.alibaba.druid.util.JdbcUtils;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DataSource.class})
@AutoConfigureBefore(value={MybatisAutoConfiguration.class})
public class MyBatisAutoConfiguration {
    public MyBatisAutoConfiguration(MybatisProperties properties) {
        org.apache.ibatis.session.Configuration configuration = properties.getConfiguration();
        CustomConfiguration customConfiguration = new CustomConfiguration();
        if (configuration != null) {
            ObjectUtil.copyProperties((Object)configuration, (Object)((Object)customConfiguration), (String[])new String[]{"mapperRegistry", "typeHandlerRegistry"}, (ObjectUtil.ContainOrExclude)ObjectUtil.ContainOrExclude.EXCLUDE);
        }
        properties.setConfiguration((org.apache.ibatis.session.Configuration)customConfiguration);
    }

    @Bean
    Interceptor PageInterceptor(DataSourceProperties dataSourceProperties) {
        DbType dbtype = JdbcUtils.getDbTypeRaw((String)dataSourceProperties.getUrl(), (String)dataSourceProperties.getDriverClassName());
        MybatisInterceptor mybatisInterceptor = new MybatisInterceptor();
        mybatisInterceptor.setType(dbtype);
        return mybatisInterceptor;
    }
}

