/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.log.config;

import cloud.agileframework.log.LogFilter;
import cloud.agileframework.log.PrintLogProvider;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnProperty(value={"enabled"}, prefix="agile.log", matchIfMissing=true)
@Configuration
public class LoggerAutoConfiguration
implements WebMvcConfigurer {
    @Value(value="${agile.log.enabled:false}")
    private boolean enabled;

    @Bean
    @ConditionalOnClass(value={LogFilter.class})
    public FilterRegistrationBean<LogFilter> logFilter() {
        FilterRegistrationBean corsFilter = new FilterRegistrationBean();
        corsFilter.setFilter((Filter)new LogFilter());
        corsFilter.addUrlPatterns(new String[]{"/*"});
        corsFilter.addInitParameter("is", this.enabled ? "true" : "false");
        return corsFilter;
    }

    @Bean
    @Order
    public PrintLogProvider printLogProvider() {
        return new PrintLogProvider();
    }
}

