/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.log;

import java.util.Map;

public class ExecutionInfo {
    private static final String ANONYMOUS = "anonymous";
    private final String ip;
    private final String method;
    private final String url;
    private final String username;
    private final long startTime;
    private final long endTime;
    private final Map<String, Object> inParam;
    private final String outParam;
    private final Exception e;

    public ExecutionInfo(Builder builder) {
        this.ip = builder.ip;
        this.method = builder.method;
        this.url = builder.url;
        this.username = builder.username;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.inParam = builder.inParam;
        this.outParam = builder.outParam;
        this.e = builder.e;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIp() {
        return this.ip;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUrl() {
        return this.url;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getUsername() {
        return this.username == null ? ANONYMOUS : this.username;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<String, Object> getInParam() {
        return this.inParam;
    }

    public Exception getE() {
        return this.e;
    }

    public String getOutParam() {
        return this.outParam;
    }

    public String toString() {
        return "ExecutionInfo{ip='" + this.ip + '\'' + ", method='" + this.method + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", inParam=" + this.inParam + ", outParam='" + this.outParam + '\'' + ", e=" + this.e + '}';
    }

    public static class Builder {
        private String ip;
        private String method;
        private String url;
        private long startTime;
        private String username;
        private long endTime;
        private Map<String, Object> inParam;
        private String outParam;
        private Exception e;

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder inParam(Map<String, Object> inParam) {
            this.inParam = inParam;
            return this;
        }

        public Builder outParam(String outParam) {
            this.outParam = outParam;
            return this;
        }

        public Builder e(Exception e) {
            this.e = e;
            return this;
        }

        public String getIp() {
            return this.ip;
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getUsername() {
            return this.username;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public Map<String, Object> getInParam() {
            return this.inParam;
        }

        public String getOutParam() {
            return this.outParam;
        }

        public Exception getE() {
            return this.e;
        }

        public ExecutionInfo build() {
            return new ExecutionInfo(this);
        }
    }
}

