/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.log.config;

import cloud.agileframework.common.util.properties.PropertiesUtil;
import cloud.agileframework.log.LogFilter;
import cloud.agileframework.log.PrintLogProvider;
import cloud.agileframework.log.RecordOperationManager;
import cloud.agileframework.log.RecordOperationProvider;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnProperty(value={"enabled"}, prefix="agile.log")
@Configuration
public class LoggerAutoConfiguration
implements WebMvcConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Bean
    @ConditionalOnClass(value={LogFilter.class})
    public FilterRegistrationBean<LogFilter> logFilter() {
        FilterRegistrationBean corsFilter = new FilterRegistrationBean();
        corsFilter.setFilter((Filter)new LogFilter());
        corsFilter.addUrlPatterns(new String[]{"/*"});
        corsFilter.addInitParameter("is", (String)PropertiesUtil.getProperty((String)"agile.log.enabled", String.class, (String)"false"));
        return corsFilter;
    }

    @Bean
    @Order
    public PrintLogProvider printLogProvider() {
        return new PrintLogProvider();
    }

    @Bean
    @Order(value=1)
    @ConditionalOnProperty(value={"enabled"}, prefix="agile.log.operation")
    public RecordOperationProvider recordOperationProvider() {
        return new RecordOperationProvider();
    }

    @Bean
    @ConditionalOnMissingBean(value={RecordOperationManager.class})
    public RecordOperationManager recordOperationManager() {
        return (handlerMethod, executionInfo) -> this.logger.warn("not fount bean of RecordOperationManager");
    }
}

