/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.log;

import cloud.agileframework.log.ExecutionInfo;
import cloud.agileframework.log.ExecutionObjectProvider;
import cloud.agileframework.spring.util.BeanUtil;
import cloud.agileframework.spring.util.RequestWrapper;
import cloud.agileframework.spring.util.SecurityUtil;
import cloud.agileframework.spring.util.ServletUtil;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.web.filter.AbstractRequestLoggingFilter;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

public class LogFilter
extends AbstractRequestLoggingFilter {
    protected static final String AGILE_BUSINESS_LOG = "$AGILE_BUSINESS_LOG";
    private String is;

    public String getIs() {
        return this.is;
    }

    public void setIs(String is) {
        this.is = is;
    }

    protected boolean shouldLog(HttpServletRequest request) {
        return "true".equalsIgnoreCase(this.is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean shouldLog = this.shouldLog(request);
        if (!shouldLog) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        boolean isFirstRequest = !this.isAsyncDispatch(request);
        HttpServletRequest requestToUse = request;
        if (isFirstRequest && !(request instanceof RequestWrapper)) {
            requestToUse = new RequestWrapper(request);
            this.beforeRequest((RequestWrapper)requestToUse);
        }
        HttpServletResponse responseToUse = this.init(response);
        try {
            filterChain.doFilter((ServletRequest)requestToUse, (ServletResponse)responseToUse);
        }
        finally {
            ContentCachingResponseWrapper nativeResponse;
            if (!this.isAsyncStarted(request)) {
                this.afterRequest(requestToUse, responseToUse);
            }
            if ((nativeResponse = (ContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)responseToUse, ContentCachingResponseWrapper.class)) != null) {
                nativeResponse.copyBodyToResponse();
            }
        }
    }

    private HttpServletResponse init(HttpServletResponse response) {
        ContentCachingResponseWrapper temp = (ContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class);
        if (temp == null) {
            return new ContentCachingResponseWrapper(response);
        }
        return response;
    }

    protected void beforeRequest(RequestWrapper request) {
        if ((request = (RequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, RequestWrapper.class)) != null) {
            request.setAttribute(AGILE_BUSINESS_LOG, (Object)ExecutionInfo.builder().ip(ServletUtil.getRequestIP((HttpServletRequest)request)).url(request.getMethod() + ":" + request.getRequestURI()).inParam(request.getInParam()).startTime(System.currentTimeMillis()));
        }
    }

    protected void afterRequest(HttpServletRequest request, HttpServletResponse response) {
        Object currentInfo = request.getAttribute(AGILE_BUSINESS_LOG);
        if (!(currentInfo instanceof ExecutionInfo.Builder)) {
            return;
        }
        ContentCachingResponseWrapper contentCachingResponseWrapper = (ContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class);
        if (contentCachingResponseWrapper != null) {
            ExecutionInfo info = ((ExecutionInfo.Builder)currentInfo).outParam(new String(contentCachingResponseWrapper.getContentAsByteArray())).endTime(System.currentTimeMillis()).username(SecurityUtil.currentUsername()).build();
            ObjectProvider provider = BeanUtil.getApplicationContext().getBeanProvider(ExecutionObjectProvider.class);
            provider.orderedStream().forEach(s -> s.pass(info));
        }
    }

    protected void beforeRequest(HttpServletRequest request, String message) {
    }

    protected void afterRequest(HttpServletRequest request, String message) {
    }
}

