/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.log;

import java.util.Map;

public class ExecutionInfo {
    private static final String ANONYMOUS = "anonymous";
    private final String ip;
    private final String url;
    private final String username;
    private final long startTime;
    private final long endTime;
    private final Map<String, Object> inParam;
    private final String outParam;

    public ExecutionInfo(Builder builder) {
        this.ip = builder.ip;
        this.url = builder.url;
        this.username = builder.username;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.inParam = builder.inParam;
        this.outParam = builder.outParam;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIp() {
        return this.ip;
    }

    public String getUrl() {
        return this.url;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getUsername() {
        return this.username == null ? ANONYMOUS : this.username;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Map<String, Object> getInParam() {
        return this.inParam;
    }

    public String getOutParam() {
        return this.outParam;
    }

    public String toString() {
        return "ExecutionInfo{ip='" + this.ip + '\'' + ", url='" + this.url + '\'' + ", username='" + this.username + '\'' + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", inParam=" + this.inParam + ", outParam='" + this.outParam + '\'' + '}';
    }

    public static class Builder {
        private String ip;
        private String url;
        private long startTime;
        private String username;
        private long endTime;
        private Map<String, Object> inParam;
        private String outParam;

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder inParam(Map<String, Object> inParam) {
            this.inParam = inParam;
            return this;
        }

        public Builder outParam(String outParam) {
            this.outParam = outParam;
            return this;
        }

        public String getIp() {
            return this.ip;
        }

        public String getUrl() {
            return this.url;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String getUsername() {
            return this.username;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public Map<String, Object> getInParam() {
            return this.inParam;
        }

        public String getOutParam() {
            return this.outParam;
        }

        public ExecutionInfo build() {
            return new ExecutionInfo(this);
        }
    }
}

