/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.jpa.dao;

import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.collection.SortInfo;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.data.common.dao.BaseDao;
import cloud.agileframework.data.common.dao.ColumnName;
import cloud.agileframework.data.common.dictionary.DataExtendManager;
import cloud.agileframework.sql.SqlUtil;
import com.alibaba.druid.DbType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.Table;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Type;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Id;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;

public class Dao
extends HibernateDaoSupport
implements BaseDao {
    private static final Map<Class<?>, SimpleJpaRepository> REPOSITORY_CACHE = new HashMap();
    private final DbType dbType;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DataExtendManager dictionaryManager;

    public Dao(DbType dbType) {
        this.dbType = dbType;
    }

    private static boolean canCastClass(Class<?> clazz) {
        if (ClassUtil.isWrapOrPrimitive(clazz)) {
            return true;
        }
        return String.class == clazz || BigDecimal.class == clazz || Date.class == clazz || BigInteger.class == clazz || StringBuilder.class == clazz || StringBuffer.class == clazz || Timestamp.class == clazz || Time.class == clazz;
    }

    private static <T> void sort(List<T> list, String property) {
        list.sort((o1, o2) -> {
            try {
                if (Map.class.isAssignableFrom(o1.getClass())) {
                    return String.valueOf(((Map)o1).get(property)).compareTo(String.valueOf(((Map)o2).get(property)));
                }
                Class<?> clazz = o1.getClass();
                Field field = ClassInfo.getCache(clazz).getField(property);
                return String.valueOf(field.get(o1)).compareTo(String.valueOf(field.get(o2)));
            }
            catch (IllegalAccessException var5) {
                var5.printStackTrace();
                return 0;
            }
        });
    }

    private static <T> void sort(List<T> list, SortInfo ... sortInfos) {
        if (sortInfos == null || sortInfos.length == 0) {
            return;
        }
        list.sort((o1, o2) -> {
            try {
                SortInfo sort;
                String property;
                int v;
                SortInfo[] sortInfoArray = sortInfos;
                int n = sortInfoArray.length;
                for (int i = 0; i < n && (v = Dao.compare(o1, o2, property = (sort = sortInfoArray[i]).getProperty(), sort.isSort())) == 0; ++i) {
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return 0;
        });
    }

    private static <T> int compare(T o1, T o2, String property, boolean sort) throws IllegalAccessException {
        int result = 0;
        if (Map.class.isAssignableFrom(o1.getClass())) {
            result = String.valueOf(((Map)o1).get(property)).compareTo(String.valueOf(((Map)o2).get(property)));
        } else {
            Class<?> clazz = o1.getClass();
            Field field = ClassInfo.getCache(clazz).getField(property);
            result = String.valueOf(field.get(o1)).compareTo(String.valueOf(field.get(o2)));
        }
        return sort ? result : -result;
    }

    public DataExtendManager dictionaryManager() {
        return this.dictionaryManager;
    }

    public <T, ID> SimpleJpaRepository<T, ID> getRepository(Class<T> tableClass) {
        SimpleJpaRepository repository = REPOSITORY_CACHE.get(tableClass);
        if (ObjectUtils.isEmpty((Object)repository)) {
            repository = new SimpleJpaRepository(tableClass, this.getEntityManager());
            REPOSITORY_CACHE.put(tableClass, repository);
        }
        return repository;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public <T> void save(T o) {
        this.getEntityManager().persist(o);
    }

    public Connection getConnection() {
        return ((SessionImplementor)this.getEntityManager().unwrap(SessionImplementor.class)).connection();
    }

    public <T> boolean contains(T o) {
        return this.getEntityManager().contains(o);
    }

    public <T> T saveOrUpdate(T o) {
        Object e;
        boolean save = true;
        Object id = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(o);
        if (id != null) {
            Object old = this.getEntityManager().find(o.getClass(), id);
            boolean bl = save = old == null;
        }
        if (save) {
            SimpleJpaRepository repository = this.getRepository(o.getClass());
            e = repository.save(o);
        } else {
            e = this.getEntityManager().merge(o);
        }
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public <T> T saveAndReturn(T o, boolean isFlush) {
        Class<?> clazz = o.getClass();
        Object e = isFlush ? this.getRepository(clazz).saveAndFlush(o) : this.getRepository(clazz).save(o);
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public void flush(Class<?> tableClass) {
        this.getRepository(tableClass).flush();
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void refresh(Object o) {
        this.getEntityManager().refresh(o);
    }

    public <T> boolean update(T o) {
        Object id = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(o);
        Object old = this.getEntityManager().find(o.getClass(), id);
        if (old == null) {
            return false;
        }
        Object e = this.getEntityManager().merge(o);
        this.dictionaryManager.cover(e);
        return true;
    }

    public <T> T updateOfNotNull(T o) {
        Object id = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(o);
        Object old = this.getEntityManager().find(o.getClass(), id);
        ObjectUtil.copyProperties(o, (Object)old, (ObjectUtil.Compare)ObjectUtil.Compare.DIFF_SOURCE_NOT_NULL);
        Object e = this.getEntityManager().merge(old);
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public <T> void deleteAllInBatch(Class<T> tableClass) {
        this.getRepository(tableClass).deleteAllInBatch();
    }

    public <T> T findOne(Class<T> clazz, Object id) {
        Object e = this.getEntityManager().find(clazz, this.toIdType(clazz, id));
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public <T> T findOne(T object) {
        Example example = Example.of(object);
        Class<?> clazz = object.getClass();
        T e = this.getRepository(clazz).findOne(example).orElse(null);
        this.dictionaryManager.cover(e);
        return e;
    }

    public <T> T findOne(T object, ExampleMatcher matcher) {
        Class<?> clazz = object.getClass();
        T e = this.getRepository(clazz).findOne(Example.of(object, (ExampleMatcher)matcher)).orElse(null);
        this.dictionaryManager.cover(e);
        return e;
    }

    public <T> T findOne(String sql, Class<T> clazz, Object ... parameters) {
        Query query = this.creatQuery(false, sql, parameters);
        if (!Dao.canCastClass(clazz)) {
            this.queryCoverMap(query);
            Map o = (Map)this.getSingleResult(query, sql);
            if (Map.class.isAssignableFrom(clazz)) {
                return (T)o;
            }
            Object e = ObjectUtil.to((Object)o, (TypeReference)new TypeReference(clazz));
            this.dictionaryManager.cover(e);
            return (T)e;
        }
        Object o = this.getSingleResult(query, sql);
        return (T)ObjectUtil.to((Object)o, (TypeReference)new TypeReference(clazz));
    }

    public <T> List<T> findAll(T object) {
        return this.findAll(object, Sort.unsorted());
    }

    public <T> List<T> findAll(T object, Sort sort) {
        return this.findAll(object, ExampleMatcher.matching(), sort);
    }

    public <T> List<T> findAll(T object, ExampleMatcher matcher, Sort sort) {
        Example example = Example.of(object, (ExampleMatcher)matcher);
        Class<?> clazz = object.getClass();
        List result = this.getRepository(clazz).findAll(example, sort);
        this.dictionaryManager.cover((Object)result);
        return result;
    }

    public <T> Page<T> page(T object, int page, int size) {
        return this.page(object, page, size, Sort.unsorted());
    }

    public <T> Page<T> page(T object, ExampleMatcher matcher, int page, int size) {
        return this.page(object, matcher, PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.unsorted()));
    }

    public <T> Page<T> page(T object, int page, int size, Sort sort) {
        return this.page(object, ExampleMatcher.matching(), PageRequest.of((int)(page - 1), (int)size, (Sort)sort));
    }

    public <T> Page<T> page(T object, ExampleMatcher matcher, PageRequest pageRequest) {
        if (object instanceof Class) {
            return this.getRepository((Class)object).findAll((Pageable)pageRequest);
        }
        this.parseDo(object);
        Example example = Example.of(object, (ExampleMatcher)matcher);
        Class<?> clazz = object.getClass();
        Page page = this.getRepository(clazz).findAll(example, (Pageable)pageRequest);
        this.dictionaryManager.cover((Object)page.getContent());
        return page;
    }

    public <T> Page<T> page(T object, PageRequest pageRequest) {
        return this.page(object, ExampleMatcher.matching(), pageRequest);
    }

    private <T> void parseDo(T object) {
        Class<?> clazz = object.getClass();
        ClassInfo classInfo = ClassInfo.getCache(clazz);
        classInfo.getAllField().forEach(a -> {
            try {
                if (a.getType() == String.class && StringUtil.isBlank((CharSequence)((String)a.get(object)))) {
                    a.setAccessible(true);
                    a.set(object, null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public <T> Page<T> pageByClass(Class<T> tableClass, int page, int size) {
        return this.pageByClass(tableClass, PageRequest.of((int)(page - 1), (int)size));
    }

    public <T> Page<T> pageByClass(Class<T> tableClass, PageRequest pageRequest) {
        Page pageInfo = this.getRepository(tableClass).findAll((Pageable)pageRequest);
        this.dictionaryManager.cover((Object)pageInfo.getContent());
        return pageInfo;
    }

    public <T> Page<T> pageBySQL(String sql, int page, int size, Class<T> clazz, Object ... parameters) {
        return this.pageBySQL(sql, PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.unsorted()), clazz, parameters);
    }

    public <T> Page<T> pageBySQL(String sql, PageRequest pageable, Class<T> clazz, Object ... parameters) {
        Page pageDate = Page.empty();
        int page = pageable.getPageNumber();
        int size = pageable.getPageSize();
        Query countQuery = this.creatQuery(true, sql, parameters);
        int count = Integer.parseInt(countQuery.getSingleResult().toString());
        if (count >= 0) {
            List content;
            if (clazz != null) {
                content = this.findBySQL(sql, clazz, page * size, size, parameters);
            } else {
                Query query = this.creatQuery(false, sql, parameters);
                query.setFirstResult(page * size);
                query.setMaxResults(size);
                this.queryCoverMap(query);
                content = query.getResultList();
            }
            this.dictionaryManager.cover(content);
            pageDate = new PageImpl(content, (Pageable)pageable, (long)count);
        }
        return pageDate;
    }

    public <T> List<T> findAllByClass(Class<T> tableClass) {
        List result = this.getRepository(tableClass).findAll();
        this.dictionaryManager.cover((Object)result);
        return result;
    }

    public <T> List<T> findAllByClass(Class<T> tableClass, Sort sort) {
        List result = this.getRepository(tableClass).findAll(sort);
        this.dictionaryManager.cover((Object)result);
        return result;
    }

    public <T> List<T> findBySQL(String sql, Class<T> clazz, Object ... parameters) {
        return this.findBySQL(sql, clazz, null, null, parameters);
    }

    public <T> List<T> findBySQL(String sql, Class<T> clazz, Integer firstResult, Integer maxResults, Object ... parameters) {
        List list;
        Query query = this.creatQuery(false, sql, parameters);
        this.queryCoverMap(query);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        if ((list = query.getResultList()) != null && !list.isEmpty()) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (Dao.canCastClass(clazz)) {
                for (Map entity : list) {
                    Object node = ObjectUtil.to((Object)entity.values().toArray()[entity.values().size() - 1], (TypeReference)new TypeReference(clazz));
                    if (node == null) continue;
                    result.add(node);
                }
            } else {
                for (Map entity : list) {
                    Object node = ObjectUtil.to((Object)entity, (TypeReference)new TypeReference(clazz));
                    if (node == null) continue;
                    result.add(node);
                }
            }
            this.dictionaryManager.cover(result);
            return result;
        }
        return new ArrayList(0);
    }

    public List<Map<String, Object>> findBySQL(String sql, Object ... parameters) {
        Query query = this.creatQuery(false, sql, parameters);
        this.queryCoverMap(query);
        List result = query.getResultList();
        if (result != null) {
            return result;
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    private <T, ID> List<T> createObjectList(Class<T> tableClass, ID[] ids) throws IdentifierGenerationException {
        ArrayList<T> list = new ArrayList<T>();
        Field idField = this.getIdField(tableClass);
        for (ID id : ids) {
            try {
                T instance = tableClass.newInstance();
                idField.setAccessible(true);
                idField.set(instance, ObjectUtil.to(id, (TypeReference)new TypeReference(idField.getType())));
                list.add(instance);
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.error((Object)"\u4e3b\u952e\u6570\u7ec4\u8f6c\u6362ORM\u5bf9\u8c61\u5217\u8868\u5931\u8d25", (Throwable)e);
            }
        }
        return list;
    }

    public Field getIdField(Class<?> clazz) {
        EntityType entityInfo = this.getEntityManager().getMetamodel().entity(clazz);
        return ClassInfo.getCache(clazz).getField(entityInfo.getId(entityInfo.getIdType().getJavaType()).getName());
    }

    public Object getId(Object o) {
        return this.getIdField(o.getClass()).get(o);
    }

    public void setId(Object o, Object id) {
        Field idField = this.getIdField(o.getClass());
        idField.setAccessible(true);
        idField.set(o, id);
    }

    public Class<?> getIdType(Class<?> clazz) {
        return this.getEntityManager().getMetamodel().entity(clazz).getIdType().getJavaType();
    }

    public Object toIdType(Class<?> clazz, Object id) {
        return ObjectUtil.to((Object)id, (TypeReference)new TypeReference(this.getIdType(clazz)));
    }

    public <T> List<ColumnName> toColumnNames(Class<T> tableClass) {
        return ClassUtil.getAllEntityAnnotation(tableClass, Column.class).stream().map(f -> {
            ColumnName columnName = new ColumnName();
            Column annotation = (Column)f.getAnnotation();
            String name = annotation.name();
            if (!StringUtil.isEmpty((CharSequence)name)) {
                columnName.setName(name);
            }
            columnName.setMember(f.getMember());
            Id id = (Id)ClassUtil.getFieldAnnotation((Class)tableClass, (String)columnName.getName(), Id.class);
            columnName.setPrimaryKey(id != null);
            return columnName;
        }).collect(Collectors.toList());
    }

    public <T> String toTableName(Class<T> tableClass) {
        Table document = tableClass.getAnnotation(Table.class);
        return document.name();
    }

    private void queryCoverMap(Query query) {
        if (query instanceof NativeQueryImpl) {
            ((NativeQueryImpl)query).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        } else if (Proxy.isProxyClass(query.getClass())) {
            try {
                String setResultTransformer = "setResultTransformer";
                Method method = NativeQueryImpl.class.getDeclaredMethod(setResultTransformer, ResultTransformer.class);
                Proxy.getInvocationHandler(query).invoke(query, method, new Object[]{Transformers.ALIAS_TO_ENTITY_MAP});
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private Query creatQuery(boolean isCount, String sql, Object ... parameters) {
        Query query;
        if (parameters == null) {
            return this.getEntityManager().createNativeQuery(sql);
        }
        if (parameters.length == 1) {
            Object p = parameters[0];
            if (Dao.canCastClass(p.getClass()) || p instanceof Collection) {
                query = this.getEntityManager().createNativeQuery(sql);
                query.setParameter(0, p);
            } else {
                HashMap map = Maps.newHashMap();
                sql = isCount ? SqlUtil.parserCountSQLByType((DbType)this.dbType, (String)sql, (Object)p, (Map)map) : SqlUtil.parserSQLByType((DbType)this.dbType, (String)sql, (Object)p, (Map)map);
                query = this.getEntityManager().createNativeQuery(sql);
                try {
                    for (Map.Entry e : map.entrySet()) {
                        query.setParameter(Integer.parseInt((String)e.getKey()), e.getValue());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(sql, e);
                }
            }
        } else {
            query = isCount ? this.getEntityManager().createNativeQuery(SqlUtil.parserCountSQL((String)sql)) : this.getEntityManager().createNativeQuery(sql);
            for (int i = 0; i < parameters.length; ++i) {
                query.setParameter(i, parameters[i]);
            }
        }
        return query;
    }

    private Object getSingleResult(Query query, String sql) {
        List list = query.getResultList();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new NonUniqueResultException(String.format("Call to stored procedure [%s] returned multiple results", sql));
        }
        return list.get(0);
    }

    public int updateBySQL(String sql, Object ... parameters) {
        Query query = this.creatQuery(false, sql, parameters);
        return query.executeUpdate();
    }

    public <T> List<T> findAllByArrayId(Class<T> tableClass, Object ... ids) {
        List result = this.getRepository(tableClass).findAllById(Arrays.asList(ids));
        this.dictionaryManager.cover((Object)result);
        return result;
    }

    public long count(Class<?> tableClass) {
        return this.getRepository(tableClass).count();
    }

    public <T> Page<T> memoryPage(List<T> list, int pageNum, int pageSize, SortInfo ... sortInfos) {
        PageRequest pageRequest = PageRequest.of((int)(pageNum - 1), (int)pageSize);
        PageImpl page = new PageImpl((List)Lists.newArrayList(), (Pageable)pageRequest, 0L);
        Dao.sort(list, sortInfos);
        int fromIndex = (pageNum - 1) * pageSize;
        int toIndex = pageNum * pageSize;
        if (list.isEmpty() || fromIndex > list.size()) {
            return page;
        }
        page = toIndex < list.size() ? new PageImpl(list.subList(fromIndex, toIndex), (Pageable)pageRequest, (long)list.size()) : new PageImpl(list.subList(fromIndex, list.size()), (Pageable)pageRequest, (long)list.size());
        return page;
    }

    public <T> void batchInsert(List<T> list, int batchSize) {
        try {
            if (batchSize <= 0) {
                for (T o : list) {
                    this.getEntityManager().persist(o);
                }
                this.getEntityManager().flush();
                this.getEntityManager().clear();
            }
            for (int i = 0; i < list.size(); ++i) {
                this.getEntityManager().persist(list.get(i));
                if (i % batchSize != 0) continue;
                this.getEntityManager().flush();
                this.getEntityManager().clear();
            }
            this.logger.debug((Object)("save to DB success,list is " + list));
        }
        catch (Exception e) {
            this.logger.error((Object)"batch insert data fail.");
            e.printStackTrace();
        }
    }

    public <T> void batchUpdate(List<T> list, int batchSize) {
        try {
            if (batchSize <= 0) {
                for (T o : list) {
                    this.getEntityManager().merge(o);
                }
                this.getEntityManager().flush();
                this.getEntityManager().clear();
            }
            for (int i = 0; i < list.size(); ++i) {
                this.getEntityManager().merge(list.get(i));
                if (i % batchSize != 0) continue;
                this.getEntityManager().flush();
                this.getEntityManager().clear();
            }
            this.logger.info((Object)("update data success,list is {}" + list));
        }
        catch (Exception e) {
            this.logger.error((Object)"batch update data fail.");
            e.printStackTrace();
        }
    }

    public <T> void batchDelete(List<T> list, int batchSize) {
        try {
            if (batchSize <= 0) {
                for (T o : list) {
                    this.getEntityManager().remove(o);
                }
                this.getEntityManager().flush();
                this.getEntityManager().clear();
            }
            for (int i = 0; i < list.size(); ++i) {
                this.getEntityManager().remove(list.get(i));
                if (i % batchSize != 0) continue;
                this.getEntityManager().flush();
                this.getEntityManager().clear();
            }
            this.logger.info((Object)("delete data success,list is {}" + list));
        }
        catch (Exception e) {
            this.logger.error((Object)"batch delete data fail.");
            e.printStackTrace();
        }
    }

    public Class<?> getEntityType(String model) {
        Optional<EntityType> entityType = this.getEntityManager().getEntityManagerFactory().getMetamodel().getEntities().stream().filter(n -> n.getName().equalsIgnoreCase(StringUtil.toUpperName((String)model))).findFirst();
        return entityType.map(Type::getJavaType).orElse(null);
    }
}

