/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.jpa.dao;

import cloud.agileframework.common.util.clazz.ClassInfo;
import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.jpa.dictionary.DataExtendManager;
import cloud.agileframework.sql.SqlUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class Dao {
    private static final Map<Class<?>, SimpleJpaRepository> REPOSITORY_CACHE = new HashMap();
    private final Logger logger = LoggerFactory.getLogger(Dao.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private DataExtendManager dictionaryManager;

    public <T, ID> SimpleJpaRepository<T, ID> getRepository(Class<T> tableClass) {
        SimpleJpaRepository repository = REPOSITORY_CACHE.get(tableClass);
        if (ObjectUtils.isEmpty((Object)repository)) {
            repository = new SimpleJpaRepository(tableClass, this.getEntityManager());
            REPOSITORY_CACHE.put(tableClass, repository);
        }
        return repository;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void save(Object o) {
        this.getEntityManager().persist(o);
    }

    public <T> boolean save(Iterable<T> list) {
        boolean isTrue = false;
        Iterator<T> iterator = list.iterator();
        if (iterator.hasNext()) {
            T obj = iterator.next();
            Class<?> tClass = obj.getClass();
            this.getRepository(tClass).saveAll(list);
            isTrue = true;
        }
        return isTrue;
    }

    public Connection getConnection() {
        return ((SessionImplementor)this.getEntityManager().unwrap(SessionImplementor.class)).connection();
    }

    public boolean contains(Object o) {
        return this.getEntityManager().contains(o);
    }

    public <T> T saveOrUpdate(T o) {
        Object e;
        Object id = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(o);
        Object old = this.getEntityManager().find(o.getClass(), id);
        if (old == null) {
            SimpleJpaRepository repository = this.getRepository(o.getClass());
            e = repository.save(o);
        } else {
            e = this.getEntityManager().merge(o);
        }
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public <T> T saveAndReturn(T o, boolean isFlush) {
        Class<?> clazz = o.getClass();
        Object e = isFlush ? this.getRepository(clazz).saveAndFlush(o) : this.getRepository(clazz).save(o);
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public <T> T saveAndReturn(T o) {
        return this.saveAndReturn(o, Boolean.FALSE);
    }

    public <T> List<T> saveAndReturn(Iterable<T> list) {
        Iterator<T> iterator = list.iterator();
        if (iterator.hasNext()) {
            T obj = iterator.next();
            Class<?> clazz = obj.getClass();
            return this.getRepository(clazz).saveAll(list);
        }
        return new ArrayList(0);
    }

    public boolean existsById(Class<?> tableClass, Object id) {
        return this.getRepository(tableClass).existsById(this.toIdType(tableClass, id));
    }

    public void flush(Class<?> tableClass) {
        this.getRepository(tableClass).flush();
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void refresh(Object o) {
        this.getEntityManager().refresh(o);
    }

    public <T> boolean update(T o) {
        Object id = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(o);
        Object old = this.getEntityManager().find(o.getClass(), id);
        if (old == null) {
            return false;
        }
        Object e = this.getEntityManager().merge(o);
        this.dictionaryManager.cover(e);
        return true;
    }

    public <T> T updateOfNotNull(T o) throws IllegalAccessException {
        Object id = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil().getIdentifier(o);
        Object old = this.getEntityManager().find(o.getClass(), id);
        ObjectUtil.copyProperties(o, (Object)old, (ObjectUtil.Compare)ObjectUtil.Compare.DIFF_SOURCE_NOT_NULL);
        Object e = this.getEntityManager().merge(old);
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public <T> void delete(T o) {
        List<T> list = this.findAll(o);
        this.deleteInBatch(list);
    }

    public <T> boolean deleteById(Class<T> tableClass, Object id) {
        try {
            this.getRepository(tableClass).deleteById(this.toIdType(tableClass, id));
        }
        catch (EmptyResultDataAccessException ignored) {
            return false;
        }
        return true;
    }

    public <T> void deleteAll(Class<T> tableClass) {
        this.getRepository(tableClass).deleteAll();
    }

    public <T> void deleteAllInBatch(Class<T> tableClass) {
        this.getRepository(tableClass).deleteAllInBatch();
    }

    public <T> void deleteInBatch(Class<T> tableClass, Object[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids) || ids.length < 1) {
            return;
        }
        SimpleJpaRepository repository = this.getRepository(tableClass);
        Class<?> idType = this.getIdType(tableClass);
        for (Object id : ids) {
            repository.deleteById(ObjectUtil.to((Object)id, (TypeReference)new TypeReference(idType)));
        }
    }

    public <T> void deleteInBatch(Class<T> tableClass, Iterable<?> ids) {
        if (ids == null) {
            return;
        }
        SimpleJpaRepository repository = this.getRepository(tableClass);
        Class<?> idType = this.getIdType(tableClass);
        for (Object id : ids) {
            repository.deleteById(ObjectUtil.to(id, (TypeReference)new TypeReference(idType)));
        }
    }

    public <T> void deleteInBatch(Iterable<T> list) {
        for (T obj : list) {
            try {
                this.getRepository(obj.getClass()).deleteById(this.getId(obj));
            }
            catch (IllegalAccessException | IdentifierGenerationException e) {
                e.printStackTrace();
            }
        }
    }

    public <T> T findOne(Class<T> clazz, Object id) {
        Object e = this.getEntityManager().find(clazz, this.toIdType(clazz, id));
        this.dictionaryManager.cover(e);
        return (T)e;
    }

    public <T> T findOne(T object) {
        Example example = Example.of(object);
        Class<?> clazz = object.getClass();
        T e = this.getRepository(clazz).findOne(example).orElse(null);
        this.dictionaryManager.cover(e);
        return e;
    }

    public <T> T findOne(T object, ExampleMatcher matcher) {
        Class<?> clazz = object.getClass();
        T e = this.getRepository(clazz).findOne(Example.of(object, (ExampleMatcher)matcher)).orElse(null);
        this.dictionaryManager.cover(e);
        return e;
    }

    public <T> T findOne(String sql, Class<T> clazz, Object ... parameters) {
        Query query = this.creatQuery(false, sql, parameters);
        if (!Dao.canCastClass(clazz)) {
            this.queryCoverMap(query);
            Map o = (Map)this.getSingleResult(query, sql);
            if (Map.class.isAssignableFrom(clazz)) {
                return (T)o;
            }
            Object e = ObjectUtil.to((Object)o, (TypeReference)new TypeReference(clazz));
            this.dictionaryManager.cover(e);
            return (T)e;
        }
        Object o = this.getSingleResult(query, sql);
        return (T)ObjectUtil.to((Object)o, (TypeReference)new TypeReference(clazz));
    }

    public <T> List<T> findAll(T object) {
        return this.findAll(object, Sort.unsorted());
    }

    public <T> List<T> findAll(T object, Sort sort) {
        return this.findAll(object, ExampleMatcher.matching(), sort);
    }

    public <T> List<T> findAll(T object, ExampleMatcher matcher, Sort sort) {
        Example example = Example.of(object, (ExampleMatcher)matcher);
        Class<?> clazz = object.getClass();
        List result = this.getRepository(clazz).findAll(example, sort);
        this.dictionaryManager.cover(result);
        return result;
    }

    public <T> Page<T> page(T object, int page, int size) {
        return this.page(object, page, size, Sort.unsorted());
    }

    public <T> Page<T> page(T object, ExampleMatcher matcher, int page, int size) {
        return this.page(object, matcher, PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.unsorted()));
    }

    public <T> Page<T> page(T object, int page, int size, Sort sort) {
        return this.page(object, ExampleMatcher.matching(), PageRequest.of((int)(page - 1), (int)size, (Sort)sort));
    }

    public <T> Page<T> page(T object, ExampleMatcher matcher, PageRequest pageRequest) {
        if (object instanceof Class) {
            return this.getRepository((Class)object).findAll((Pageable)pageRequest);
        }
        Example example = Example.of(object, (ExampleMatcher)matcher);
        Class<?> clazz = object.getClass();
        Page page = this.getRepository(clazz).findAll(example, (Pageable)pageRequest);
        this.dictionaryManager.cover(page.getContent());
        return page;
    }

    public <T> Page<T> page(T object, PageRequest pageRequest) {
        return this.page(object, ExampleMatcher.matching(), pageRequest);
    }

    public <T> Page<T> pageByClass(Class<T> tableClass, int page, int size) {
        Page pageInfo = this.getRepository(tableClass).findAll((Pageable)PageRequest.of((int)(page - 1), (int)size));
        this.dictionaryManager.cover(pageInfo.getContent());
        return pageInfo;
    }

    public <T> Page<T> pageBySQL(String sql, int page, int size, Class<T> clazz, Object ... parameters) {
        PageImpl pageDate = null;
        ArrayList sorts = Lists.newArrayList();
        PageRequest pageable = !sorts.isEmpty() ? PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.by((List)sorts)) : PageRequest.of((int)(page - 1), (int)size, (Sort)Sort.unsorted());
        Query countQuery = this.creatQuery(true, sql, parameters);
        int count = Integer.parseInt(countQuery.getSingleResult().toString());
        if (count >= 0) {
            List content;
            if (clazz != null) {
                content = this.findBySQL(sql, clazz, (page - 1) * size, size, parameters);
            } else {
                Query query = this.creatQuery(false, sql, parameters);
                query.setFirstResult((page - 1) * size);
                query.setMaxResults(size);
                this.queryCoverMap(query);
                content = query.getResultList();
            }
            this.dictionaryManager.cover(content);
            pageDate = new PageImpl(content, (Pageable)pageable, (long)count);
        }
        return pageDate;
    }

    public <T> List<T> findAllByClass(Class<T> tableClass) {
        List result = this.getRepository(tableClass).findAll();
        this.dictionaryManager.cover(result);
        return result;
    }

    public <T> List<T> findAllByClass(Class<T> tableClass, Sort sort) {
        List result = this.getRepository(tableClass).findAll(sort);
        this.dictionaryManager.cover(result);
        return result;
    }

    public <T> List<T> findBySQL(String sql, Class<T> clazz, Object ... parameters) {
        return this.findBySQL(sql, clazz, null, null, parameters);
    }

    public <T> List<T> findBySQL(String sql, Class<T> clazz, Integer firstResult, Integer maxResults, Object ... parameters) {
        List list;
        Query query = this.creatQuery(false, sql, parameters);
        this.queryCoverMap(query);
        if (firstResult != null) {
            query.setFirstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.setMaxResults(maxResults.intValue());
        }
        if ((list = query.getResultList()) != null && !list.isEmpty()) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (Dao.canCastClass(clazz)) {
                for (Map entity : list) {
                    Object node = ObjectUtil.to((Object)entity.values().toArray()[entity.values().size() - 1], (TypeReference)new TypeReference(clazz));
                    if (node == null) continue;
                    result.add(node);
                }
            } else {
                for (Map entity : list) {
                    Object node = ObjectUtil.to((Object)entity, (TypeReference)new TypeReference(clazz));
                    if (node == null) continue;
                    result.add(node);
                }
            }
            this.dictionaryManager.cover(result);
            return result;
        }
        return new ArrayList(0);
    }

    public List<Map<String, Object>> findBySQL(String sql, Object ... parameters) {
        Query query = this.creatQuery(false, sql, parameters);
        this.queryCoverMap(query);
        List result = query.getResultList();
        if (result != null) {
            return result;
        }
        return new ArrayList<Map<String, Object>>(0);
    }

    private <T, ID> List<T> createObjectList(Class<T> tableClass, ID[] ids) throws IdentifierGenerationException {
        ArrayList<T> list = new ArrayList<T>();
        Field idField = this.getIdField(tableClass);
        for (ID id : ids) {
            try {
                T instance = tableClass.newInstance();
                idField.setAccessible(true);
                idField.set(instance, ObjectUtil.to(id, (TypeReference)new TypeReference(idField.getType())));
                list.add(instance);
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.error("\u4e3b\u952e\u6570\u7ec4\u8f6c\u6362ORM\u5bf9\u8c61\u5217\u8868\u5931\u8d25", (Throwable)e);
            }
        }
        return list;
    }

    private Field getIdField(Class<?> clazz) {
        EntityType entityInfo = this.getEntityManager().getMetamodel().entity(clazz);
        return ClassInfo.getCache(clazz).getField(entityInfo.getId(entityInfo.getIdType().getJavaType()).getName());
    }

    private Object getId(Object o) throws IllegalAccessException {
        return this.getIdField(o.getClass()).get(o);
    }

    private Class<?> getIdType(Class<?> clazz) {
        return this.getEntityManager().getMetamodel().entity(clazz).getIdType().getJavaType();
    }

    private Object toIdType(Class<?> clazz, Object id) {
        return ObjectUtil.to((Object)id, (TypeReference)new TypeReference(this.getIdType(clazz)));
    }

    private static boolean canCastClass(Class<?> clazz) {
        if (ClassUtil.isWrapOrPrimitive(clazz)) {
            return true;
        }
        return String.class == clazz || BigDecimal.class == clazz || Date.class == clazz || BigInteger.class == clazz || StringBuilder.class == clazz || StringBuffer.class == clazz || Timestamp.class == clazz || Time.class == clazz;
    }

    private void queryCoverMap(Query query) {
        if (query instanceof NativeQueryImpl) {
            ((NativeQueryImpl)query).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        } else if (Proxy.isProxyClass(query.getClass())) {
            try {
                String setResultTransformer = "setResultTransformer";
                Method method = NativeQueryImpl.class.getDeclaredMethod(setResultTransformer, ResultTransformer.class);
                Proxy.getInvocationHandler(query).invoke(query, method, new Object[]{Transformers.ALIAS_TO_ENTITY_MAP});
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private Query creatQuery(boolean isCount, String sql, Object ... parameters) {
        Query query;
        if (parameters == null) {
            return this.getEntityManager().createNativeQuery(sql);
        }
        if (parameters.length == 1) {
            Object p = parameters[0];
            if (Dao.canCastClass(p.getClass())) {
                query = this.getEntityManager().createNativeQuery(sql);
                query.setParameter(0, p);
            } else if (p.getClass().isArray()) {
                query = this.getEntityManager().createNativeQuery(sql);
                for (int i = 0; i < Array.getLength(p); ++i) {
                    query.setParameter(i, Array.get(p, i));
                }
            } else if (Collection.class.isAssignableFrom(p.getClass())) {
                query = this.getEntityManager().createNativeQuery(sql);
                int i = 0;
                for (Object parameter : (Collection)p) {
                    query.setParameter(i++, parameter);
                }
            } else {
                HashMap map = Maps.newHashMap();
                sql = isCount ? SqlUtil.parserCountSQL((String)sql, (Object)p, (Map)map) : SqlUtil.parserSQL((String)sql, (Object)p, (Map)map);
                query = this.getEntityManager().createNativeQuery(sql);
                try {
                    for (Map.Entry e : map.entrySet()) {
                        query.setParameter((String)e.getKey(), e.getValue());
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(sql, e);
                }
            }
        } else {
            query = isCount ? this.getEntityManager().createNativeQuery(SqlUtil.parserCountSQL((String)sql)) : this.getEntityManager().createNativeQuery(sql);
            for (int i = 0; i < parameters.length; ++i) {
                query.setParameter(i, parameters[i]);
            }
        }
        return query;
    }

    private Object getSingleResult(Query query, String sql) {
        List list = query.getResultList();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new NonUniqueResultException(String.format("Call to stored procedure [%s] returned multiple results", sql));
        }
        return list.get(0);
    }

    public int updateBySQL(String sql, Object ... parameters) {
        Query query = this.creatQuery(false, sql, parameters);
        return query.executeUpdate();
    }

    public <T> List<T> findAllById(Class<T> tableClass, Iterable<?> ids) {
        List result = this.getRepository(tableClass).findAllById(ids);
        this.dictionaryManager.cover(result);
        return result;
    }

    public <T> List<T> findAllByArrayId(Class<T> tableClass, Object ... ids) {
        List result = this.getRepository(tableClass).findAllById(Arrays.asList(ids));
        this.dictionaryManager.cover(result);
        return result;
    }

    public long count(Class<?> tableClass) {
        return this.getRepository(tableClass).count();
    }
}

