/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.handler;

import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.generator.handler.ByAllTableGenerator;
import cloud.agileframework.generator.model.TableModel;
import cloud.agileframework.generator.model.swagger.Swagger;
import cloud.agileframework.generator.properties.TYPE;
import com.alibaba.fastjson2.JSON;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class SwaggerGenerator
extends ByAllTableGenerator {
    @Override
    public String freemarkerTemplate() {
        return "swagger.ftl";
    }

    @Override
    public String fileExtension() {
        return ".json";
    }

    @Override
    public TYPE type() {
        return TYPE.SWAGGER;
    }

    @Override
    public void generateFile(List<TableModel> tableModels) throws IOException {
        String url = FileUtil.parseFilePath((String)this.generator.getEntityUrl());
        String fileName = "swagger_" + System.currentTimeMillis() + this.fileExtension();
        Swagger swagger = new Swagger(tableModels);
        FileUtils.writeByteArrayToFile((File)new File(url + fileName), (byte[])JSON.toJSONBytes((Object)swagger), (boolean)false);
    }
}

