/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model.swagger;

import cloud.agileframework.generator.model.swagger.SwaggerCollectionFormat;
import cloud.agileframework.generator.model.swagger.SwaggerPropertyFormat;
import cloud.agileframework.generator.model.swagger.SwaggerPropertyType;
import com.alibaba.fastjson2.annotation.JSONField;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

public class SwaggerApi {
    private Set<String> tags;
    private String summary;
    private String description;
    private String operationId;
    private String[] consumes;
    private String[] produces;
    private Set<SwaggerApiParameter> parameters;
    private Map<String, ResponseData> responses;

    private static String $default$description() {
        return "";
    }

    private static String[] $default$produces() {
        return new String[]{"application/json"};
    }

    SwaggerApi(Set<String> tags, String summary, String description, String operationId, String[] consumes, String[] produces, Set<SwaggerApiParameter> parameters, Map<String, ResponseData> responses) {
        this.tags = tags;
        this.summary = summary;
        this.description = description;
        this.operationId = operationId;
        this.consumes = consumes;
        this.produces = produces;
        this.parameters = parameters;
        this.responses = responses;
    }

    public static SwaggerApiBuilder builder() {
        return new SwaggerApiBuilder();
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String[] getConsumes() {
        return this.consumes;
    }

    public String[] getProduces() {
        return this.produces;
    }

    public Set<SwaggerApiParameter> getParameters() {
        return this.parameters;
    }

    public Map<String, ResponseData> getResponses() {
        return this.responses;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public void setConsumes(String[] consumes) {
        this.consumes = consumes;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    public void setParameters(Set<SwaggerApiParameter> parameters) {
        this.parameters = parameters;
    }

    public void setResponses(Map<String, ResponseData> responses) {
        this.responses = responses;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SwaggerApi)) {
            return false;
        }
        SwaggerApi other = (SwaggerApi)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$summary = this.getSummary();
        String other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !this$summary.equals(other$summary)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$operationId = this.getOperationId();
        String other$operationId = other.getOperationId();
        if (this$operationId == null ? other$operationId != null : !this$operationId.equals(other$operationId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getConsumes(), other.getConsumes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProduces(), other.getProduces())) {
            return false;
        }
        Set<SwaggerApiParameter> this$parameters = this.getParameters();
        Set<SwaggerApiParameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        Map<String, ResponseData> this$responses = this.getResponses();
        Map<String, ResponseData> other$responses = other.getResponses();
        return !(this$responses == null ? other$responses != null : !((Object)this$responses).equals(other$responses));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SwaggerApi;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : $summary.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $operationId = this.getOperationId();
        result = result * 59 + ($operationId == null ? 43 : $operationId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getConsumes());
        result = result * 59 + Arrays.deepHashCode(this.getProduces());
        Set<SwaggerApiParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        Map<String, ResponseData> $responses = this.getResponses();
        result = result * 59 + ($responses == null ? 43 : ((Object)$responses).hashCode());
        return result;
    }

    public String toString() {
        return "SwaggerApi(tags=" + this.getTags() + ", summary=" + this.getSummary() + ", description=" + this.getDescription() + ", operationId=" + this.getOperationId() + ", consumes=" + Arrays.deepToString(this.getConsumes()) + ", produces=" + Arrays.deepToString(this.getProduces()) + ", parameters=" + this.getParameters() + ", responses=" + this.getResponses() + ")";
    }

    public static class SwaggerApiBuilder {
        private Set<String> tags;
        private String summary;
        private boolean description$set;
        private String description$value;
        private String operationId;
        private String[] consumes;
        private boolean produces$set;
        private String[] produces$value;
        private Set<SwaggerApiParameter> parameters;
        private Map<String, ResponseData> responses;

        SwaggerApiBuilder() {
        }

        public SwaggerApiBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public SwaggerApiBuilder summary(String summary) {
            this.summary = summary;
            return this;
        }

        public SwaggerApiBuilder description(String description) {
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        public SwaggerApiBuilder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public SwaggerApiBuilder consumes(String[] consumes) {
            this.consumes = consumes;
            return this;
        }

        public SwaggerApiBuilder produces(String[] produces) {
            this.produces$value = produces;
            this.produces$set = true;
            return this;
        }

        public SwaggerApiBuilder parameters(Set<SwaggerApiParameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        public SwaggerApiBuilder responses(Map<String, ResponseData> responses) {
            this.responses = responses;
            return this;
        }

        public SwaggerApi build() {
            String description$value = this.description$value;
            if (!this.description$set) {
                description$value = SwaggerApi.$default$description();
            }
            String[] produces$value = this.produces$value;
            if (!this.produces$set) {
                produces$value = SwaggerApi.$default$produces();
            }
            return new SwaggerApi(this.tags, this.summary, description$value, this.operationId, this.consumes, produces$value, this.parameters, this.responses);
        }

        public String toString() {
            return "SwaggerApi.SwaggerApiBuilder(tags=" + this.tags + ", summary=" + this.summary + ", description$value=" + this.description$value + ", operationId=" + this.operationId + ", consumes=" + Arrays.deepToString(this.consumes) + ", produces$value=" + Arrays.deepToString(this.produces$value) + ", parameters=" + this.parameters + ", responses=" + this.responses + ")";
        }
    }

    public static class ResponseData {
        private String description;
        private SwaggerProperty schema;

        ResponseData(String description, SwaggerProperty schema) {
            this.description = description;
            this.schema = schema;
        }

        public static ResponseDataBuilder builder() {
            return new ResponseDataBuilder();
        }

        public String getDescription() {
            return this.description;
        }

        public SwaggerProperty getSchema() {
            return this.schema;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setSchema(SwaggerProperty schema) {
            this.schema = schema;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResponseData)) {
                return false;
            }
            ResponseData other = (ResponseData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            SwaggerProperty this$schema = this.getSchema();
            SwaggerProperty other$schema = other.getSchema();
            return !(this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResponseData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            SwaggerProperty $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
            return result;
        }

        public String toString() {
            return "SwaggerApi.ResponseData(description=" + this.getDescription() + ", schema=" + this.getSchema() + ")";
        }

        public static class ResponseDataBuilder {
            private String description;
            private SwaggerProperty schema;

            ResponseDataBuilder() {
            }

            public ResponseDataBuilder description(String description) {
                this.description = description;
                return this;
            }

            public ResponseDataBuilder schema(SwaggerProperty schema) {
                this.schema = schema;
                return this;
            }

            public ResponseData build() {
                return new ResponseData(this.description, this.schema);
            }

            public String toString() {
                return "SwaggerApi.ResponseData.ResponseDataBuilder(description=" + this.description + ", schema=" + this.schema + ")";
            }
        }
    }

    public static class SwaggerProperty {
        private SwaggerPropertyType type;
        private SwaggerPropertyFormat format;
        private Map<String, SwaggerProperty> properties;
        private Set<String> required;
        private Object example;
        @JSONField(name="default")
        private Object defaults;
        private String description;
        @JSONField(name="enum")
        private Set<String> enums;
        private SwaggerProperty items;
        private SwaggerCollectionFormat collectionFormat;
        @JSONField(name="$ref")
        private String ref;
        private String title;

        public static Builder builder() {
            return new Builder();
        }

        public SwaggerPropertyType getType() {
            return this.type;
        }

        public SwaggerPropertyFormat getFormat() {
            return this.format;
        }

        public Map<String, SwaggerProperty> getProperties() {
            return this.properties;
        }

        public Set<String> getRequired() {
            return this.required;
        }

        public Object getExample() {
            return this.example;
        }

        public Object getDefaults() {
            return this.defaults;
        }

        public String getDescription() {
            return this.description;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public SwaggerProperty getItems() {
            return this.items;
        }

        public SwaggerCollectionFormat getCollectionFormat() {
            return this.collectionFormat;
        }

        public String getRef() {
            return this.ref;
        }

        public String getTitle() {
            return this.title;
        }

        public void setType(SwaggerPropertyType type) {
            this.type = type;
        }

        public void setFormat(SwaggerPropertyFormat format) {
            this.format = format;
        }

        public void setProperties(Map<String, SwaggerProperty> properties) {
            this.properties = properties;
        }

        public void setRequired(Set<String> required) {
            this.required = required;
        }

        public void setExample(Object example) {
            this.example = example;
        }

        public void setDefaults(Object defaults) {
            this.defaults = defaults;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setEnums(Set<String> enums) {
            this.enums = enums;
        }

        public void setItems(SwaggerProperty items) {
            this.items = items;
        }

        public void setCollectionFormat(SwaggerCollectionFormat collectionFormat) {
            this.collectionFormat = collectionFormat;
        }

        public void setRef(String ref) {
            this.ref = ref;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwaggerProperty)) {
                return false;
            }
            SwaggerProperty other = (SwaggerProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SwaggerPropertyType this$type = this.getType();
            SwaggerPropertyType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            SwaggerPropertyFormat this$format = this.getFormat();
            SwaggerPropertyFormat other$format = other.getFormat();
            if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
                return false;
            }
            Map<String, SwaggerProperty> this$properties = this.getProperties();
            Map<String, SwaggerProperty> other$properties = other.getProperties();
            if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
                return false;
            }
            Set<String> this$required = this.getRequired();
            Set<String> other$required = other.getRequired();
            if (this$required == null ? other$required != null : !((Object)this$required).equals(other$required)) {
                return false;
            }
            Object this$example = this.getExample();
            Object other$example = other.getExample();
            if (this$example == null ? other$example != null : !this$example.equals(other$example)) {
                return false;
            }
            Object this$defaults = this.getDefaults();
            Object other$defaults = other.getDefaults();
            if (this$defaults == null ? other$defaults != null : !this$defaults.equals(other$defaults)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            Set<String> this$enums = this.getEnums();
            Set<String> other$enums = other.getEnums();
            if (this$enums == null ? other$enums != null : !((Object)this$enums).equals(other$enums)) {
                return false;
            }
            SwaggerProperty this$items = this.getItems();
            SwaggerProperty other$items = other.getItems();
            if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
                return false;
            }
            SwaggerCollectionFormat this$collectionFormat = this.getCollectionFormat();
            SwaggerCollectionFormat other$collectionFormat = other.getCollectionFormat();
            if (this$collectionFormat == null ? other$collectionFormat != null : !((Object)((Object)this$collectionFormat)).equals((Object)other$collectionFormat)) {
                return false;
            }
            String this$ref = this.getRef();
            String other$ref = other.getRef();
            if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SwaggerProperty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SwaggerPropertyType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            SwaggerPropertyFormat $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
            Map<String, SwaggerProperty> $properties = this.getProperties();
            result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
            Set<String> $required = this.getRequired();
            result = result * 59 + ($required == null ? 43 : ((Object)$required).hashCode());
            Object $example = this.getExample();
            result = result * 59 + ($example == null ? 43 : $example.hashCode());
            Object $defaults = this.getDefaults();
            result = result * 59 + ($defaults == null ? 43 : $defaults.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            Set<String> $enums = this.getEnums();
            result = result * 59 + ($enums == null ? 43 : ((Object)$enums).hashCode());
            SwaggerProperty $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            SwaggerCollectionFormat $collectionFormat = this.getCollectionFormat();
            result = result * 59 + ($collectionFormat == null ? 43 : ((Object)((Object)$collectionFormat)).hashCode());
            String $ref = this.getRef();
            result = result * 59 + ($ref == null ? 43 : $ref.hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        public String toString() {
            return "SwaggerApi.SwaggerProperty(type=" + (Object)((Object)this.getType()) + ", format=" + (Object)((Object)this.getFormat()) + ", properties=" + this.getProperties() + ", required=" + this.getRequired() + ", example=" + this.getExample() + ", defaults=" + this.getDefaults() + ", description=" + this.getDescription() + ", enums=" + this.getEnums() + ", items=" + this.getItems() + ", collectionFormat=" + (Object)((Object)this.getCollectionFormat()) + ", ref=" + this.getRef() + ", title=" + this.getTitle() + ")";
        }

        public static class Builder {
            private Map<String, SwaggerProperty> properties;
            private Set<String> required;
            private SwaggerPropertyType type;
            private SwaggerPropertyFormat format;
            private Object defaults;
            private Object example;
            private String description;
            private Set<String> enums;
            private SwaggerProperty items;
            private SwaggerCollectionFormat collectionFormat;
            private String ref;
            private String title;

            public Builder property(String key, SwaggerProperty property) {
                if (this.properties == null) {
                    this.properties = Maps.newConcurrentMap();
                }
                this.properties.put(key, property);
                return this;
            }

            public Builder required(String ... requireds) {
                if (this.required == null) {
                    this.required = Sets.newHashSet();
                }
                this.required.addAll(Arrays.asList(requireds));
                return this;
            }

            public Builder type(SwaggerPropertyType type) {
                this.type = type;
                return this;
            }

            public Builder format(SwaggerPropertyFormat format) {
                this.format = format;
                return this;
            }

            public Builder properties(Map<String, SwaggerProperty> properties) {
                if (this.properties == null) {
                    this.properties = Maps.newConcurrentMap();
                }
                this.properties.putAll(properties);
                return this;
            }

            public Builder example(Object example) {
                this.example = example;
                return this;
            }

            public Builder defaults(Object defaults) {
                this.defaults = defaults;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder enums(Set<String> enums) {
                this.enums = enums;
                return this;
            }

            public Builder items(SwaggerProperty items) {
                this.items = items;
                return this;
            }

            public Builder ref(String schema) {
                this.ref = "#/definitions/" + schema;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public SwaggerProperty build() {
                SwaggerProperty a = new SwaggerProperty();
                a.setFormat(this.format);
                a.setType(this.type);
                a.setProperties(this.properties);
                a.setExample(this.example);
                a.setDefaults(this.defaults);
                a.setEnums(this.enums);
                a.setDescription(this.description);
                a.setCollectionFormat(this.collectionFormat);
                a.setItems(this.items);
                a.setRef(this.ref);
                a.setTitle(this.title);
                a.setRequired(this.required);
                return a;
            }
        }
    }

    public static class SwaggerApiParameter {
        private IN in;
        private String name;
        private String description;
        private boolean required;
        private SwaggerPropertyType type;
        private SwaggerPropertyFormat format;
        @JSONField(name="default")
        private Object defaults;
        @JSONField(name="enum")
        private Set<String> enums;
        private SwaggerProperty items;
        private SwaggerCollectionFormat collectionFormat;
        private SwaggerProperty schema;
        private String title;

        private static boolean $default$required() {
            return false;
        }

        SwaggerApiParameter(IN in, String name, String description, boolean required, SwaggerPropertyType type, SwaggerPropertyFormat format, Object defaults, Set<String> enums, SwaggerProperty items, SwaggerCollectionFormat collectionFormat, SwaggerProperty schema, String title) {
            this.in = in;
            this.name = name;
            this.description = description;
            this.required = required;
            this.type = type;
            this.format = format;
            this.defaults = defaults;
            this.enums = enums;
            this.items = items;
            this.collectionFormat = collectionFormat;
            this.schema = schema;
            this.title = title;
        }

        public static SwaggerApiParameterBuilder builder() {
            return new SwaggerApiParameterBuilder();
        }

        public IN getIn() {
            return this.in;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isRequired() {
            return this.required;
        }

        public SwaggerPropertyType getType() {
            return this.type;
        }

        public SwaggerPropertyFormat getFormat() {
            return this.format;
        }

        public Object getDefaults() {
            return this.defaults;
        }

        public Set<String> getEnums() {
            return this.enums;
        }

        public SwaggerProperty getItems() {
            return this.items;
        }

        public SwaggerCollectionFormat getCollectionFormat() {
            return this.collectionFormat;
        }

        public SwaggerProperty getSchema() {
            return this.schema;
        }

        public String getTitle() {
            return this.title;
        }

        public void setIn(IN in) {
            this.in = in;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public void setType(SwaggerPropertyType type) {
            this.type = type;
        }

        public void setFormat(SwaggerPropertyFormat format) {
            this.format = format;
        }

        public void setDefaults(Object defaults) {
            this.defaults = defaults;
        }

        public void setEnums(Set<String> enums) {
            this.enums = enums;
        }

        public void setItems(SwaggerProperty items) {
            this.items = items;
        }

        public void setCollectionFormat(SwaggerCollectionFormat collectionFormat) {
            this.collectionFormat = collectionFormat;
        }

        public void setSchema(SwaggerProperty schema) {
            this.schema = schema;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SwaggerApiParameter)) {
                return false;
            }
            SwaggerApiParameter other = (SwaggerApiParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRequired() != other.isRequired()) {
                return false;
            }
            IN this$in = this.getIn();
            IN other$in = other.getIn();
            if (this$in == null ? other$in != null : !((Object)((Object)this$in)).equals((Object)other$in)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            SwaggerPropertyType this$type = this.getType();
            SwaggerPropertyType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            SwaggerPropertyFormat this$format = this.getFormat();
            SwaggerPropertyFormat other$format = other.getFormat();
            if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
                return false;
            }
            Object this$defaults = this.getDefaults();
            Object other$defaults = other.getDefaults();
            if (this$defaults == null ? other$defaults != null : !this$defaults.equals(other$defaults)) {
                return false;
            }
            Set<String> this$enums = this.getEnums();
            Set<String> other$enums = other.getEnums();
            if (this$enums == null ? other$enums != null : !((Object)this$enums).equals(other$enums)) {
                return false;
            }
            SwaggerProperty this$items = this.getItems();
            SwaggerProperty other$items = other.getItems();
            if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
                return false;
            }
            SwaggerCollectionFormat this$collectionFormat = this.getCollectionFormat();
            SwaggerCollectionFormat other$collectionFormat = other.getCollectionFormat();
            if (this$collectionFormat == null ? other$collectionFormat != null : !((Object)((Object)this$collectionFormat)).equals((Object)other$collectionFormat)) {
                return false;
            }
            SwaggerProperty this$schema = this.getSchema();
            SwaggerProperty other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SwaggerApiParameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRequired() ? 79 : 97);
            IN $in = this.getIn();
            result = result * 59 + ($in == null ? 43 : ((Object)((Object)$in)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            SwaggerPropertyType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            SwaggerPropertyFormat $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
            Object $defaults = this.getDefaults();
            result = result * 59 + ($defaults == null ? 43 : $defaults.hashCode());
            Set<String> $enums = this.getEnums();
            result = result * 59 + ($enums == null ? 43 : ((Object)$enums).hashCode());
            SwaggerProperty $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            SwaggerCollectionFormat $collectionFormat = this.getCollectionFormat();
            result = result * 59 + ($collectionFormat == null ? 43 : ((Object)((Object)$collectionFormat)).hashCode());
            SwaggerProperty $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        public String toString() {
            return "SwaggerApi.SwaggerApiParameter(in=" + (Object)((Object)this.getIn()) + ", name=" + this.getName() + ", description=" + this.getDescription() + ", required=" + this.isRequired() + ", type=" + (Object)((Object)this.getType()) + ", format=" + (Object)((Object)this.getFormat()) + ", defaults=" + this.getDefaults() + ", enums=" + this.getEnums() + ", items=" + this.getItems() + ", collectionFormat=" + (Object)((Object)this.getCollectionFormat()) + ", schema=" + this.getSchema() + ", title=" + this.getTitle() + ")";
        }

        public static class SwaggerApiParameterBuilder {
            private IN in;
            private String name;
            private String description;
            private boolean required$set;
            private boolean required$value;
            private SwaggerPropertyType type;
            private SwaggerPropertyFormat format;
            private Object defaults;
            private Set<String> enums;
            private SwaggerProperty items;
            private SwaggerCollectionFormat collectionFormat;
            private SwaggerProperty schema;
            private String title;

            SwaggerApiParameterBuilder() {
            }

            public SwaggerApiParameterBuilder in(IN in) {
                this.in = in;
                return this;
            }

            public SwaggerApiParameterBuilder name(String name) {
                this.name = name;
                return this;
            }

            public SwaggerApiParameterBuilder description(String description) {
                this.description = description;
                return this;
            }

            public SwaggerApiParameterBuilder required(boolean required) {
                this.required$value = required;
                this.required$set = true;
                return this;
            }

            public SwaggerApiParameterBuilder type(SwaggerPropertyType type) {
                this.type = type;
                return this;
            }

            public SwaggerApiParameterBuilder format(SwaggerPropertyFormat format) {
                this.format = format;
                return this;
            }

            public SwaggerApiParameterBuilder defaults(Object defaults) {
                this.defaults = defaults;
                return this;
            }

            public SwaggerApiParameterBuilder enums(Set<String> enums) {
                this.enums = enums;
                return this;
            }

            public SwaggerApiParameterBuilder items(SwaggerProperty items) {
                this.items = items;
                return this;
            }

            public SwaggerApiParameterBuilder collectionFormat(SwaggerCollectionFormat collectionFormat) {
                this.collectionFormat = collectionFormat;
                return this;
            }

            public SwaggerApiParameterBuilder schema(SwaggerProperty schema) {
                this.schema = schema;
                return this;
            }

            public SwaggerApiParameterBuilder title(String title) {
                this.title = title;
                return this;
            }

            public SwaggerApiParameter build() {
                boolean required$value = this.required$value;
                if (!this.required$set) {
                    required$value = SwaggerApiParameter.$default$required();
                }
                return new SwaggerApiParameter(this.in, this.name, this.description, required$value, this.type, this.format, this.defaults, this.enums, this.items, this.collectionFormat, this.schema, this.title);
            }

            public String toString() {
                return "SwaggerApi.SwaggerApiParameter.SwaggerApiParameterBuilder(in=" + (Object)((Object)this.in) + ", name=" + this.name + ", description=" + this.description + ", required$value=" + this.required$value + ", type=" + (Object)((Object)this.type) + ", format=" + (Object)((Object)this.format) + ", defaults=" + this.defaults + ", enums=" + this.enums + ", items=" + this.items + ", collectionFormat=" + (Object)((Object)this.collectionFormat) + ", schema=" + this.schema + ", title=" + this.title + ")";
            }
        }
    }

    public static enum IN {
        query,
        body,
        path,
        formData,
        header,
        cookie;

    }
}

