package cloud.agileframework.generator.handler;

import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.generator.model.TableModel;
import cloud.agileframework.generator.model.swagger.Swagger;
import cloud.agileframework.generator.properties.TYPE;
import com.alibaba.fastjson2.JSON;
import org.apache.commons.io.FileUtils;

import java.io.File;
import java.io.IOException;
import java.util.List;

public class SwaggerGenerator extends ByAllTableGenerator {
    @Override
    public String freemarkerTemplate() {
        return "swagger.ftl";
    }

    @Override
    public String fileExtension() {
        return ".json";
    }

    @Override
    public TYPE type() {
        return TYPE.SWAGGER;
    }

    @Override
    public void generateFile(List<TableModel> tableModels) throws IOException {
        String url = FileUtil.parseFilePath(generator.getEntityUrl());
        String fileName = "swagger_" + System.currentTimeMillis() + fileExtension();
        Swagger swagger = new Swagger(tableModels);
        FileUtils.writeByteArrayToFile(new File(url + fileName), JSON.toJSONBytes(swagger), false);
    }
}
