/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model;

import cloud.agileframework.common.annotation.Remark;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.generator.model.ColumnModel;
import cloud.agileframework.generator.model.config.PropertyConfig;
import cloud.agileframework.generator.properties.AnnotationType;
import cloud.agileframework.generator.properties.GeneratorProperties;
import cloud.agileframework.spring.util.BeanUtil;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class BaseModel
implements Serializable {
    private static GeneratorProperties properties = (GeneratorProperties)BeanUtil.getBean(GeneratorProperties.class);
    private static DataSourceProperties dataSourceProperties = (DataSourceProperties)BeanUtil.getBean(DataSourceProperties.class);
    private Set<Class<?>> imports = Sets.newHashSet();
    private Set<String> importDesc = Sets.newHashSet();
    private Set<Annotation> annotations = Sets.newHashSet();
    private Set<Class<? extends Annotation>> annotationClass = Sets.newHashSet();
    private Set<String> annotationDesc = Sets.newHashSet();
    private Set<String> validateAnnotationDesc = Sets.newHashSet();
    private String remarks;

    public static String toBlank(String str) {
        return str == null ? "" : str;
    }

    public static String annotationToDesc(Class<? extends Annotation> annotation, Consumer<Class<?>> consumer) {
        consumer.accept(annotation);
        return "@" + annotation.getSimpleName();
    }

    public String annotationToDesc(Annotation annotation, Consumer<Class<?>> consumer) {
        Class<? extends Annotation> type = annotation.annotationType();
        consumer.accept(type);
        Method[] methods = type.getDeclaredMethods();
        String inner = Arrays.stream(methods).filter(method -> {
            try {
                return !new EqualsBuilder().append(method.getDefaultValue(), method.invoke((Object)annotation, new Object[0])).isEquals();
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return false;
            }
        }).map(method -> {
            try {
                Class<?> returnType = method.getReturnType();
                if (returnType != Void.TYPE) {
                    consumer.accept(returnType);
                }
                Object value = method.invoke((Object)annotation, new Object[0]);
                String key = method.getName();
                String stringValue = this.annotationPropertyValueToDesc(consumer, returnType, value);
                return String.format("%s = %s", key, stringValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.joining(", "));
        if (StringUtils.isEmpty((CharSequence)inner)) {
            return "@" + type.getSimpleName();
        }
        return String.format("@%s(%s)", type.getSimpleName(), inner);
    }

    private String annotationPropertyValueToDesc(Consumer<Class<?>> consumer, Class<?> annotationPropertyType, Object annotationPropertyValue) {
        String stringValue;
        if (annotationPropertyValue instanceof String) {
            stringValue = String.format("\"%s\"", annotationPropertyValue);
        } else if (Annotation.class.isAssignableFrom(annotationPropertyType)) {
            stringValue = String.format("%s", this.annotationToDesc((Annotation)annotationPropertyValue, consumer));
        } else if (annotationPropertyValue instanceof Class) {
            this.setImport((Class)annotationPropertyValue);
            stringValue = String.format("%s.class", ((Class)annotationPropertyValue).getSimpleName());
        } else if (annotationPropertyValue != null && annotationPropertyValue.getClass().isArray()) {
            Class innerClass = TypeReference.extractArray(annotationPropertyValue.getClass());
            int length = Array.getLength(annotationPropertyValue);
            stringValue = String.format("{%s}", IntStream.range(0, length).mapToObj(index -> {
                Object node = Array.get(annotationPropertyValue, index);
                return this.annotationPropertyValueToDesc(consumer, innerClass, node);
            }).collect(Collectors.joining(", ")));
        } else {
            stringValue = String.format("%s", annotationPropertyType.isEnum() ? annotationPropertyType.getSimpleName() + "." + annotationPropertyValue : annotationPropertyValue);
        }
        return stringValue;
    }

    public static GeneratorProperties getProperties() {
        return properties;
    }

    public static DataSourceProperties getDataSourceProperties() {
        return dataSourceProperties;
    }

    /*
     * WARNING - void declaration
     */
    public void setImport(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            void var5_5;
            Class clazz2;
            if (clazz.isArray() && (clazz2 = TypeReference.extractArray(clazz)) == null) {
                return;
            }
            if (var5_5.isPrimitive() || var5_5.getPackage().getName().startsWith("java.lang")) continue;
            this.imports.add((Class<?>)var5_5);
            this.importDesc.add(String.format("%s.%s", var5_5.getPackage().getName(), var5_5.getSimpleName()));
        }
    }

    public void setImport(Set<Class<?>> classes) {
        if (classes == null) {
            return;
        }
        for (Class<?> clazz : classes) {
            this.setImport(clazz);
        }
    }

    public void setRemarks(String remarks) {
        String json;
        PropertyConfig propertyConfig;
        this.remarks = this.deleteHiddenCharacter(remarks.substring(0, remarks.indexOf("\r\n")));
        if (!StringUtil.isEmpty((CharSequence)this.remarks)) {
            this.setImport(Remark.class);
        }
        if ((propertyConfig = (PropertyConfig)ObjectUtil.to((Object)(json = remarks.substring(remarks.indexOf("\r\n") + 2)), (TypeReference)new TypeReference<PropertyConfig>(){})) == null || !(this instanceof ColumnModel)) {
            return;
        }
        ((ColumnModel)this).setPropertyConfig(propertyConfig);
    }

    public String deleteHiddenCharacter(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("[\\s]+", "");
    }

    public void addAnnotation(Annotation annotation, AnnotationType annotationType, Consumer<String> consumer) {
        if (ArrayUtils.contains((Object[])BaseModel.getProperties().getAnnotation(), (Object)((Object)annotationType))) {
            consumer.accept(this.annotationToDesc(annotation, xva$0 -> this.setImport((Class<?>)xva$0)));
        }
    }

    public void addAnnotation(Class<? extends Annotation> annotation, AnnotationType annotationType, Consumer<String> consumer) {
        if (ArrayUtils.contains((Object[])BaseModel.getProperties().getAnnotation(), (Object)((Object)annotationType))) {
            consumer.accept(BaseModel.annotationToDesc(annotation, xva$0 -> this.setImport((Class<?>)xva$0)));
        }
    }

    public void setImports(Set<Class<?>> imports) {
        this.imports = imports;
    }

    public void setImportDesc(Set<String> importDesc) {
        this.importDesc = importDesc;
    }

    public void setAnnotations(Set<Annotation> annotations) {
        this.annotations = annotations;
    }

    public void setAnnotationClass(Set<Class<? extends Annotation>> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setAnnotationDesc(Set<String> annotationDesc) {
        this.annotationDesc = annotationDesc;
    }

    public void setValidateAnnotationDesc(Set<String> validateAnnotationDesc) {
        this.validateAnnotationDesc = validateAnnotationDesc;
    }

    public Set<Class<?>> getImports() {
        return this.imports;
    }

    public Set<String> getImportDesc() {
        return this.importDesc;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Set<Class<? extends Annotation>> getAnnotationClass() {
        return this.annotationClass;
    }

    public Set<String> getAnnotationDesc() {
        return this.annotationDesc;
    }

    public Set<String> getValidateAnnotationDesc() {
        return this.validateAnnotationDesc;
    }

    public String getRemarks() {
        return this.remarks;
    }
}

