/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.handler;

import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.generator.handler.ByTableGenerator;
import cloud.agileframework.generator.model.CreateTimeColumn;
import cloud.agileframework.generator.model.CreateUserColumn;
import cloud.agileframework.generator.model.DeleteColumn;
import cloud.agileframework.generator.model.TableModel;
import cloud.agileframework.generator.model.UpdateTimeColumn;
import cloud.agileframework.generator.model.UpdateUserColumn;
import cloud.agileframework.generator.properties.AnnotationType;
import cloud.agileframework.generator.properties.TYPE;
import cloud.agileframework.generator.util.FreemarkerUtil;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import lombok.experimental.SuperBuilder;

public class AgileServiceGenerator
extends ByTableGenerator {
    @Override
    public String freemarkerTemplate() {
        return "AgileService.ftl";
    }

    @Override
    public String fileExtension() {
        return ".java";
    }

    @Override
    public TYPE type() {
        return TYPE.AGILE_SERVICE;
    }

    @Override
    public void generateFile(TableModel tableModel) throws TemplateException, IOException {
        tableModel.getColumns().removeIf(c -> c instanceof CreateTimeColumn || c instanceof UpdateTimeColumn || c instanceof CreateUserColumn || c instanceof UpdateUserColumn || c instanceof DeleteColumn);
        tableModel.getAnnotationDesc().remove("@Builder");
        tableModel.addAnnotation(SuperBuilder.class, AnnotationType.LOMBOK, desc -> tableModel.getAnnotationDesc().add((String)desc));
        tableModel.build();
        String baseUrl = FileUtil.parseFilePath((String)this.generator.getEntityUrl()) + tableModel.getModelName() + File.separator + tableModel.getMvcPackageName() + File.separator;
        String doUrl = baseUrl + "pojo" + File.separator + "db" + File.separator;
        String doFileName = tableModel.getDoName() + this.fileExtension();
        tableModel.setDoPackageName(this.getPackPath(doUrl));
        FreemarkerUtil.generatorProxy("AgileDo.ftl", doUrl, doFileName, tableModel, false);
        String voUrl = baseUrl + "pojo" + File.separator + "vo" + File.separator;
        String inVoFileName = tableModel.getInVoName() + this.fileExtension();
        tableModel.setVoPackageName(this.getPackPath(voUrl));
        FreemarkerUtil.generatorProxy("AgileInVo.ftl", voUrl, inVoFileName, tableModel, false);
        String outVoFileName = tableModel.getOutVoName() + this.fileExtension();
        tableModel.setVoPackageName(this.getPackPath(voUrl));
        FreemarkerUtil.generatorProxy("AgileOutVo.ftl", voUrl, outVoFileName, tableModel, false);
        String controllerUrl = baseUrl + "service" + File.separator;
        String controllerFileName = tableModel.getJavaName() + "Service" + this.fileExtension();
        tableModel.setControllerPackageName(this.getPackPath(controllerUrl));
        FreemarkerUtil.generatorProxy(this.freemarkerTemplate(), controllerUrl, controllerFileName, tableModel, false);
    }
}

