/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model;

import cloud.agileframework.common.annotation.Remark;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.generator.model.BaseModel;
import cloud.agileframework.generator.model.CreateTimeColumn;
import cloud.agileframework.generator.model.DeleteColumn;
import cloud.agileframework.generator.model.FExportKeyColumn;
import cloud.agileframework.generator.model.FImportKeyColumn;
import cloud.agileframework.generator.model.ParentKeyColumn;
import cloud.agileframework.generator.model.PrimaryKeyColumn;
import cloud.agileframework.generator.model.config.PropertyConfig;
import cloud.agileframework.generator.properties.AnnotationType;
import cloud.agileframework.validate.group.Insert;
import cloud.agileframework.validate.group.Update;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.Payload;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Builder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hibernate.validator.constraints.Length;

public class ColumnModel
extends BaseModel {
    private final Set<String> fieldAnnotationDesc = Sets.newHashSet();
    private final Set<String> dicAnnotationDesc = Sets.newHashSet();
    private PropertyConfig propertyConfig;
    private String tableCat;
    private String bufferLength;
    private String tableName;
    private String columnDef;
    private String scopeCatalog;
    private String tableSchem;
    private String columnName;
    private String numPrecRadix;
    private String isAutoincrement;
    private String sqlDataType;
    private String scopeSchema;
    private String isPrimaryKey;
    private String dataType;
    private int columnSize;
    private String scopeTable;
    private boolean notNull = false;
    private String nullable;
    private int decimalDigits;
    private String sqlDatetimeSub;
    private String isGeneratedcolumn;
    private String charOctetLength;
    private String ordinalPosition;
    private String sourceDataType;
    private String typeName;
    private String javaName;
    private String getMethod;
    private String setMethod;
    private Class<?> javaType;
    private String javaTypeName;
    private String javaSimpleTypeName;
    private String defValue;

    public void build() {
        this.addAnnotation((Annotation)new Column(){

            public Class<? extends Annotation> annotationType() {
                return Column.class;
            }

            public String name() {
                return ColumnModel.this.getColumnName();
            }

            public boolean unique() {
                return false;
            }

            public boolean nullable() {
                return !ColumnModel.this.isNotNull();
            }

            public boolean insertable() {
                return !(ColumnModel.this instanceof DeleteColumn);
            }

            public boolean updatable() {
                return !(ColumnModel.this instanceof DeleteColumn) && !(ColumnModel.this instanceof CreateTimeColumn);
            }

            public String columnDefinition() {
                if (!StringUtils.isEmpty((CharSequence)ColumnModel.this.getColumnDef())) {
                    return String.format("%s default %s", ColumnModel.this.getTypeName(), ColumnModel.this.getColumnDef());
                }
                return "";
            }

            public String table() {
                return "";
            }

            public int length() {
                if (ColumnModel.this.getColumnSize() > 0 && !ColumnModel.this.getJavaType().isAssignableFrom(java.util.Date.class)) {
                    return ColumnModel.this.getColumnSize();
                }
                return 255;
            }

            public int precision() {
                return 0;
            }

            public int scale() {
                return 0;
            }
        }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.validateHandler();
        if (!(this instanceof PrimaryKeyColumn)) {
            if ("byte[]".equals(this.javaTypeName) || "java.sql.Blob".equals(this.javaTypeName) || "java.sql.Clob".equals(this.javaTypeName)) {
                if ("java.sql.Blob".equals(this.javaTypeName) || "java.sql.Clob".equals(this.javaTypeName)) {
                    this.addAnnotation(Lob.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
                }
                this.addAnnotation((Annotation)new Basic(){

                    public Class<? extends Annotation> annotationType() {
                        return Basic.class;
                    }

                    public FetchType fetch() {
                        return FetchType.LAZY;
                    }

                    public boolean optional() {
                        return true;
                    }
                }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
            } else {
                this.addAnnotation(Basic.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
            }
        }
        this.addAnnotation((Annotation)new Remark(){

            public Class<? extends Annotation> annotationType() {
                return Remark.class;
            }

            public String value() {
                return BaseModel.toBlank(ColumnModel.this.getRemarks());
            }

            public boolean ignoreCompare() {
                return false;
            }
        }, AnnotationType.REMARK, (String desc) -> this.getFieldAnnotationDesc().add((String)desc));
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
        this.notNull = "0".equals(nullable);
    }

    private void validateHandler() {
        if (this.columnSize <= 0) {
            return;
        }
        if (this.notNull && this.javaType == String.class && !Boolean.parseBoolean(this.isPrimaryKey)) {
            this.addAnnotation((Annotation)new NotBlank(){

                public Class<? extends Annotation> annotationType() {
                    return NotBlank.class;
                }

                public String message() {
                    return BaseModel.toBlank(ColumnModel.this.getRemarks()) + "\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26";
                }

                public Class<?>[] groups() {
                    return new Class[]{Insert.class, Update.class};
                }

                public Class<? extends Payload>[] payload() {
                    return new Class[0];
                }
            }, AnnotationType.VALIDATE, (String desc) -> this.getValidateAnnotationDesc().add((String)desc));
        }
        if (this.notNull && this.javaType != String.class && !Boolean.parseBoolean(this.isPrimaryKey)) {
            this.addAnnotation((Annotation)new NotNull(){

                public Class<? extends Annotation> annotationType() {
                    return NotNull.class;
                }

                public String message() {
                    return BaseModel.toBlank(ColumnModel.this.getRemarks()) + "\u4e0d\u80fd\u4e3aNull";
                }

                public Class<?>[] groups() {
                    return new Class[]{Insert.class, Update.class};
                }

                public Class<? extends Payload>[] payload() {
                    return new Class[0];
                }
            }, AnnotationType.VALIDATE, (String desc) -> this.getValidateAnnotationDesc().add((String)desc));
        }
        if (this.javaType == String.class) {
            this.addAnnotation((Annotation)new Length(){

                public Class<? extends Annotation> annotationType() {
                    return Length.class;
                }

                public int min() {
                    return 0;
                }

                public int max() {
                    return ColumnModel.this.columnSize;
                }

                public String message() {
                    return "\u6700\u957f\u4e3a" + this.max() + "\u4e2a\u5b57\u7b26";
                }

                public Class<?>[] groups() {
                    return new Class[]{Insert.class, Update.class};
                }

                public Class<? extends Payload>[] payload() {
                    return new Class[0];
                }
            }, AnnotationType.VALIDATE, (String desc) -> this.getValidateAnnotationDesc().add((String)desc));
            return;
        }
        if (this.javaType == Integer.TYPE || this.javaType == Integer.class) {
            this.addAnnotation((Annotation)new Max(){

                public Class<? extends Annotation> annotationType() {
                    return Max.class;
                }

                public String message() {
                    return "{javax.validation.constraints.Max.message}";
                }

                public Class<?>[] groups() {
                    return new Class[]{Insert.class, Update.class};
                }

                public Class<? extends Payload>[] payload() {
                    return new Class[0];
                }

                public long value() {
                    double a = Math.pow(10.0, ColumnModel.this.getColumnSize()) - 1.0;
                    if (a > 2.147483647E9) {
                        return Integer.MAX_VALUE;
                    }
                    return (long)a;
                }
            }, AnnotationType.VALIDATE, (String desc) -> this.getValidateAnnotationDesc().add((String)desc));
            this.addAnnotation((Annotation)new Min(){

                public Class<? extends Annotation> annotationType() {
                    return Min.class;
                }

                public String message() {
                    return "{javax.validation.constraints.Min.message}";
                }

                public Class<?>[] groups() {
                    return new Class[]{Insert.class, Update.class};
                }

                public Class<? extends Payload>[] payload() {
                    return new Class[0];
                }

                public long value() {
                    return 0L;
                }
            }, AnnotationType.VALIDATE, (String desc) -> this.getValidateAnnotationDesc().add((String)desc));
            return;
        }
        if (!(this.javaType != Long.TYPE && this.javaType != Long.class || this instanceof PrimaryKeyColumn || this instanceof ParentKeyColumn || this instanceof FExportKeyColumn || this instanceof FImportKeyColumn)) {
            this.addAnnotation((Annotation)new DecimalMax(){

                public Class<? extends Annotation> annotationType() {
                    return DecimalMax.class;
                }

                public String message() {
                    return "{javax.validation.constraints.DecimalMax.message}";
                }

                public Class<?>[] groups() {
                    return new Class[]{Insert.class, Update.class};
                }

                public Class<? extends Payload>[] payload() {
                    return new Class[0];
                }

                public String value() {
                    return BigDecimal.valueOf(Math.pow(10.0, ColumnModel.this.getColumnSize() - 1)).add(BigDecimal.valueOf(-1L)).toString();
                }

                public boolean inclusive() {
                    return true;
                }
            }, AnnotationType.VALIDATE, (String desc) -> this.getValidateAnnotationDesc().add((String)desc));
            this.addAnnotation((Annotation)new DecimalMin(){

                public Class<? extends Annotation> annotationType() {
                    return DecimalMin.class;
                }

                public String message() {
                    return "{javax.validation.constraints.DecimalMin.message}";
                }

                public Class<?>[] groups() {
                    return new Class[]{Insert.class, Update.class};
                }

                public Class<? extends Payload>[] payload() {
                    return new Class[0];
                }

                public String value() {
                    return "-" + BigDecimal.valueOf(Math.pow(10.0, ColumnModel.this.getColumnSize() - 2)).add(BigDecimal.valueOf(-1L));
                }

                public boolean inclusive() {
                    return true;
                }
            }, AnnotationType.VALIDATE, (String desc) -> this.getValidateAnnotationDesc().add((String)desc));
        }
    }

    public void setColumnName(String columnName) {
        columnName = this.deleteHiddenCharacter(columnName);
        this.columnName = ColumnModel.getProperties().getKeywords().contains(columnName) ? String.format("`%s`", columnName) : columnName;
        this.javaName = ColumnModel.getProperties().isSensitive() ? StringUtil.toLowerName((String)columnName) : StringUtil.toLowerName((String)columnName.toLowerCase());
        this.javaName = this.javaName.replace("_", "");
        this.setMethod(this.javaName);
    }

    public void setTypeName(final String typeName) {
        this.typeName = typeName;
        if ("TIMESTAMP".equals(typeName) || "DATE".equals(typeName) || "TIME".equals(typeName)) {
            this.addAnnotation((Annotation)new Temporal(){

                public Class<? extends Annotation> annotationType() {
                    return Temporal.class;
                }

                public TemporalType value() {
                    return TemporalType.valueOf((String)typeName);
                }
            }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
        this.javaType = ColumnModel.getProperties().getJavaType(typeName.split("[\\s]+")[0].toLowerCase());
        if (this.javaType == null) {
            this.javaType = String.class;
        }
        this.javaTypeName = this.javaType.getName();
        this.javaSimpleTypeName = this.javaType.getSimpleName();
        this.setImport(this.javaType);
    }

    public void setIsPrimaryKey(String isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public void setMethod(String name) {
        this.getMethod = "get" + StringUtil.toUpperName((String)name);
        this.setMethod = "set" + StringUtil.toUpperName((String)name);
    }

    public void setIsAutoincrement(String isAutoincrement) {
        this.isAutoincrement = isAutoincrement;
        if ("YES".equals(isAutoincrement)) {
            this.addAnnotation((Annotation)new GeneratedValue(){

                public Class<? extends Annotation> annotationType() {
                    return GeneratedValue.class;
                }

                public GenerationType strategy() {
                    return GenerationType.IDENTITY;
                }

                public String generator() {
                    return "";
                }
            }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
    }

    public void setColumnDef(String columnDef) {
        this.columnDef = this.deleteHiddenCharacter(columnDef);
        if (this.columnDef == null || "null".equalsIgnoreCase(columnDef)) {
            return;
        }
        if (Double.class == this.javaType) {
            this.defValue = NumberUtils.isCreatable((String)columnDef) ? Double.valueOf(columnDef).toString() : null;
        } else if (String.class == this.javaType || Character.TYPE == this.javaType) {
            this.defValue = String.format("\"%s\"", columnDef.replace("'", ""));
        } else if ("CURRENT_TIMESTAMP".equals(columnDef)) {
            if (java.util.Date.class == this.javaType || Date.class == this.javaType) {
                this.defValue = "new Date()";
            } else if (Time.class == this.javaType) {
                this.defValue = "new Time(System.currentTimeMillis())";
            } else if (Timestamp.class == this.javaType) {
                this.defValue = "new Timestamp(System.currentTimeMillis())";
            } else if (Long.TYPE == this.javaType) {
                this.defValue = "System.currentTimeMillis()";
            }
        }
        this.addAnnotation(Builder.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
        this.setImport(javaType);
    }

    public void setJavaTypeName(String javaTypeName) {
        this.javaTypeName = javaTypeName;
    }

    public void setJavaSimpleTypeName(String javaSimpleTypeName) {
        this.javaSimpleTypeName = javaSimpleTypeName;
    }

    public boolean isGeneric() {
        return true;
    }

    public void setPropertyConfig(PropertyConfig propertyConfig) {
        this.propertyConfig = propertyConfig;
    }

    public Set<String> getFieldAnnotationDesc() {
        return this.fieldAnnotationDesc;
    }

    public Set<String> getDicAnnotationDesc() {
        return this.dicAnnotationDesc;
    }

    public PropertyConfig getPropertyConfig() {
        return this.propertyConfig;
    }

    public String getTableCat() {
        return this.tableCat;
    }

    public String getBufferLength() {
        return this.bufferLength;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnDef() {
        return this.columnDef;
    }

    public String getScopeCatalog() {
        return this.scopeCatalog;
    }

    public String getTableSchem() {
        return this.tableSchem;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getNumPrecRadix() {
        return this.numPrecRadix;
    }

    public String getIsAutoincrement() {
        return this.isAutoincrement;
    }

    public String getSqlDataType() {
        return this.sqlDataType;
    }

    public String getScopeSchema() {
        return this.scopeSchema;
    }

    public String getIsPrimaryKey() {
        return this.isPrimaryKey;
    }

    public String getDataType() {
        return this.dataType;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public String getScopeTable() {
        return this.scopeTable;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public String getNullable() {
        return this.nullable;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public String getSqlDatetimeSub() {
        return this.sqlDatetimeSub;
    }

    public String getIsGeneratedcolumn() {
        return this.isGeneratedcolumn;
    }

    public String getCharOctetLength() {
        return this.charOctetLength;
    }

    public String getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getSourceDataType() {
        return this.sourceDataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getGetMethod() {
        return this.getMethod;
    }

    public String getSetMethod() {
        return this.setMethod;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public String getJavaSimpleTypeName() {
        return this.javaSimpleTypeName;
    }

    public String getDefValue() {
        return this.defValue;
    }

    public void setTableCat(String tableCat) {
        this.tableCat = tableCat;
    }

    public void setBufferLength(String bufferLength) {
        this.bufferLength = bufferLength;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setScopeCatalog(String scopeCatalog) {
        this.scopeCatalog = scopeCatalog;
    }

    public void setTableSchem(String tableSchem) {
        this.tableSchem = tableSchem;
    }

    public void setNumPrecRadix(String numPrecRadix) {
        this.numPrecRadix = numPrecRadix;
    }

    public void setSqlDataType(String sqlDataType) {
        this.sqlDataType = sqlDataType;
    }

    public void setScopeSchema(String scopeSchema) {
        this.scopeSchema = scopeSchema;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public void setScopeTable(String scopeTable) {
        this.scopeTable = scopeTable;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public void setSqlDatetimeSub(String sqlDatetimeSub) {
        this.sqlDatetimeSub = sqlDatetimeSub;
    }

    public void setIsGeneratedcolumn(String isGeneratedcolumn) {
        this.isGeneratedcolumn = isGeneratedcolumn;
    }

    public void setCharOctetLength(String charOctetLength) {
        this.charOctetLength = charOctetLength;
    }

    public void setOrdinalPosition(String ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    public void setSourceDataType(String sourceDataType) {
        this.sourceDataType = sourceDataType;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public void setGetMethod(String getMethod) {
        this.getMethod = getMethod;
    }

    public void setSetMethod(String setMethod) {
        this.setMethod = setMethod;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnModel)) {
            return false;
        }
        ColumnModel other = (ColumnModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getColumnSize() != other.getColumnSize()) {
            return false;
        }
        if (this.isNotNull() != other.isNotNull()) {
            return false;
        }
        if (this.getDecimalDigits() != other.getDecimalDigits()) {
            return false;
        }
        Set<String> this$fieldAnnotationDesc = this.getFieldAnnotationDesc();
        Set<String> other$fieldAnnotationDesc = other.getFieldAnnotationDesc();
        if (this$fieldAnnotationDesc == null ? other$fieldAnnotationDesc != null : !((Object)this$fieldAnnotationDesc).equals(other$fieldAnnotationDesc)) {
            return false;
        }
        Set<String> this$dicAnnotationDesc = this.getDicAnnotationDesc();
        Set<String> other$dicAnnotationDesc = other.getDicAnnotationDesc();
        if (this$dicAnnotationDesc == null ? other$dicAnnotationDesc != null : !((Object)this$dicAnnotationDesc).equals(other$dicAnnotationDesc)) {
            return false;
        }
        PropertyConfig this$propertyConfig = this.getPropertyConfig();
        PropertyConfig other$propertyConfig = other.getPropertyConfig();
        if (this$propertyConfig == null ? other$propertyConfig != null : !((Object)this$propertyConfig).equals(other$propertyConfig)) {
            return false;
        }
        String this$tableCat = this.getTableCat();
        String other$tableCat = other.getTableCat();
        if (this$tableCat == null ? other$tableCat != null : !this$tableCat.equals(other$tableCat)) {
            return false;
        }
        String this$bufferLength = this.getBufferLength();
        String other$bufferLength = other.getBufferLength();
        if (this$bufferLength == null ? other$bufferLength != null : !this$bufferLength.equals(other$bufferLength)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$columnDef = this.getColumnDef();
        String other$columnDef = other.getColumnDef();
        if (this$columnDef == null ? other$columnDef != null : !this$columnDef.equals(other$columnDef)) {
            return false;
        }
        String this$scopeCatalog = this.getScopeCatalog();
        String other$scopeCatalog = other.getScopeCatalog();
        if (this$scopeCatalog == null ? other$scopeCatalog != null : !this$scopeCatalog.equals(other$scopeCatalog)) {
            return false;
        }
        String this$tableSchem = this.getTableSchem();
        String other$tableSchem = other.getTableSchem();
        if (this$tableSchem == null ? other$tableSchem != null : !this$tableSchem.equals(other$tableSchem)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$numPrecRadix = this.getNumPrecRadix();
        String other$numPrecRadix = other.getNumPrecRadix();
        if (this$numPrecRadix == null ? other$numPrecRadix != null : !this$numPrecRadix.equals(other$numPrecRadix)) {
            return false;
        }
        String this$isAutoincrement = this.getIsAutoincrement();
        String other$isAutoincrement = other.getIsAutoincrement();
        if (this$isAutoincrement == null ? other$isAutoincrement != null : !this$isAutoincrement.equals(other$isAutoincrement)) {
            return false;
        }
        String this$sqlDataType = this.getSqlDataType();
        String other$sqlDataType = other.getSqlDataType();
        if (this$sqlDataType == null ? other$sqlDataType != null : !this$sqlDataType.equals(other$sqlDataType)) {
            return false;
        }
        String this$scopeSchema = this.getScopeSchema();
        String other$scopeSchema = other.getScopeSchema();
        if (this$scopeSchema == null ? other$scopeSchema != null : !this$scopeSchema.equals(other$scopeSchema)) {
            return false;
        }
        String this$isPrimaryKey = this.getIsPrimaryKey();
        String other$isPrimaryKey = other.getIsPrimaryKey();
        if (this$isPrimaryKey == null ? other$isPrimaryKey != null : !this$isPrimaryKey.equals(other$isPrimaryKey)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$scopeTable = this.getScopeTable();
        String other$scopeTable = other.getScopeTable();
        if (this$scopeTable == null ? other$scopeTable != null : !this$scopeTable.equals(other$scopeTable)) {
            return false;
        }
        String this$nullable = this.getNullable();
        String other$nullable = other.getNullable();
        if (this$nullable == null ? other$nullable != null : !this$nullable.equals(other$nullable)) {
            return false;
        }
        String this$sqlDatetimeSub = this.getSqlDatetimeSub();
        String other$sqlDatetimeSub = other.getSqlDatetimeSub();
        if (this$sqlDatetimeSub == null ? other$sqlDatetimeSub != null : !this$sqlDatetimeSub.equals(other$sqlDatetimeSub)) {
            return false;
        }
        String this$isGeneratedcolumn = this.getIsGeneratedcolumn();
        String other$isGeneratedcolumn = other.getIsGeneratedcolumn();
        if (this$isGeneratedcolumn == null ? other$isGeneratedcolumn != null : !this$isGeneratedcolumn.equals(other$isGeneratedcolumn)) {
            return false;
        }
        String this$charOctetLength = this.getCharOctetLength();
        String other$charOctetLength = other.getCharOctetLength();
        if (this$charOctetLength == null ? other$charOctetLength != null : !this$charOctetLength.equals(other$charOctetLength)) {
            return false;
        }
        String this$ordinalPosition = this.getOrdinalPosition();
        String other$ordinalPosition = other.getOrdinalPosition();
        if (this$ordinalPosition == null ? other$ordinalPosition != null : !this$ordinalPosition.equals(other$ordinalPosition)) {
            return false;
        }
        String this$sourceDataType = this.getSourceDataType();
        String other$sourceDataType = other.getSourceDataType();
        if (this$sourceDataType == null ? other$sourceDataType != null : !this$sourceDataType.equals(other$sourceDataType)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$javaName = this.getJavaName();
        String other$javaName = other.getJavaName();
        if (this$javaName == null ? other$javaName != null : !this$javaName.equals(other$javaName)) {
            return false;
        }
        String this$getMethod = this.getGetMethod();
        String other$getMethod = other.getGetMethod();
        if (this$getMethod == null ? other$getMethod != null : !this$getMethod.equals(other$getMethod)) {
            return false;
        }
        String this$setMethod = this.getSetMethod();
        String other$setMethod = other.getSetMethod();
        if (this$setMethod == null ? other$setMethod != null : !this$setMethod.equals(other$setMethod)) {
            return false;
        }
        Class<?> this$javaType = this.getJavaType();
        Class<?> other$javaType = other.getJavaType();
        if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
            return false;
        }
        String this$javaTypeName = this.getJavaTypeName();
        String other$javaTypeName = other.getJavaTypeName();
        if (this$javaTypeName == null ? other$javaTypeName != null : !this$javaTypeName.equals(other$javaTypeName)) {
            return false;
        }
        String this$javaSimpleTypeName = this.getJavaSimpleTypeName();
        String other$javaSimpleTypeName = other.getJavaSimpleTypeName();
        if (this$javaSimpleTypeName == null ? other$javaSimpleTypeName != null : !this$javaSimpleTypeName.equals(other$javaSimpleTypeName)) {
            return false;
        }
        String this$defValue = this.getDefValue();
        String other$defValue = other.getDefValue();
        return !(this$defValue == null ? other$defValue != null : !this$defValue.equals(other$defValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColumnModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getColumnSize();
        result = result * 59 + (this.isNotNull() ? 79 : 97);
        result = result * 59 + this.getDecimalDigits();
        Set<String> $fieldAnnotationDesc = this.getFieldAnnotationDesc();
        result = result * 59 + ($fieldAnnotationDesc == null ? 43 : ((Object)$fieldAnnotationDesc).hashCode());
        Set<String> $dicAnnotationDesc = this.getDicAnnotationDesc();
        result = result * 59 + ($dicAnnotationDesc == null ? 43 : ((Object)$dicAnnotationDesc).hashCode());
        PropertyConfig $propertyConfig = this.getPropertyConfig();
        result = result * 59 + ($propertyConfig == null ? 43 : ((Object)$propertyConfig).hashCode());
        String $tableCat = this.getTableCat();
        result = result * 59 + ($tableCat == null ? 43 : $tableCat.hashCode());
        String $bufferLength = this.getBufferLength();
        result = result * 59 + ($bufferLength == null ? 43 : $bufferLength.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $columnDef = this.getColumnDef();
        result = result * 59 + ($columnDef == null ? 43 : $columnDef.hashCode());
        String $scopeCatalog = this.getScopeCatalog();
        result = result * 59 + ($scopeCatalog == null ? 43 : $scopeCatalog.hashCode());
        String $tableSchem = this.getTableSchem();
        result = result * 59 + ($tableSchem == null ? 43 : $tableSchem.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $numPrecRadix = this.getNumPrecRadix();
        result = result * 59 + ($numPrecRadix == null ? 43 : $numPrecRadix.hashCode());
        String $isAutoincrement = this.getIsAutoincrement();
        result = result * 59 + ($isAutoincrement == null ? 43 : $isAutoincrement.hashCode());
        String $sqlDataType = this.getSqlDataType();
        result = result * 59 + ($sqlDataType == null ? 43 : $sqlDataType.hashCode());
        String $scopeSchema = this.getScopeSchema();
        result = result * 59 + ($scopeSchema == null ? 43 : $scopeSchema.hashCode());
        String $isPrimaryKey = this.getIsPrimaryKey();
        result = result * 59 + ($isPrimaryKey == null ? 43 : $isPrimaryKey.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $scopeTable = this.getScopeTable();
        result = result * 59 + ($scopeTable == null ? 43 : $scopeTable.hashCode());
        String $nullable = this.getNullable();
        result = result * 59 + ($nullable == null ? 43 : $nullable.hashCode());
        String $sqlDatetimeSub = this.getSqlDatetimeSub();
        result = result * 59 + ($sqlDatetimeSub == null ? 43 : $sqlDatetimeSub.hashCode());
        String $isGeneratedcolumn = this.getIsGeneratedcolumn();
        result = result * 59 + ($isGeneratedcolumn == null ? 43 : $isGeneratedcolumn.hashCode());
        String $charOctetLength = this.getCharOctetLength();
        result = result * 59 + ($charOctetLength == null ? 43 : $charOctetLength.hashCode());
        String $ordinalPosition = this.getOrdinalPosition();
        result = result * 59 + ($ordinalPosition == null ? 43 : $ordinalPosition.hashCode());
        String $sourceDataType = this.getSourceDataType();
        result = result * 59 + ($sourceDataType == null ? 43 : $sourceDataType.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $javaName = this.getJavaName();
        result = result * 59 + ($javaName == null ? 43 : $javaName.hashCode());
        String $getMethod = this.getGetMethod();
        result = result * 59 + ($getMethod == null ? 43 : $getMethod.hashCode());
        String $setMethod = this.getSetMethod();
        result = result * 59 + ($setMethod == null ? 43 : $setMethod.hashCode());
        Class<?> $javaType = this.getJavaType();
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        String $javaTypeName = this.getJavaTypeName();
        result = result * 59 + ($javaTypeName == null ? 43 : $javaTypeName.hashCode());
        String $javaSimpleTypeName = this.getJavaSimpleTypeName();
        result = result * 59 + ($javaSimpleTypeName == null ? 43 : $javaSimpleTypeName.hashCode());
        String $defValue = this.getDefValue();
        result = result * 59 + ($defValue == null ? 43 : $defValue.hashCode());
        return result;
    }
}

