/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model.swagger;

import cloud.agileframework.common.util.http.RequestMethod;
import cloud.agileframework.common.util.number.NumberUtil;
import cloud.agileframework.generator.model.ColumnModel;
import cloud.agileframework.generator.model.ParentKeyColumn;
import cloud.agileframework.generator.model.PrimaryKeyColumn;
import cloud.agileframework.generator.model.TableModel;
import cloud.agileframework.generator.model.swagger.SwaggerApi;
import cloud.agileframework.generator.model.swagger.SwaggerPropertyFormat;
import cloud.agileframework.generator.model.swagger.SwaggerPropertyType;
import cloud.agileframework.generator.model.swagger.Tags;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.http.HttpStatus;

public class Swagger {
    private String swagger = "2.0";
    private JSON info = JSON.parseObject((String)"{\n    \"description\": \"This is a sample server Petstore server.  You can find out more about     Swagger at [http://swagger.io](http://swagger.io) or on [irc.freenode.net, #swagger](http://swagger.io/irc/).      For this sample, you can use the api key `special-key` to test the authorization     filters.\",\n    \"version\": \"1.0.0\",\n    \"title\": \"Swagger Petstore\",\n    \"termsOfService\": \"http://swagger.io/terms/\",\n    \"contact\": {\n      \"email\": \"apiteam@swagger.io\"\n    },\n    \"license\": {\n      \"name\": \"Apache 2.0\",\n      \"url\": \"http://www.apache.org/licenses/LICENSE-2.0.html\"\n    }\n  }");
    private String host = "petstore.swagger.io";
    private String basePath = "/v2";
    private Set<Tags> tags;
    private String[] schemes = new String[]{"https", "http"};
    private Map<String, Map<RequestMethod, SwaggerApi>> paths;
    private Map<String, SwaggerApi.SwaggerProperty> definitions = Maps.newHashMap();
    private JSON externalDocs = JSON.parseObject((String)"{\n    \"description\": \"Find out more about Swagger\",\n    \"url\": \"http://swagger.io\"\n  }");

    public Swagger(List<TableModel> tableModels) {
        this.definitions.put("HttpStatus", SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.string).example("OK").enums(Arrays.stream(HttpStatus.class.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet())).build());
        this.tags = tableModels.stream().map(t -> Tags.builder().name(t.getRemarks()).description("\u7ba1\u7406" + t.getRemarks()).build()).collect(Collectors.toSet());
        this.paths = tableModels.stream().map(this::createApis).reduce((a, all) -> {
            all.putAll(a);
            return all;
        }).orElse(Maps.newHashMap());
    }

    private Map<String, Map<RequestMethod, SwaggerApi>> createApis(TableModel t) {
        ConcurrentMap result = Maps.newConcurrentMap();
        ConcurrentMap map = Maps.newConcurrentMap();
        this.addApi(t, map);
        this.updateApi(t, map);
        this.deleteApi(t, map);
        String baseUrl = "/api/" + t.getModelName() + "/" + t.getLowerName();
        result.put(baseUrl, map);
        ConcurrentMap map1 = Maps.newConcurrentMap();
        this.findByIdApi(t, map1);
        result.put(baseUrl + "/{id}", map1);
        ConcurrentMap map2 = Maps.newConcurrentMap();
        this.pageApi(t, map2);
        result.put(baseUrl + "/page", map2);
        ConcurrentMap map3 = Maps.newConcurrentMap();
        this.importApi(t, map3);
        this.exportApi(t, map3);
        result.put(baseUrl + "/store", map3);
        Optional<ColumnModel> isTree = t.getColumns().stream().filter(c -> c instanceof ParentKeyColumn).findAny();
        if (isTree.isPresent()) {
            ConcurrentMap map4 = Maps.newConcurrentMap();
            this.treeApi(t, map4);
            result.put(baseUrl + "/tree", map4);
        }
        return result;
    }

    private void deleteApi(TableModel t, Map<RequestMethod, SwaggerApi> map) {
        map.put(RequestMethod.DELETE, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).summary("\u5220\u9664" + t.getRemarks()).operationId("delete_" + t.getJavaName()).parameters(this.createParameter(SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.query).name("id").required(true).type(SwaggerPropertyType.array).description("\u552f\u4e00\u6807\u8bc6").items(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.string).build()).build())).responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(Swagger.this.properties(null)).build());
            }
        }).build());
    }

    private void findByIdApi(final TableModel t, Map<RequestMethod, SwaggerApi> map) {
        map.put(RequestMethod.GET, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).summary("\u6839\u636e\u4e3b\u952e\u67e5\u8be2" + t.getRemarks()).operationId("findById_" + t.getJavaName()).parameters(this.createParameter(SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.path).name("id").required(true).type(SwaggerPropertyType.string).build())).responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(Swagger.this.properties(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object).title("\u67e5\u8be2\u7ed3\u679c").properties((Map)t.getColumns().stream().collect(Swagger.this.getColumnModelMapCollector())).build())).build());
            }
        }).build());
    }

    private Collector<ColumnModel, ?, Map<String, SwaggerApi.SwaggerProperty>> getColumnModelMapCollector() {
        return Collectors.toMap(ColumnModel::getJavaName, c -> {
            SwaggerApi.SwaggerProperty v = SwaggerApi.SwaggerProperty.builder().type(this.swaggerPropertyType((ColumnModel)c)).required(c.getJavaName()).title(c.getRemarks()).format(this.swaggerPropertyFormat((ColumnModel)c)).build();
            if (SwaggerPropertyType.array == v.getType()) {
                v.setItems(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.string).build());
            }
            return v;
        });
    }

    private void treeApi(TableModel t, Map<RequestMethod, SwaggerApi> map) {
        final SwaggerApi.ResponseData value = SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(this.properties(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.array).items(SwaggerApi.SwaggerProperty.builder().property("id", SwaggerApi.SwaggerProperty.builder().title("\u552f\u4e00\u6807\u8bc6").type(SwaggerPropertyType.string).build()).property("parentId", SwaggerApi.SwaggerProperty.builder().title("\u7236\u7ea7\u552f\u4e00\u6807\u8bc6").type(SwaggerPropertyType.string).build()).property("children", SwaggerApi.SwaggerProperty.builder().title("\u5b50\u8282\u70b9").type(SwaggerPropertyType.array).items(SwaggerApi.SwaggerProperty.builder().property("id", SwaggerApi.SwaggerProperty.builder().title("\u552f\u4e00\u6807\u8bc6").type(SwaggerPropertyType.string).build()).property("parentId", SwaggerApi.SwaggerProperty.builder().title("\u7236\u7ea7\u552f\u4e00\u6807\u8bc6").type(SwaggerPropertyType.string).build()).property("children", SwaggerApi.SwaggerProperty.builder().title("\u5b50\u8282\u70b9").type(SwaggerPropertyType.array).items(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object).build()).build()).properties(t.getColumns().stream().filter(ColumnModel::isGeneric).collect(this.getColumnModelMapCollector())).build()).build()).properties(t.getColumns().stream().filter(ColumnModel::isGeneric).collect(this.getColumnModelMapCollector())).build()).title("\u67e5\u8be2\u7ed3\u679c").build())).build();
        map.put(RequestMethod.POST, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).description(t.getRemarks() + "\u6811\u5f62").summary(t.getRemarks() + "\u6811\u5f62").operationId("tree_" + t.getJavaName()).consumes(new String[]{"application/json"}).parameters(this.createParameter(new SwaggerApi.SwaggerApiParameter[0])).responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", value);
            }
        }).build());
    }

    private void pageApi(final TableModel t, Map<RequestMethod, SwaggerApi> map) {
        SwaggerApi.SwaggerProperty.Builder build = SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object).property("pageSize", SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.integer).defaults(10).format(SwaggerPropertyFormat.int32).title("\u6bcf\u9875\u5927\u5c0f").build()).property("pageNum", SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.integer).defaults(1).format(SwaggerPropertyFormat.int32).title("\u7b2c\u51e0\u9875").build());
        t.getColumns().stream().filter(ColumnModel::isGeneric).forEach(c -> build.property(c.getJavaName(), SwaggerApi.SwaggerProperty.builder().type(this.swaggerPropertyType((ColumnModel)c)).format(this.swaggerPropertyFormat((ColumnModel)c)).title(c.getRemarks()).build()).build());
        SwaggerApi.SwaggerApiParameter swaggerApiParameter = SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.body).name("\u8bf7\u6c42\u53c2\u6570").required(true).schema(build.build()).build();
        map.put(RequestMethod.POST, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).description(t.getRemarks() + "\u5206\u9875").summary(t.getRemarks() + "\u5206\u9875").operationId("page_" + t.getJavaName()).consumes(new String[]{"application/json"}).parameters(this.createParameter(swaggerApiParameter)).responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(Swagger.this.properties(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object).title("\u67e5\u8be2\u7ed3\u679c").required("total").property("total", SwaggerApi.SwaggerProperty.builder().title("\u603b\u6761\u6570").type(SwaggerPropertyType.integer).format(SwaggerPropertyFormat.int32).defaults(20).build()).property("context", SwaggerApi.SwaggerProperty.builder().title("\u5f53\u524d\u9875\u9762\u6570\u636e").type(SwaggerPropertyType.array).items(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object).required((String[])t.getColumns().stream().map(ColumnModel::getJavaName).toArray(String[]::new)).properties((Map)t.getColumns().stream().collect(Swagger.this.getColumnModelMapCollector())).build()).build()).build())).build());
            }
        }).build());
    }

    private void importApi(TableModel t, Map<RequestMethod, SwaggerApi> map) {
        SwaggerApi.SwaggerApiParameter swaggerApiParameter = SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.formData).description("\u5bfc\u5165\u6587\u4ef6").type(SwaggerPropertyType.file).name("\u8bf7\u6c42\u53c2\u6570").required(true).build();
        map.put(RequestMethod.POST, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).description(t.getRemarks() + "\u6279\u91cf\u5bfc\u5165").summary(t.getRemarks() + "\u6279\u91cf\u5bfc\u5165").operationId("import_" + t.getJavaName()).consumes(new String[]{"application/json"}).parameters(this.createParameter(swaggerApiParameter)).responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(Swagger.this.properties(null)).build());
            }
        }).build());
    }

    private void exportApi(TableModel t, Map<RequestMethod, SwaggerApi> map) {
        map.put(RequestMethod.GET, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).summary("\u5bfc\u51fa" + t.getRemarks()).operationId("export_" + t.getJavaName()).parameters(this.createParameter(SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.query).name("id").required(true).type(SwaggerPropertyType.array).description("\u552f\u4e00\u6807\u8bc6").items(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.string).build()).build())).description("\u5f53\u5bfc\u51fa\u6570\u91cf\u5c0f\u4e8e1000\u6761\u6570\u636e\u65f6\uff0c\u76f4\u63a5\u63d0\u4f9b\u6d4f\u89c8\u5668\u6587\u4ef6\u4e0b\u8f7d\uff1b\n\u5f53\u5bfc\u51fa\u6570\u91cf\u8d85\u8fc71000\u6761\u6570\u636e\u65f6,\u7cfb\u7edf\u81ea\u52a8\u5c06\u5bfc\u51fa\u6587\u4ef6\u8f6c\u81f3\u4e0b\u8f7d\u4e2d\u5fc3\uff0c\u5e76\u8fd4\u56de\u54cd\u5e94\u63d0\u793a").responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(Swagger.this.properties(null)).build());
            }
        }).build());
    }

    private void addApi(final TableModel t, Map<RequestMethod, SwaggerApi> map) {
        SwaggerApi.SwaggerProperty.Builder build = SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object);
        t.getColumns().stream().filter(ColumnModel::isGeneric).forEach(c -> build.property(c.getJavaName(), SwaggerApi.SwaggerProperty.builder().type(this.swaggerPropertyType((ColumnModel)c)).format(this.swaggerPropertyFormat((ColumnModel)c)).title(c.getRemarks()).build()).build());
        SwaggerApi.SwaggerApiParameter swaggerApiParameter = SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.body).name("\u8bf7\u6c42\u53c2\u6570").required(true).schema(build.build()).build();
        map.put(RequestMethod.POST, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).summary("\u65b0\u5efa" + t.getRemarks()).operationId("add_" + t.getJavaName()).consumes(new String[]{"application/json"}).parameters(this.createParameter(swaggerApiParameter)).responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(Swagger.this.properties(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object).title("\u65b0\u589e\u540e\u7684\u6570\u636e").properties((Map)t.getColumns().stream().collect(Swagger.this.getColumnModelMapCollector())).build())).build());
            }
        }).build());
    }

    private void updateApi(final TableModel t, Map<RequestMethod, SwaggerApi> map) {
        SwaggerApi.SwaggerProperty.Builder build = SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object);
        t.getColumns().stream().filter(c -> c.isGeneric() || c instanceof PrimaryKeyColumn).forEach(c -> build.property(c.getJavaName(), SwaggerApi.SwaggerProperty.builder().type(this.swaggerPropertyType((ColumnModel)c)).format(this.swaggerPropertyFormat((ColumnModel)c)).title(c.getRemarks()).build()).build());
        build.property("id", SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.array).items(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.string).build()).title("\u552f\u4e00\u6807\u8bc6").description("\u5f53\u4e3a\u6570\u7ec4\u65f6\uff0c\u89c6\u4e3a\u6279\u91cf\u4fee\u6539\u3002\u8be5\u53c2\u6570\u4e0e\u4e3b\u952e\u53c2\u6570\u81f3\u5c11\u6709\u4e00\u4e2a\u4e3a\u975e\u7a7a").build());
        SwaggerApi.SwaggerApiParameter swaggerApiParameter = SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.body).name("\u8bf7\u6c42\u53c2\u6570").required(true).schema(build.build()).build();
        map.put(RequestMethod.PUT, SwaggerApi.builder().tags(Sets.newHashSet((Object[])new String[]{t.getRemarks()})).summary("\u4fee\u6539" + t.getRemarks()).operationId("update_" + t.getJavaName()).consumes(new String[]{"application/json"}).parameters(this.createParameter(swaggerApiParameter)).responses((Map<String, SwaggerApi.ResponseData>)new HashMap<String, SwaggerApi.ResponseData>(){
            {
                this.put("200", SwaggerApi.ResponseData.builder().description("\u64cd\u4f5c\u6210\u529f").schema(Swagger.this.properties(SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.object).title("\u66f4\u65b0\u540e\u7684\u6570\u636e").properties((Map)t.getColumns().stream().collect(Swagger.this.getColumnModelMapCollector())).build())).build());
            }
        }).build());
    }

    private SwaggerApi.SwaggerProperty properties(SwaggerApi.SwaggerProperty swaggerProperty) {
        SwaggerApi.SwaggerProperty.Builder propertyBuilder = SwaggerApi.SwaggerProperty.builder();
        propertyBuilder.type(SwaggerPropertyType.object);
        propertyBuilder.required("head", "result").property("head", SwaggerApi.SwaggerProperty.builder().title("\u54cd\u5e94\u5934").type(SwaggerPropertyType.object).required("ip").property("ip", SwaggerApi.SwaggerProperty.builder().title("\u670d\u52a1\u5668IP").type(SwaggerPropertyType.string).example("11.66.77.116").build()).required("code").property("code", SwaggerApi.SwaggerProperty.builder().title("\u4e1a\u52a1\u4ee3\u7801").description("6\u4f4d\u4e1a\u52a1\u4ee3\u7801\uff0c\u7b2c\u4e00\u4f4d\uff080\u4ee3\u8868\u6210\u529f\uff0c1\u4ee3\u8868\u5931\u8d25\uff0c2\u4ee3\u8868\u9519\u8bef\uff0c3\u4ee3\u8868\u8b66\u544a\uff09\u3002\u7b2c\u4e8c\u3001\u4e09\u4f4d\u4ee3\u8868\u4e1a\u52a1\u9886\u57df\u7f16\u53f7\u3002\u540e\u4e09\u4f4d\u4ee3\u8868\u5b9e\u9645\u4e1a\u52a1\u670d\u52a1").type(SwaggerPropertyType.string).example("000000").build()).required("msg").property("msg", SwaggerApi.SwaggerProperty.builder().title("\u54cd\u5e94\u4fe1\u606f").description("\u53ef\u7528\u4e8e\u524d\u7aef\u5192\u6ce1\u63d0\u793a\u6846").type(SwaggerPropertyType.string).example("\u670d\u52a1\u6267\u884c\u6210\u529f").build()).required("status").property("status", SwaggerApi.SwaggerProperty.builder().ref("HttpStatus").build()).build());
        if (swaggerProperty == null) {
            swaggerProperty = SwaggerApi.SwaggerProperty.builder().type(SwaggerPropertyType.string).defaults(null).build();
        }
        propertyBuilder.required("result").property("result", swaggerProperty);
        return propertyBuilder.build();
    }

    private SwaggerPropertyType swaggerPropertyType(ColumnModel c) {
        SwaggerPropertyType type = NumberUtil.isNumber(c.getJavaType()) && Long.class != c.getJavaType() ? SwaggerPropertyType.integer : (c.getJavaType().isArray() || Collection.class.isAssignableFrom(c.getJavaType()) ? SwaggerPropertyType.array : (Boolean.class == c.getJavaType() ? SwaggerPropertyType.booleanc : SwaggerPropertyType.string));
        return type;
    }

    private SwaggerPropertyFormat swaggerPropertyFormat(ColumnModel c) {
        SwaggerPropertyFormat format = Long.class == c.getJavaType() ? SwaggerPropertyFormat.int64 : (Integer.class == c.getJavaType() ? SwaggerPropertyFormat.int32 : (Double.class == c.getJavaType() ? SwaggerPropertyFormat.doublec : (Float.class == c.getJavaType() ? SwaggerPropertyFormat.floatc : (Date.class.isAssignableFrom(c.getJavaType()) ? SwaggerPropertyFormat.date_time : null))));
        return format;
    }

    private Set<SwaggerApi.SwaggerApiParameter> createParameter(SwaggerApi.SwaggerApiParameter ... parameters) {
        HashSet parameterSet = parameters != null ? Sets.newHashSet((Object[])parameters) : Sets.newHashSet();
        parameterSet.add(SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.header).name("token").required(true).description("\u8eab\u4efd\u4f1a\u8bdd\u4ee4\u724c").type(SwaggerPropertyType.string).build());
        parameterSet.add(SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.header).name("replayToken").required(true).description("\u9632\u91cd\u653e\u4ee4\u724c\uff1aRSA\u52a0\u5bc6(\u65f6\u95f4\u6233+_SPLIT_+8\u4f4d\u968f\u673a\u6570)").type(SwaggerPropertyType.string).build());
        parameterSet.add(SwaggerApi.SwaggerApiParameter.builder().in(SwaggerApi.IN.header).name("falsifyToken").required(true).description("\u9632\u7be1\u6539\u4ee4\u724c\uff1aRSA\u52a0\u5bc6(body\u53c2\u6570)").type(SwaggerPropertyType.string).build());
        return parameterSet;
    }

    public String getSwagger() {
        return this.swagger;
    }

    public JSON getInfo() {
        return this.info;
    }

    public String getHost() {
        return this.host;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Set<Tags> getTags() {
        return this.tags;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public Map<String, Map<RequestMethod, SwaggerApi>> getPaths() {
        return this.paths;
    }

    public Map<String, SwaggerApi.SwaggerProperty> getDefinitions() {
        return this.definitions;
    }

    public JSON getExternalDocs() {
        return this.externalDocs;
    }

    public void setSwagger(String swagger) {
        this.swagger = swagger;
    }

    public void setInfo(JSON info) {
        this.info = info;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setTags(Set<Tags> tags) {
        this.tags = tags;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public void setPaths(Map<String, Map<RequestMethod, SwaggerApi>> paths) {
        this.paths = paths;
    }

    public void setDefinitions(Map<String, SwaggerApi.SwaggerProperty> definitions) {
        this.definitions = definitions;
    }

    public void setExternalDocs(JSON externalDocs) {
        this.externalDocs = externalDocs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Swagger)) {
            return false;
        }
        Swagger other = (Swagger)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$swagger = this.getSwagger();
        String other$swagger = other.getSwagger();
        if (this$swagger == null ? other$swagger != null : !this$swagger.equals(other$swagger)) {
            return false;
        }
        JSON this$info = this.getInfo();
        JSON other$info = other.getInfo();
        if (this$info == null ? other$info != null : !this$info.equals(other$info)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$basePath = this.getBasePath();
        String other$basePath = other.getBasePath();
        if (this$basePath == null ? other$basePath != null : !this$basePath.equals(other$basePath)) {
            return false;
        }
        Set<Tags> this$tags = this.getTags();
        Set<Tags> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSchemes(), other.getSchemes())) {
            return false;
        }
        Map<String, Map<RequestMethod, SwaggerApi>> this$paths = this.getPaths();
        Map<String, Map<RequestMethod, SwaggerApi>> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        Map<String, SwaggerApi.SwaggerProperty> this$definitions = this.getDefinitions();
        Map<String, SwaggerApi.SwaggerProperty> other$definitions = other.getDefinitions();
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        JSON this$externalDocs = this.getExternalDocs();
        JSON other$externalDocs = other.getExternalDocs();
        return !(this$externalDocs == null ? other$externalDocs != null : !this$externalDocs.equals(other$externalDocs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Swagger;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $swagger = this.getSwagger();
        result = result * 59 + ($swagger == null ? 43 : $swagger.hashCode());
        JSON $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : $info.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $basePath = this.getBasePath();
        result = result * 59 + ($basePath == null ? 43 : $basePath.hashCode());
        Set<Tags> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSchemes());
        Map<String, Map<RequestMethod, SwaggerApi>> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        Map<String, SwaggerApi.SwaggerProperty> $definitions = this.getDefinitions();
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        JSON $externalDocs = this.getExternalDocs();
        result = result * 59 + ($externalDocs == null ? 43 : $externalDocs.hashCode());
        return result;
    }

    public String toString() {
        return "Swagger(swagger=" + this.getSwagger() + ", info=" + this.getInfo() + ", host=" + this.getHost() + ", basePath=" + this.getBasePath() + ", tags=" + this.getTags() + ", schemes=" + Arrays.deepToString(this.getSchemes()) + ", paths=" + this.getPaths() + ", definitions=" + this.getDefinitions() + ", externalDocs=" + this.getExternalDocs() + ")";
    }
}

