/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.db.DataBaseUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.properties.PropertiesUtil;
import cloud.agileframework.generator.config.GeneratorConfig;
import cloud.agileframework.generator.handler.ByAllTableGenerator;
import cloud.agileframework.generator.handler.ByTableGenerator;
import cloud.agileframework.generator.model.TableModel;
import cloud.agileframework.generator.properties.GeneratorProperties;
import cloud.agileframework.spring.util.BeanUtil;
import com.google.common.collect.Lists;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class AgileGenerator {
    private static final Logger logger = LoggerFactory.getLogger(AgileGenerator.class);
    private static DataSourceProperties dataSourceProperties;
    private static GeneratorProperties generator;

    private static List<Map<String, Object>> getTableInfo(String tables) {
        return DataBaseUtil.listTables((String)dataSourceProperties.getUrl(), (String)dataSourceProperties.getUsername(), (String)dataSourceProperties.getPassword(), (String)tables);
    }

    private static void initSpringContext() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        BeanUtil.setApplicationContext((ApplicationContext)context);
        StandardEnvironment environment = new StandardEnvironment();
        PropertiesPropertySource localPropertySource = new PropertiesPropertySource("localProperties", PropertiesUtil.getProperties());
        environment.getPropertySources().addLast((PropertySource)localPropertySource);
        context.setEnvironment((ConfigurableEnvironment)environment);
        context.register(new Class[]{GeneratorConfig.class});
        context.refresh();
        dataSourceProperties = (DataSourceProperties)BeanUtil.getBean(DataSourceProperties.class);
        generator = (GeneratorProperties)BeanUtil.getBean(GeneratorProperties.class);
    }

    public static void init() {
        AgileGenerator.initSpringContext();
    }

    static void generator() {
        String tableNames = generator.getTableName();
        if (tableNames.contains(";")) {
            Arrays.stream(tableNames.split(";")).forEach(AgileGenerator::generator);
        }
        AgileGenerator.generator(tableNames);
    }

    private static void generator(String tableNames) {
        List<Map<String, Object>> tables = AgileGenerator.getTableInfo(tableNames);
        if (tables == null || tables.isEmpty()) {
            throw new RuntimeException("\u672a\u52a0\u8f7d\u5230\u4efb\u4f55\u6570\u636e\u5e93\u8868\u4fe1\u606f");
        }
        ArrayList allTableModel = Lists.newArrayList();
        for (Map<String, Object> table : tables) {
            TableModel tableModel = (TableModel)ObjectUtil.to(table, (TypeReference)new TypeReference<TableModel>(){});
            BeanUtil.getApplicationContext().getBeanProvider(ByTableGenerator.class).stream().filter(g -> g.is(generator.getTypes())).forEach(g -> {
                try {
                    g.generateFile(tableModel);
                    allTableModel.add(tableModel);
                }
                catch (TemplateException | IOException e) {
                    e.printStackTrace();
                }
            });
        }
        BeanUtil.getApplicationContext().getBeanProvider(ByAllTableGenerator.class).stream().filter(g -> g.is(generator.getTypes())).forEach(g -> {
            try {
                g.generateFile(allTableModel);
            }
            catch (TemplateException | IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void main(String[] args) {
        try {
            logger.info("\u30101\u3011\u5f00\u59cb\u751f\u6210\u6e90\u4ee3\u7801");
            AgileGenerator.init();
            logger.info("\u30102\u3011\u5b8c\u6210\u914d\u7f6e\u521d\u59cb\u5316\uff0c\u5f00\u59cb\u751f\u6210\u6587\u4ef6...");
            AgileGenerator.generator();
            logger.info("\u30103\u3011\u5b8c\u6210\u6e90\u4ee3\u7801\u751f\u6210");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

