/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model;

import cloud.agileframework.common.annotation.Remark;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.db.DataBaseUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.dictionary.annotation.Dictionary;
import cloud.agileframework.dictionary.annotation.DirectionType;
import cloud.agileframework.generator.model.BaseModel;
import cloud.agileframework.generator.model.ColumnModel;
import cloud.agileframework.generator.model.CreateTimeColumn;
import cloud.agileframework.generator.model.CreateUserColumn;
import cloud.agileframework.generator.model.DeleteColumn;
import cloud.agileframework.generator.model.DicColumn;
import cloud.agileframework.generator.model.FExportKeyColumn;
import cloud.agileframework.generator.model.FImportKeyColumn;
import cloud.agileframework.generator.model.ParentKeyColumn;
import cloud.agileframework.generator.model.PrimaryKeyColumn;
import cloud.agileframework.generator.model.UpdateTimeColumn;
import cloud.agileframework.generator.model.UpdateUserColumn;
import cloud.agileframework.generator.model.config.PropertyBaseValue;
import cloud.agileframework.generator.model.config.PropertyConfig;
import cloud.agileframework.generator.model.config.PropertyDicValue;
import cloud.agileframework.generator.properties.AnnotationType;
import cloud.agileframework.spring.util.BeanUtil;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

public class TableModel
extends BaseModel {
    private String moduleName = BeanUtil.getApplicationContext().getId();
    private String tableCat;
    private String tableName;
    private String selfReferencingColName;
    private String tableSchem;
    private String typeSchem;
    private String typeCat;
    private String tableType;
    private String refGeneration;
    private String typeName;
    private String javaName;
    private String mvcPackageName;
    private String serviceName;
    private String entityName;
    private String entityCenterLineName;
    private String doName;
    private String inVoName;
    private String outVoName;
    private String lowerName;
    private String modelName;
    private String servicePackageName;
    private String entityPackageName;
    private String voPackageName;
    private String doPackageName;
    private String controllerPackageName;
    private Set<ColumnModel> columns = Sets.newHashSet();
    private Set<ColumnModel> newColumns = Sets.newHashSet();
    private boolean haveSetMethod;
    private boolean haveGetMethod;
    private boolean haveEqualsAndHashCodeMethod = true;
    private Set<FImportKeyColumn> fImportKeyColumns;
    private Set<FExportKeyColumn> fExportKeyColumns;

    public void build() {
        this.columns.forEach(c -> {
            c.build();
            this.setImport(c.getImports());
        });
        this.newColumns.forEach(c -> {
            c.build();
            this.setImport(c.getImports());
        });
    }

    public void addColumn(ColumnModel columns) {
        this.columns.add(columns);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.modelName = tableName.substring(0, tableName.indexOf("_"));
        this.mvcPackageName = tableName.replaceFirst("_bt_", "_").substring(tableName.indexOf("_") + 1).replace("_", "");
        this.javaName = StringUtil.toUpperName((String)tableName);
        this.lowerName = StringUtil.toLowerName((String)tableName);
        this.fExportKeysHandler(tableName);
        this.fImportKeysHandler(tableName);
        List columnInfos = DataBaseUtil.listColumns((String)TableModel.getDataSourceProperties().getUrl(), (String)TableModel.getDataSourceProperties().getUsername(), (String)TableModel.getDataSourceProperties().getPassword(), (String)tableName);
        for (Map column : columnInfos) {
            ColumnModel columnModel = PrimaryKeyColumn.is(column) ? (ColumnModel)ObjectUtil.getObjectFromMap(PrimaryKeyColumn.class, (Map)column) : (DeleteColumn.is(column) ? (ColumnModel)ObjectUtil.getObjectFromMap(DeleteColumn.class, (Map)column) : (CreateTimeColumn.is(column) ? (ColumnModel)ObjectUtil.getObjectFromMap(CreateTimeColumn.class, (Map)column) : (UpdateTimeColumn.is(column) ? (ColumnModel)ObjectUtil.getObjectFromMap(UpdateTimeColumn.class, (Map)column) : (CreateUserColumn.is(column) ? (ColumnModel)ObjectUtil.getObjectFromMap(CreateUserColumn.class, (Map)column) : (UpdateUserColumn.is(column) ? (ColumnModel)ObjectUtil.getObjectFromMap(UpdateUserColumn.class, (Map)column) : (ParentKeyColumn.is(column) ? (ColumnModel)ObjectUtil.getObjectFromMap(ParentKeyColumn.class, (Map)column) : (FImportKeyColumn.is(column, this.fImportKeyColumns) ? (ColumnModel)ObjectUtil.getObjectFromMap(FImportKeyColumn.class, (Map)column) : (ColumnModel)ObjectUtil.getObjectFromMap(ColumnModel.class, (Map)column))))))));
            this.addColumn(columnModel);
        }
        Set newC = this.getColumns().stream().filter(c -> c.getPropertyConfig() != null).map(c -> {
            PropertyConfig propertyConfig = c.getPropertyConfig();
            PropertyBaseValue value = propertyConfig.getValue();
            if (value instanceof PropertyDicValue) {
                return this.parseNewColumn((ColumnModel)c, value);
            }
            return null;
        }).collect(Collectors.toSet());
        this.newColumns.addAll(newC);
        this.serviceName = TableModel.getProperties().getServicePrefix() + this.javaName + TableModel.getProperties().getServiceSuffix();
        this.entityName = TableModel.getProperties().getEntityPrefix() + this.javaName + TableModel.getProperties().getEntitySuffix();
        this.doName = this.javaName + "Do";
        this.inVoName = this.javaName + "InVo";
        this.outVoName = this.javaName + "OutVo";
        this.entityCenterLineName = StringUtil.toUnderline((String)this.javaName).replace("_", "-").toLowerCase();
        if (ArrayUtils.contains((Object[])TableModel.getProperties().getAnnotation(), (Object)((Object)AnnotationType.JPA)) || ArrayUtils.contains((Object[])TableModel.getProperties().getAnnotation(), (Object)((Object)AnnotationType.VALIDATE))) {
            this.addAnnotation(Setter.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation(Builder.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation(ToString.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        } else {
            this.addAnnotation(Data.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
        this.addAnnotation(AllArgsConstructor.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.addAnnotation(NoArgsConstructor.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.addAnnotation(Entity.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.addAnnotation((Annotation)new Table(){

            public Class<? extends Annotation> annotationType() {
                return Table.class;
            }

            public String name() {
                return BaseModel.toBlank(TableModel.this.getTableName());
            }

            public String catalog() {
                return BaseModel.toBlank(TableModel.this.getTableCat());
            }

            public String schema() {
                return BaseModel.toBlank(TableModel.this.getTableSchem());
            }

            public UniqueConstraint[] uniqueConstraints() {
                return new UniqueConstraint[0];
            }

            public Index[] indexes() {
                return new Index[0];
            }
        }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.hibernateAnnotationHandler();
        this.haveSetMethod = !this.getImports().contains(Setter.class) && !this.getImports().contains(Data.class);
        this.haveGetMethod = !this.getImports().contains(Getter.class) && !this.getImports().contains(Data.class);
        this.setImport(Objects.class);
    }

    private ColumnModel parseNewColumn(final ColumnModel c, final PropertyBaseValue value) {
        ColumnModel c1 = (ColumnModel)ObjectUtil.to((Object)c, (TypeReference)new TypeReference<DicColumn>(){});
        c1.setColumnName(c.getColumnName() + "_name");
        c1.getAnnotationDesc().clear();
        c1.getFieldAnnotationDesc().clear();
        c1.addAnnotation((Annotation)new Dictionary(){

            public Class<? extends Annotation> annotationType() {
                return Dictionary.class;
            }

            public String dicCode() {
                return value.getValue();
            }

            public String[] fieldName() {
                return new String[]{c.getJavaName()};
            }

            public boolean isFull() {
                return false;
            }

            public String split() {
                return "/";
            }

            public DirectionType directionType() {
                return DirectionType.CODE_TO_NAME;
            }

            public String defaultValue() {
                return "null";
            }

            public boolean id() {
                return false;
            }

            public String dataSource() {
                return "DICTIONARY_DATA_CACHE";
            }
        }, AnnotationType.AGILE, (String desc) -> c1.getDicAnnotationDesc().add((String)desc));
        return c1;
    }

    private void fExportKeysHandler(String tableName) {
        List fKeys = DataBaseUtil.listFKeys((String)TableModel.getDataSourceProperties().getUrl(), (String)TableModel.getDataSourceProperties().getUsername(), (String)TableModel.getDataSourceProperties().getPassword(), (String)tableName);
        HashSet cache = Sets.newHashSet();
        fKeys.forEach(fk -> {
            FExportKeyColumn columnModel = (FExportKeyColumn)ObjectUtil.getObjectFromMap(FExportKeyColumn.class, (Map)fk);
            if (cache.contains(columnModel.getFktableName())) {
                columnModel.setFktableName(columnModel.getFktableName() + 1);
            }
            cache.add(columnModel.getFktableName());
            this.addFExportKeyColumns(columnModel);
        });
        this.fImportKeysHandler(tableName);
    }

    private void fImportKeysHandler(String tableName) {
        List fImportKeys = DataBaseUtil.listFImportKeys((String)TableModel.getDataSourceProperties().getUrl(), (String)TableModel.getDataSourceProperties().getUsername(), (String)TableModel.getDataSourceProperties().getPassword(), (String)tableName);
        fImportKeys.forEach(fk -> {
            FImportKeyColumn columnModel = (FImportKeyColumn)ObjectUtil.getObjectFromMap(FImportKeyColumn.class, (Map)fk);
            this.addFImportKeyColumns(columnModel);
        });
    }

    private void addFImportKeyColumns(FImportKeyColumn columnModel) {
        if (this.fImportKeyColumns == null) {
            this.fImportKeyColumns = Sets.newHashSet();
        }
        this.fImportKeyColumns.add(columnModel);
    }

    private void addFExportKeyColumns(FExportKeyColumn columnModel) {
        if (this.fExportKeyColumns == null) {
            this.fExportKeyColumns = Sets.newHashSet();
        }
        this.fExportKeyColumns.add(columnModel);
    }

    private void hibernateAnnotationHandler() {
        final Set primaryColumns = this.columns.stream().filter(c -> c instanceof PrimaryKeyColumn).map(c -> (PrimaryKeyColumn)c).collect(Collectors.toSet());
        final Set deleteColumns = this.columns.stream().filter(c -> c instanceof DeleteColumn).map(c -> (DeleteColumn)c).collect(Collectors.toSet());
        if (!deleteColumns.isEmpty()) {
            this.addAnnotation((Annotation)new Where(){

                public Class<? extends Annotation> annotationType() {
                    return Where.class;
                }

                public String clause() {
                    return deleteColumns.stream().map(c -> c.getColumnName() + " = " + c.getNoDelete()).collect(Collectors.joining(" and "));
                }
            }, AnnotationType.HIBERNATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation((Annotation)new SQLDelete(){

                public Class<? extends Annotation> annotationType() {
                    return SQLDelete.class;
                }

                public String sql() {
                    String set = deleteColumns.stream().map(c -> c.getColumnName() + " = " + c.getDeleted()).collect(Collectors.joining(", "));
                    String where = primaryColumns.stream().map(c -> c.getColumnName() + " = ?").collect(Collectors.joining(" and "));
                    return String.format("update %s set %s where %s", TableModel.this.getTableName(), set, where);
                }

                public boolean callable() {
                    return false;
                }

                public ResultCheckStyle check() {
                    return ResultCheckStyle.NONE;
                }
            }, AnnotationType.HIBERNATE, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
    }

    @Override
    public void setRemarks(String remarks) {
        super.setRemarks(remarks);
        this.addAnnotation((Annotation)new Remark(){

            public Class<? extends Annotation> annotationType() {
                return Remark.class;
            }

            public String value() {
                return BaseModel.toBlank(TableModel.this.getRemarks());
            }

            public boolean ignoreCompare() {
                return false;
            }

            public boolean excelHead() {
                return true;
            }

            public int sort() {
                return 0;
            }
        }, AnnotationType.REMARK, (String desc) -> this.getAnnotationDesc().add((String)desc));
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setTableCat(String tableCat) {
        this.tableCat = tableCat;
    }

    public void setSelfReferencingColName(String selfReferencingColName) {
        this.selfReferencingColName = selfReferencingColName;
    }

    public void setTableSchem(String tableSchem) {
        this.tableSchem = tableSchem;
    }

    public void setTypeSchem(String typeSchem) {
        this.typeSchem = typeSchem;
    }

    public void setTypeCat(String typeCat) {
        this.typeCat = typeCat;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setRefGeneration(String refGeneration) {
        this.refGeneration = refGeneration;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public void setMvcPackageName(String mvcPackageName) {
        this.mvcPackageName = mvcPackageName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setEntityCenterLineName(String entityCenterLineName) {
        this.entityCenterLineName = entityCenterLineName;
    }

    public void setDoName(String doName) {
        this.doName = doName;
    }

    public void setInVoName(String inVoName) {
        this.inVoName = inVoName;
    }

    public void setOutVoName(String outVoName) {
        this.outVoName = outVoName;
    }

    public void setLowerName(String lowerName) {
        this.lowerName = lowerName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public void setVoPackageName(String voPackageName) {
        this.voPackageName = voPackageName;
    }

    public void setDoPackageName(String doPackageName) {
        this.doPackageName = doPackageName;
    }

    public void setControllerPackageName(String controllerPackageName) {
        this.controllerPackageName = controllerPackageName;
    }

    public void setColumns(Set<ColumnModel> columns) {
        this.columns = columns;
    }

    public void setNewColumns(Set<ColumnModel> newColumns) {
        this.newColumns = newColumns;
    }

    public void setHaveSetMethod(boolean haveSetMethod) {
        this.haveSetMethod = haveSetMethod;
    }

    public void setHaveGetMethod(boolean haveGetMethod) {
        this.haveGetMethod = haveGetMethod;
    }

    public void setHaveEqualsAndHashCodeMethod(boolean haveEqualsAndHashCodeMethod) {
        this.haveEqualsAndHashCodeMethod = haveEqualsAndHashCodeMethod;
    }

    public void setFImportKeyColumns(Set<FImportKeyColumn> fImportKeyColumns) {
        this.fImportKeyColumns = fImportKeyColumns;
    }

    public void setFExportKeyColumns(Set<FExportKeyColumn> fExportKeyColumns) {
        this.fExportKeyColumns = fExportKeyColumns;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getTableCat() {
        return this.tableCat;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSelfReferencingColName() {
        return this.selfReferencingColName;
    }

    public String getTableSchem() {
        return this.tableSchem;
    }

    public String getTypeSchem() {
        return this.typeSchem;
    }

    public String getTypeCat() {
        return this.typeCat;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getRefGeneration() {
        return this.refGeneration;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getMvcPackageName() {
        return this.mvcPackageName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityCenterLineName() {
        return this.entityCenterLineName;
    }

    public String getDoName() {
        return this.doName;
    }

    public String getInVoName() {
        return this.inVoName;
    }

    public String getOutVoName() {
        return this.outVoName;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getServicePackageName() {
        return this.servicePackageName;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public String getVoPackageName() {
        return this.voPackageName;
    }

    public String getDoPackageName() {
        return this.doPackageName;
    }

    public String getControllerPackageName() {
        return this.controllerPackageName;
    }

    public Set<ColumnModel> getColumns() {
        return this.columns;
    }

    public Set<ColumnModel> getNewColumns() {
        return this.newColumns;
    }

    public boolean isHaveSetMethod() {
        return this.haveSetMethod;
    }

    public boolean isHaveGetMethod() {
        return this.haveGetMethod;
    }

    public boolean isHaveEqualsAndHashCodeMethod() {
        return this.haveEqualsAndHashCodeMethod;
    }

    public Set<FImportKeyColumn> getFImportKeyColumns() {
        return this.fImportKeyColumns;
    }

    public Set<FExportKeyColumn> getFExportKeyColumns() {
        return this.fExportKeyColumns;
    }
}

