/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.handler;

import cloud.agileframework.generator.handler.ByTableGenerator;
import cloud.agileframework.generator.model.CreateTimeColumn;
import cloud.agileframework.generator.model.CreateUserColumn;
import cloud.agileframework.generator.model.DeleteColumn;
import cloud.agileframework.generator.model.PrimaryKeyColumn;
import cloud.agileframework.generator.model.TableModel;
import cloud.agileframework.generator.model.UpdateTimeColumn;
import cloud.agileframework.generator.model.UpdateUserColumn;
import cloud.agileframework.generator.properties.AnnotationType;
import cloud.agileframework.generator.properties.TYPE;
import cloud.agileframework.generator.util.FreemarkerUtil;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import lombok.experimental.SuperBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

public class AgileControllerGenerator
extends ByTableGenerator {
    @Override
    public String freemarkerTemplate() {
        return "AgileController.ftl";
    }

    @Override
    public String fileExtension() {
        return ".java";
    }

    @Override
    public TYPE type() {
        return TYPE.AGILE_CONTROLLER;
    }

    @Override
    public void generateFile(TableModel tableModel) throws TemplateException, IOException {
        tableModel.getColumns().removeIf(c -> c instanceof CreateTimeColumn || c instanceof UpdateTimeColumn || c instanceof CreateUserColumn || c instanceof UpdateUserColumn || c instanceof DeleteColumn);
        tableModel.getColumns().stream().filter(c -> c instanceof PrimaryKeyColumn).forEach(c -> {
            c.addAnnotation((Annotation)new GeneratedValue(){

                public Class<? extends Annotation> annotationType() {
                    return GeneratedValue.class;
                }

                public GenerationType strategy() {
                    return GenerationType.AUTO;
                }

                public String generator() {
                    return "custom-id";
                }
            }, AnnotationType.JPA, desc -> c.getAnnotationDesc().add((String)desc));
            c.addAnnotation((Annotation)new GenericGenerator(){

                public Class<? extends Annotation> annotationType() {
                    return GenericGenerator.class;
                }

                public String name() {
                    return "custom-id";
                }

                public String strategy() {
                    return "cloud.agileframework.jpa.dao.IDGenerator";
                }

                public Parameter[] parameters() {
                    return new Parameter[0];
                }
            }, AnnotationType.JPA, desc -> c.getAnnotationDesc().add((String)desc));
            tableModel.setImport(c.getImports());
        });
        tableModel.getAnnotationDesc().remove("@Builder");
        tableModel.addAnnotation(SuperBuilder.class, AnnotationType.LOMBOK, desc -> tableModel.getAnnotationDesc().add((String)desc));
        tableModel.build();
        String baseUrl = this.parseUrl(this.generator.getEntityUrl()) + tableModel.getModelName() + File.separator + tableModel.getMvcPackageName() + File.separator;
        String doUrl = baseUrl + "pojo" + File.separator + "db" + File.separator;
        String doFileName = tableModel.getDoName() + this.fileExtension();
        tableModel.setDoPackageName(this.getPackPath(doUrl));
        FreemarkerUtil.generatorProxy("AgileDo.ftl", doUrl, doFileName, tableModel, false);
        String voUrl = baseUrl + "pojo" + File.separator + "vo" + File.separator;
        String inVoFileName = tableModel.getInVoName() + this.fileExtension();
        tableModel.setVoPackageName(this.getPackPath(voUrl));
        FreemarkerUtil.generatorProxy("AgileInVo.ftl", voUrl, inVoFileName, tableModel, false);
        String outVoFileName = tableModel.getOutVoName() + this.fileExtension();
        tableModel.setVoPackageName(this.getPackPath(voUrl));
        FreemarkerUtil.generatorProxy("AgileOutVo.ftl", voUrl, outVoFileName, tableModel, false);
        String controllerUrl = baseUrl + "controller" + File.separator;
        String controllerFileName = tableModel.getJavaName() + "Controller" + this.fileExtension();
        tableModel.setControllerPackageName(this.getPackPath(controllerUrl));
        FreemarkerUtil.generatorProxy(this.freemarkerTemplate(), controllerUrl, controllerFileName, tableModel, false);
    }
}

