/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.util;

import cloud.agileframework.generator.AgileGenerator;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtil {
    private static final Logger logger = LoggerFactory.getLogger(FreemarkerUtil.class);
    private static final Configuration CFG = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    private static final String ENCODER = StandardCharsets.UTF_8.name();

    private static void initFreemarker() {
        try {
            CFG.setClassForTemplateLoading(AgileGenerator.class, "/cloud/agileframework/generator/template");
            CFG.setDefaultEncoding(ENCODER);
            CFG.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Template getTemplate(String name) {
        try {
            return CFG.getTemplate(name, ENCODER);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void generatorProxy(String templateUri, String directory, String fileName, Object data, boolean append) throws IOException, TemplateException {
        boolean f;
        Template template = FreemarkerUtil.getTemplate(templateUri);
        File serviceFileDir = new File(directory);
        if (!serviceFileDir.exists() && !(f = serviceFileDir.mkdirs())) {
            logger.error(String.format("\u65e0\u6cd5\u521b\u5efa\u4ee3\u7801\u751f\u6210\u8def\u5f84\uff1a%s", directory));
            return;
        }
        File serviceFile = new File(serviceFileDir.getPath() + File.separator + fileName);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("\u751f\u6210\u6587\u4ef6[%s]", serviceFile.getAbsoluteFile().getPath()));
        }
        BufferedWriter serviceFileBw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(serviceFile, append), ENCODER));
        assert (template != null);
        template.process(data, (Writer)serviceFileBw);
        serviceFileBw.flush();
        serviceFileBw.close();
    }

    static {
        FreemarkerUtil.initFreemarker();
    }
}

