/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.handler;

import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.generator.properties.GeneratorProperties;
import cloud.agileframework.generator.properties.TYPE;
import java.io.File;
import java.util.regex.Matcher;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGenerator {
    @Autowired
    GeneratorProperties generator;

    String getPackPath(String url) {
        String javaPath;
        url = this.parseUrl(url);
        String javaSourceUrl = this.parseUrl(this.generator.getJavaSourceUrl());
        if (StringUtil.isEmpty((CharSequence)javaSourceUrl) && !url.contains(javaPath = File.separator + "java" + File.separator)) {
            return null;
        }
        if ((url = url.substring(url.indexOf(javaSourceUrl) + javaSourceUrl.length())).length() > 0) {
            return url.substring(0, url.length() - 1).replaceAll(Matcher.quoteReplacement(File.separator), ".");
        }
        return null;
    }

    String parseUrl(String str) {
        String url = str.replaceAll("[\\\\/]+", Matcher.quoteReplacement(File.separator));
        if (!url.endsWith(File.separator)) {
            url = url + File.separator;
        }
        return url;
    }

    public boolean is(TYPE[] types) {
        return ArrayUtils.contains((Object[])types, (Object)((Object)this.type()));
    }

    public abstract String freemarkerTemplate();

    public abstract String fileExtension();

    public abstract TYPE type();
}

