/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model;

import cloud.agileframework.common.util.db.DataBaseUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.generator.annotation.Remark;
import cloud.agileframework.generator.model.BaseModel;
import cloud.agileframework.generator.model.ColumnModel;
import cloud.agileframework.generator.properties.AnnotationType;
import cloud.agileframework.spring.util.BeanUtil;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

public class TableModel
extends BaseModel {
    private String moduleName = BeanUtil.getApplicationContext().getId();
    private String tableCat;
    private String tableName;
    private String selfReferencingColName;
    private String tableSchem;
    private String typeSchem;
    private String typeCat;
    private String tableType;
    private String refGeneration;
    private String typeName;
    private String serviceName;
    private String entityName;
    private String entityCenterLineName;
    private String javaName;
    private String servicePackageName;
    private String entityPackageName;
    private Set<ColumnModel> columns = Sets.newHashSet();
    private boolean haveSetMethod;
    private boolean haveGetMethod;

    public void setColumn(ColumnModel columns) {
        this.columns.add(columns);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
        this.javaName = StringUtil.toUpperName((String)tableName);
        List columnInfos = DataBaseUtil.listColumns((String)TableModel.getDataSourceProperties().getUrl(), (String)TableModel.getDataSourceProperties().getUsername(), (String)TableModel.getDataSourceProperties().getPassword(), (String)tableName);
        for (Map column : columnInfos) {
            ColumnModel columnModel = (ColumnModel)ObjectUtil.getObjectFromMap(ColumnModel.class, (Map)column);
            columnModel.build();
            this.setImport(columnModel.getImports());
            this.setColumn(columnModel);
        }
        this.serviceName = TableModel.getProperties().getServicePrefix() + this.javaName + TableModel.getProperties().getServiceSuffix();
        this.entityName = TableModel.getProperties().getEntityPrefix() + this.javaName + TableModel.getProperties().getEntitySuffix();
        this.entityCenterLineName = StringUtil.toUnderline((String)this.javaName).replace("_", "-").toLowerCase();
        if (TableModel.getProperties().getAnnotation().contains((Object)AnnotationType.JPA) || TableModel.getProperties().getAnnotation().contains((Object)AnnotationType.VALIDATE)) {
            this.addAnnotation(Setter.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation(Builder.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation(EqualsAndHashCode.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
            this.addAnnotation(ToString.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        } else {
            this.addAnnotation(Data.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        }
        this.addAnnotation(AllArgsConstructor.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.addAnnotation(NoArgsConstructor.class, AnnotationType.LOMBOK, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.addAnnotation(Entity.class, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.addAnnotation((Annotation)new Table(){

            public Class<? extends Annotation> annotationType() {
                return Table.class;
            }

            public String name() {
                return BaseModel.toBlank(TableModel.this.getTableName());
            }

            public String catalog() {
                return BaseModel.toBlank(TableModel.this.getTableCat());
            }

            public String schema() {
                return BaseModel.toBlank(TableModel.this.getTableSchem());
            }

            public UniqueConstraint[] uniqueConstraints() {
                return new UniqueConstraint[0];
            }

            public Index[] indexes() {
                return new Index[0];
            }
        }, AnnotationType.JPA, (String desc) -> this.getAnnotationDesc().add((String)desc));
        this.haveSetMethod = !this.getImports().contains(Setter.class) && !this.getImports().contains(Data.class);
        this.haveGetMethod = !this.getImports().contains(Getter.class) && !this.getImports().contains(Data.class);
    }

    @Override
    public void setRemarks(String remarks) {
        super.setRemarks(remarks);
        this.addAnnotation(new Remark(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Remark.class;
            }

            @Override
            public String value() {
                return BaseModel.toBlank(TableModel.this.getRemarks());
            }
        }, AnnotationType.REMARK, (String desc) -> this.getAnnotationDesc().add((String)desc));
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setTableCat(String tableCat) {
        this.tableCat = tableCat;
    }

    public void setSelfReferencingColName(String selfReferencingColName) {
        this.selfReferencingColName = selfReferencingColName;
    }

    public void setTableSchem(String tableSchem) {
        this.tableSchem = tableSchem;
    }

    public void setTypeSchem(String typeSchem) {
        this.typeSchem = typeSchem;
    }

    public void setTypeCat(String typeCat) {
        this.typeCat = typeCat;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setRefGeneration(String refGeneration) {
        this.refGeneration = refGeneration;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setEntityCenterLineName(String entityCenterLineName) {
        this.entityCenterLineName = entityCenterLineName;
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public void setEntityPackageName(String entityPackageName) {
        this.entityPackageName = entityPackageName;
    }

    public void setColumns(Set<ColumnModel> columns) {
        this.columns = columns;
    }

    public void setHaveSetMethod(boolean haveSetMethod) {
        this.haveSetMethod = haveSetMethod;
    }

    public void setHaveGetMethod(boolean haveGetMethod) {
        this.haveGetMethod = haveGetMethod;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getTableCat() {
        return this.tableCat;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSelfReferencingColName() {
        return this.selfReferencingColName;
    }

    public String getTableSchem() {
        return this.tableSchem;
    }

    public String getTypeSchem() {
        return this.typeSchem;
    }

    public String getTypeCat() {
        return this.typeCat;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getRefGeneration() {
        return this.refGeneration;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityCenterLineName() {
        return this.entityCenterLineName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public String getServicePackageName() {
        return this.servicePackageName;
    }

    public String getEntityPackageName() {
        return this.entityPackageName;
    }

    public Set<ColumnModel> getColumns() {
        return this.columns;
    }

    public boolean isHaveSetMethod() {
        return this.haveSetMethod;
    }

    public boolean isHaveGetMethod() {
        return this.haveGetMethod;
    }
}

