/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.model;

import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.generator.annotation.Remark;
import cloud.agileframework.generator.properties.AnnotationType;
import cloud.agileframework.generator.properties.GeneratorProperties;
import cloud.agileframework.spring.util.BeanUtil;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class BaseModel {
    private static GeneratorProperties properties = (GeneratorProperties)BeanUtil.getBean(GeneratorProperties.class);
    private static DataSourceProperties dataSourceProperties = (DataSourceProperties)BeanUtil.getBean(DataSourceProperties.class);
    private Set<Class<?>> imports = Sets.newHashSet();
    private Set<String> importDesc = Sets.newHashSet();
    private Set<String> annotationDesc = Sets.newHashSet();
    private String remarks;

    public static String toBlank(String str) {
        return str == null ? "" : str;
    }

    public static String toString(Class<? extends Annotation> annotation, Consumer<Class<?>> consumer) {
        consumer.accept(annotation);
        return "@" + annotation.getSimpleName();
    }

    public static String toString(Annotation annotation, Consumer<Class<?>> consumer) {
        Class<? extends Annotation> type = annotation.annotationType();
        consumer.accept(type);
        Method[] methods = type.getDeclaredMethods();
        String inner = Arrays.stream(methods).filter(method -> {
            try {
                return !new EqualsBuilder().append(method.getDefaultValue(), method.invoke((Object)annotation, new Object[0])).isEquals();
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                return false;
            }
        }).map(method -> {
            try {
                Class<?> returnType = method.getReturnType();
                consumer.accept(returnType);
                Object value = method.invoke((Object)annotation, new Object[0]);
                String key = method.getName();
                if (value instanceof String) {
                    return String.format("%s = \"%s\"", key, value);
                }
                return String.format("%s = %s", key, returnType.isEnum() ? returnType.getSimpleName() + "." + value : value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.joining(", "));
        if (StringUtils.isEmpty((CharSequence)inner)) {
            return "@" + type.getSimpleName();
        }
        return String.format("@%s(%s)", type.getSimpleName(), inner);
    }

    public void setImport(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (clazz.isPrimitive() || clazz.getPackage().getName().startsWith("java.lang")) continue;
            this.imports.add(clazz);
            this.importDesc.add(String.format("%s.%s", clazz.getPackage().getName(), clazz.getSimpleName()));
        }
    }

    public void setImport(Set<Class<?>> classes) {
        if (classes == null) {
            return;
        }
        for (Class<?> clazz : classes) {
            this.setImport(clazz);
        }
    }

    public void setRemarks(String remarks) {
        this.remarks = this.deleteHiddenCharacter(remarks);
        if (!StringUtil.isEmpty((CharSequence)this.remarks)) {
            this.setImport(Remark.class);
        }
    }

    public String deleteHiddenCharacter(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("[\\s]+", "");
    }

    public void addAnnotation(Annotation annotation, AnnotationType annotationType, Consumer<String> consumer) {
        if (BaseModel.getProperties().getAnnotation().contains((Object)annotationType)) {
            consumer.accept(BaseModel.toString(annotation, (Class<?> xva$0) -> this.setImport((Class<?>)xva$0)));
        }
    }

    public void addAnnotation(Class<? extends Annotation> annotation, AnnotationType annotationType, Consumer<String> consumer) {
        if (BaseModel.getProperties().getAnnotation().contains((Object)annotationType)) {
            consumer.accept(BaseModel.toString(annotation, (Class<?> xva$0) -> this.setImport((Class<?>)xva$0)));
        }
    }

    public static GeneratorProperties getProperties() {
        return properties;
    }

    public static DataSourceProperties getDataSourceProperties() {
        return dataSourceProperties;
    }

    public void setImports(Set<Class<?>> imports) {
        this.imports = imports;
    }

    public void setImportDesc(Set<String> importDesc) {
        this.importDesc = importDesc;
    }

    public void setAnnotationDesc(Set<String> annotationDesc) {
        this.annotationDesc = annotationDesc;
    }

    public Set<Class<?>> getImports() {
        return this.imports;
    }

    public Set<String> getImportDesc() {
        return this.importDesc;
    }

    public Set<String> getAnnotationDesc() {
        return this.annotationDesc;
    }

    public String getRemarks() {
        return this.remarks;
    }
}

