/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.generator.properties;

import cloud.agileframework.generator.properties.AnnotationType;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="agile.generator")
public class GeneratorProperties {
    private String entityUrl;
    private String javaSourceUtl;
    private String serviceUrl;
    private String testUrl;
    private String entityPrefix = "";
    private String entitySuffix = "Entity";
    private String servicePrefix = "";
    private String serviceSuffix = "Service";
    private String testPrefix = "";
    private String testSuffix = "Test";
    private String tableName = "%";
    private boolean isSensitive = false;
    private Map<String, Class<?>> columnType = new HashMap();
    private Set<AnnotationType> annotation = Sets.newHashSet();
    private List<String> keywords = Lists.newArrayList();

    public String getJavaSourceUtl() {
        return this.javaSourceUtl;
    }

    public void setJavaSourceUtl(String javaSourceUtl) {
        this.javaSourceUtl = javaSourceUtl;
    }

    public Class<?> getJavaType(String type) {
        return this.columnType.get(type);
    }

    public GeneratorProperties() {
        this.columnType.put("bigint", Long.class);
        this.columnType.put("bit", Boolean.class);
        this.columnType.put("char", String.class);
        this.columnType.put("datetime", Date.class);
        this.columnType.put("time", Date.class);
        this.columnType.put("date", Date.class);
        this.columnType.put("mediumtext", String.class);
        this.columnType.put("bolb", byte[].class);
        this.columnType.put("clob", String.class);
        this.columnType.put("decimal", Double.class);
        this.columnType.put("double", Double.class);
        this.columnType.put("float", Float.class);
        this.columnType.put("image", byte[].class);
        this.columnType.put("int", Integer.class);
        this.columnType.put("longblob", Byte.class);
        this.columnType.put("money", Double.class);
        this.columnType.put("nchar", String.class);
        this.columnType.put("number", BigDecimal.class);
        this.columnType.put("numeric", Double.class);
        this.columnType.put("nvarchar", String.class);
        this.columnType.put("real", Double.class);
        this.columnType.put("smallint", Double.class);
        this.columnType.put("text", String.class);
        this.columnType.put("timestamp", Date.class);
        this.columnType.put("tinyint", Integer.class);
        this.columnType.put("varchar", String.class);
        this.columnType.put("varchar2", String.class);
        this.columnType.put("tinytext", String.class);
        this.columnType.put("longtext", String.class);
        this.columnType.put("character", String.class);
        this.keywords.add("order");
        this.keywords.add("dec");
        this.keywords.add("desc");
        this.keywords.add("name");
        this.keywords.add("code");
        this.keywords.add("status");
        this.keywords.add("where");
        this.keywords.add("select");
        this.keywords.add("mode");
    }

    public String getEntityUrl() {
        return this.entityUrl;
    }

    public void setEntityUrl(String entityUrl) {
        this.entityUrl = entityUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    public String getEntityPrefix() {
        return this.entityPrefix;
    }

    public void setEntityPrefix(String entityPrefix) {
        this.entityPrefix = entityPrefix;
    }

    public String getEntitySuffix() {
        return this.entitySuffix;
    }

    public void setEntitySuffix(String entitySuffix) {
        this.entitySuffix = entitySuffix;
    }

    public String getServicePrefix() {
        return this.servicePrefix;
    }

    public void setServicePrefix(String servicePrefix) {
        this.servicePrefix = servicePrefix;
    }

    public String getServiceSuffix() {
        return this.serviceSuffix;
    }

    public void setServiceSuffix(String serviceSuffix) {
        this.serviceSuffix = serviceSuffix;
    }

    public String getTestPrefix() {
        return this.testPrefix;
    }

    public void setTestPrefix(String testPrefix) {
        this.testPrefix = testPrefix;
    }

    public String getTestSuffix() {
        return this.testSuffix;
    }

    public void setTestSuffix(String testSuffix) {
        this.testSuffix = testSuffix;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isSensitive() {
        return this.isSensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.isSensitive = sensitive;
    }

    public Map<String, Class<?>> getColumnType() {
        return this.columnType;
    }

    public void setColumnType(Map<String, Class<?>> columnType) {
        this.columnType = columnType;
    }

    public Set<AnnotationType> getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Set<AnnotationType> annotation) {
        this.annotation = annotation;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }
}

